/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodRequests;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ap;
import kotlinx.coroutines.aw;
import kotlinx.coroutines.i;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Picture;
import org.jetbrains.skia.PictureRecorder;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.FrameBuffering;
import org.jetbrains.skiko.FrameWatcher;
import org.jetbrains.skiko.FullscreenAdapter;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.HardwareLayer;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.PictureHolder;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderFactory;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_awtKt;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 \u00c7\u00012\u00020\u0001:\u0004\u00c7\u0001\u00c8\u0001B[\b\u0016\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B;\b\u0016\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0014BE\b\u0000\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010r\u001a\u00020l2\b\u0010s\u001a\u0004\u0018\u00010tH\u0016J\u0010\u0010u\u001a\u00020l2\u0006\u0010s\u001a\u00020vH\u0016J\u0010\u0010w\u001a\u00020l2\u0006\u0010s\u001a\u00020xH\u0016J\u0010\u0010y\u001a\u00020l2\u0006\u0010s\u001a\u00020zH\u0016J\u0010\u0010{\u001a\u00020l2\u0006\u0010s\u001a\u00020|H\u0016J\u0010\u0010}\u001a\u00020l2\u0006\u0010s\u001a\u00020~H\u0016J\b\u0010\u007f\u001a\u00020lH\u0016J\u0011\u0010\u0080\u0001\u001a\u00020l2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\u0010\u0010\u0080\u0001\u001a\u00020l2\u0007\u0010\u0083\u0001\u001a\u00020'J\u0007\u0010\u0084\u0001\u001a\u00020lJ\t\u0010\u0085\u0001\u001a\u00020lH\u0002J\u0007\u0010\u0086\u0001\u001a\u00020lJ\t\u0010\u0087\u0001\u001a\u00020lH\u0016J\t\u0010\u0088\u0001\u001a\u00020lH\u0016J\u0018\u0010\u0089\u0001\u001a\u00020l2\u0007\u0010\u001d\u001a\u00030\u008a\u0001H\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0012\u0010\u008c\u0001\u001a\u00020l2\u0007\u0010\u008d\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u008e\u0001\u001a\u00020\u0007H\u0016J\u0016\u0010\u008f\u0001\u001a\t\u0012\u0004\u0012\u00020v0\u0090\u0001H\u0016\u00a2\u0006\u0003\u0010\u0091\u0001J\t\u0010\u0092\u0001\u001a\u00020\u0007H\u0016J#\u0010\u0093\u0001\u001a\u00020l2\u000e\u0010\u0094\u0001\u001a\t\u0012\u0004\u0012\u00020l0\u0095\u0001H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0003\b\u0096\u0001J\u0014\u0010\u0097\u0001\u001a\u00020l2\t\b\u0002\u0010\u0098\u0001\u001a\u00020\u0007H\u0002J\t\u0010\u0099\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u009a\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u009b\u0001\u001a\u00020\u0007H\u0016J3\u0010\u009c\u0001\u001a\u0005\u0018\u0001H\u009d\u0001\"\t\b\u0000\u0010\u009d\u0001*\u00020'2\u0014\u0010\u009e\u0001\u001a\u000f\u0012\u0004\u0012\u00020K\u0012\u0005\u0012\u0003H\u009d\u00010\u0003H\u0002\u00a2\u0006\u0003\u0010\u009f\u0001J\u0007\u0010\u00a0\u0001\u001a\u00020lJ\u0012\u0010\u00a1\u0001\u001a\u00020l2\u0007\u0010\u00a2\u0001\u001a\u00020kH\u0002J%\u0010\u00a3\u0001\u001a\u00020l2\u0007\u0010\u00a2\u0001\u001a\u00020k2\u0013\u0010\u00a4\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020l0\u0003J\u0013\u0010\u00a5\u0001\u001a\u00020l2\b\u0010\u00a6\u0001\u001a\u00030\u00a7\u0001H\u0016J\u0015\u0010\u00a8\u0001\u001a\u00020l2\n\u0010\u00a9\u0001\u001a\u0005\u0018\u00010\u00aa\u0001H\u0014J\u0013\u0010\u00ab\u0001\u001a\u00020l2\b\u0010s\u001a\u0004\u0018\u00010tH\u0016J\u0011\u0010\u00ac\u0001\u001a\u00020l2\u0006\u0010s\u001a\u00020vH\u0016J\u0011\u0010\u00ad\u0001\u001a\u00020l2\u0006\u0010s\u001a\u00020xH\u0016J\u0011\u0010\u00ae\u0001\u001a\u00020l2\u0006\u0010s\u001a\u00020zH\u0016J\u0011\u0010\u00af\u0001\u001a\u00020l2\u0006\u0010s\u001a\u00020|H\u0016J\u0011\u0010\u00b0\u0001\u001a\u00020l2\u0006\u0010s\u001a\u00020~H\u0016J\t\u0010\u00b1\u0001\u001a\u00020lH\u0016J\t\u0010\u00b2\u0001\u001a\u00020lH\u0016J\u0015\u0010\u00b2\u0001\u001a\u00020l2\n\u0010\u00b3\u0001\u001a\u0005\u0018\u00010\u00b4\u0001H\u0016J\t\u0010\u00b5\u0001\u001a\u00020\u0007H\u0016J\u0015\u0010\u00b5\u0001\u001a\u00020\u00072\n\u0010\u00b3\u0001\u001a\u0005\u0018\u00010\u00b4\u0001H\u0016J\u0012\u0010\u00b6\u0001\u001a\u00020l2\t\u0010\u00b7\u0001\u001a\u0004\u0018\u00010\u0005J\n\u0010\u00b8\u0001\u001a\u0005\u0018\u00010\u00b9\u0001J-\u0010\u00ba\u0001\u001a\u00020l2\u0007\u0010\u00bb\u0001\u001a\u0002032\u0007\u0010\u00bc\u0001\u001a\u0002032\u0007\u0010\u00bd\u0001\u001a\u0002032\u0007\u0010\u00be\u0001\u001a\u000203H\u0016J\u0012\u0010\u00bf\u0001\u001a\u00020l2\u0007\u0010\u00c0\u0001\u001a\u00020\u0007H\u0016J\u0012\u0010\u00c1\u0001\u001a\u00020l2\u0007\u0010\u00c2\u0001\u001a\u00020\u0007H\u0016J\t\u0010\u00c3\u0001\u001a\u00020lH\u0002J\u0018\u0010\u00c4\u0001\u001a\u00020l2\u0007\u0010\u00c5\u0001\u001a\u00020+H\u0000\u00a2\u0006\u0003\b\u00c6\u0001R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u000107X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b8\u00109R$\u0010;\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u0004\u0018\u00010IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010Q\u001a\u0004\u0018\u00010R8@X\u0080\u0084\u0002\u00a2\u0006\f\u001a\u0004\bU\u0010V*\u0004\bS\u0010TR\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020R0XX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000b\u001a\u00020\f2\u0006\u0010Y\u001a\u00020\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^*\u0004\bZ\u0010TR\u001c\u0010_\u001a\u0004\u0018\u00010`X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010e\u001a\u00020f8F\u00a2\u0006\u0006\u001a\u0004\bg\u0010hR,\u0010i\u001a \u0012\u0004\u0012\u00020k\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020l0\u00030\"0jX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010m\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bn\u0010=\"\u0004\bo\u0010?R\u0011\u0010p\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010-\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00c9\u0001"}, d2={"Lorg/jetbrains/skiko/SkiaLayer;", "Ljavax/swing/JPanel;", "externalAccessibleFactory", "Lkotlin/Function1;", "Ljava/awt/Component;", "Ljavax/accessibility/Accessible;", "isVsyncEnabled", "", "isVsyncFramelimitFallbackEnabled", "frameBuffering", "Lorg/jetbrains/skiko/FrameBuffering;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "pixelGeometry", "Lorg/jetbrains/skia/PixelGeometry;", "(Lkotlin/jvm/functions/Function1;ZZLorg/jetbrains/skiko/FrameBuffering;Lorg/jetbrains/skiko/GraphicsApi;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skia/PixelGeometry;)V", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skia/PixelGeometry;)V", "renderFactory", "Lorg/jetbrains/skiko/RenderFactory;", "(Lkotlin/jvm/functions/Function1;Lorg/jetbrains/skiko/SkiaLayerProperties;Lorg/jetbrains/skiko/RenderFactory;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skia/PixelGeometry;)V", "_transparency", "backedLayer", "Lorg/jetbrains/skiko/HardwareLayer;", "getBackedLayer$skiko", "()Lorg/jetbrains/skiko/HardwareLayer;", "canvas", "Ljava/awt/Canvas;", "getCanvas", "()Ljava/awt/Canvas;", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "component", "", "getComponent", "()Ljava/lang/Object;", "contentHandle", "", "getContentHandle", "()J", "contentScale", "", "getContentScale", "()F", "currentDPI", "", "getCurrentDPI", "()I", "fpsCounter", "Lorg/jetbrains/skiko/FPSCounter;", "getFpsCounter$annotations", "()V", "value", "fullscreen", "getFullscreen", "()Z", "setFullscreen", "(Z)V", "fullscreenAdapter", "Lorg/jetbrains/skiko/FullscreenAdapter;", "isDisposed", "isInited", "isRendering", "isShowingCached", "latestReceivedGraphicsContextScaleTransform", "Ljava/awt/geom/AffineTransform;", "peerBufferSizeFixJob", "Lkotlinx/coroutines/Job;", "picture", "Lorg/jetbrains/skiko/PictureHolder;", "pictureLock", "pictureRecorder", "Lorg/jetbrains/skia/PictureRecorder;", "getPixelGeometry", "()Lorg/jetbrains/skia/PixelGeometry;", "redrawer", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "getRedrawer$skiko$delegate", "(Lorg/jetbrains/skiko/SkiaLayer;)Ljava/lang/Object;", "getRedrawer$skiko", "()Lorg/jetbrains/skiko/redrawer/Redrawer;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "<set-?>", "getRenderApi$delegate", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "setRenderApi", "(Lorg/jetbrains/skiko/GraphicsApi;)V", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "getRenderDelegate", "()Lorg/jetbrains/skiko/SkikoRenderDelegate;", "setRenderDelegate", "(Lorg/jetbrains/skiko/SkikoRenderDelegate;)V", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "stateChangeListeners", "", "Lorg/jetbrains/skiko/SkiaLayer$PropertyKind;", "", "transparency", "getTransparency", "setTransparency", "windowHandle", "getWindowHandle", "addFocusListener", "l", "Ljava/awt/event/FocusListener;", "addInputMethodListener", "Ljava/awt/event/InputMethodListener;", "addKeyListener", "Ljava/awt/event/KeyListener;", "addMouseListener", "Ljava/awt/event/MouseListener;", "addMouseMotionListener", "Ljava/awt/event/MouseMotionListener;", "addMouseWheelListener", "Ljava/awt/event/MouseWheelListener;", "addNotify", "attachTo", "jComponent", "Ljavax/swing/JComponent;", "container", "checkContentScale", "checkShowing", "detach", "dispose", "doLayout", "draw", "Lorg/jetbrains/skia/Canvas;", "draw$skiko", "enableInputMethods", "enable", "getFocusTraversalKeysEnabled", "getInputMethodListeners", "", "()[Ljava/awt/event/InputMethodListener;", "hasFocus", "inDrawScope", "body", "Lkotlin/Function0;", "inDrawScope$skiko", "init", "recreation", "isFocusOwner", "isFocusable", "isShowing", "lockPicture", "T", "action", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "needRedraw", "notifyChange", "kind", "onStateChanged", "handler", "paint", "g", "Ljava/awt/Graphics;", "processInputMethodEvent", "e", "Ljava/awt/event/InputMethodEvent;", "removeFocusListener", "removeInputMethodListener", "removeKeyListener", "removeMouseListener", "removeMouseMotionListener", "removeMouseWheelListener", "removeNotify", "requestFocus", "cause", "Ljava/awt/event/FocusEvent$Cause;", "requestFocusInWindow", "requestNativeFocusOnAccessible", "accessible", "screenshot", "Lorg/jetbrains/skia/Bitmap;", "setBounds", "x", "y", "width", "height", "setFocusTraversalKeysEnabled", "focusTraversalKeysEnabled", "setFocusable", "focusable", "tryRedrawImmediately", "update", "nanoTime", "update$skiko", "Companion", "PropertyKind", "skiko"})
public class SkiaLayer
extends JPanel {
    public static final Companion Companion = new Companion(null);
    private final SkiaLayerProperties properties;
    private final RenderFactory renderFactory;
    private final SkiaLayerAnalytics analytics;
    private final PixelGeometry pixelGeometry;
    private boolean _transparency;
    private final HardwareLayer backedLayer;
    private aw peerBufferSizeFixJob;
    private AffineTransform latestReceivedGraphicsContextScaleTransform;
    private FullscreenAdapter fullscreenAdapter;
    private boolean isInited;
    private boolean isRendering;
    private boolean isShowingCached;
    private SkikoRenderDelegate renderDelegate;
    private final List<ClipRectangle> clipComponents;
    private volatile boolean isDisposed;
    private final RedrawerManager<Redrawer> redrawerManager;
    private volatile PictureHolder picture;
    private PictureRecorder pictureRecorder;
    private final Object pictureLock;
    private final Map<PropertyKind, List<Function1<SkiaLayer, Unit>>> stateChangeListeners;
    private final FPSCounter fpsCounter;

    public SkiaLayer(Function1<? super Component, ? extends Accessible> function1, SkiaLayerProperties skiaLayerProperties, RenderFactory renderFactory, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry) {
        Intrinsics.checkNotNullParameter((Object)skiaLayerProperties, (String)"");
        Intrinsics.checkNotNullParameter((Object)renderFactory, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelGeometry), (String)"");
        this.properties = skiaLayerProperties;
        this.renderFactory = renderFactory;
        this.analytics = skiaLayerAnalytics;
        this.pixelGeometry = pixelGeometry;
        this.setOpaque(false);
        this.setLayout(null);
        this.backedLayer = new HardwareLayer(function1){

            @Override
            public void paint(Graphics graphics) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)graphics, (String)"");
                    Logger logger = Logger.INSTANCE;
                    boolean bl = false;
                    if (logger.getLoggerImpl().isDebugEnabled()) {
                        SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                        boolean bl2 = false;
                        skikoLoggerInterface.debug("Paint called on " + this);
                    }
                    this.checkContentScale();
                    Redrawer redrawer = this.getRedrawer$skiko();
                    if (redrawer == null) break block1;
                    redrawer.needRedraw();
                }
            }

            @Override
            public InputMethodRequests getInputMethodRequests() {
                return this.getInputMethodRequests();
            }

            @Override
            public void requestFocus(FocusEvent.Cause cause) {
                if (this.canReceiveFocus(cause)) {
                    super.requestFocus(cause);
                }
            }

            @Override
            public boolean requestFocusInWindow(FocusEvent.Cause cause) {
                return this.canReceiveFocus(cause) && super.requestFocusInWindow(cause);
            }

            private final boolean canReceiveFocus(FocusEvent.Cause cause) {
                return cause != FocusEvent.Cause.MOUSE_EVENT || this.isRequestFocusEnabled();
            }
        };
        this.add(this.backedLayer);
        this.addAncestorListener(new AncestorListener(){
            private Point positionInWindow;
            private final Point zeroPoint = new Point(0, 0);

            private final Point computePositionInWindow() {
                Window window = SwingUtilities.getWindowAncestor(this);
                return window == null ? null : SwingUtilities.convertPoint(this, this.zeroPoint, window);
            }

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                this.positionInWindow = this.computePositionInWindow();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                this.positionInWindow = null;
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                Point point = this.computePositionInWindow();
                if (this.positionInWindow != null && !Intrinsics.areEqual((Object)this.positionInWindow, (Object)point)) {
                    this.revalidate();
                }
                this.positionInWindow = point;
            }
        });
        this.backedLayer.addHierarchyListener(arg_0 -> SkiaLayer._init_$lambda$0(this, arg_0));
        this.addPropertyChangeListener("graphicsContextScaleTransform", arg_0 -> SkiaLayer._init_$lambda$2(this, arg_0));
        this.fullscreenAdapter = new FullscreenAdapter(this.backedLayer);
        this.clipComponents = new ArrayList();
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), (Function2)new Function2<GraphicsApi, Redrawer, Redrawer>(this){
            final /* synthetic */ SkiaLayer this$0;
            {
                this.this$0 = skiaLayer;
                super(2);
            }

            public final Redrawer invoke(GraphicsApi graphicsApi, Redrawer redrawer) {
                Redrawer redrawer2;
                Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
                Redrawer redrawer3 = redrawer;
                if (redrawer3 != null) {
                    redrawer3.dispose();
                }
                Redrawer redrawer4 = redrawer2 = SkiaLayer.access$getRenderFactory$p(this.this$0).createRedrawer(this.this$0, graphicsApi, SkiaLayer.access$getAnalytics$p(this.this$0), SkiaLayer.access$getProperties$p(this.this$0));
                boolean bl = false;
                redrawer4.syncBounds();
                return redrawer2;
            }
        }, (Function1<? super GraphicsApi, Unit>)((Function1)new Function1<GraphicsApi, Unit>(this){
            final /* synthetic */ SkiaLayer this$0;
            {
                this.this$0 = skiaLayer;
                super(1);
            }

            public final void invoke(GraphicsApi graphicsApi) {
                Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
                SkiaLayer.access$notifyChange(this.this$0, PropertyKind.Renderer);
            }
        }));
        this.pictureLock = new Object();
        this.stateChangeListeners = new LinkedHashMap();
        this.fpsCounter = SkiaLayer_awtKt.defaultFPSCounter(this);
    }

    public /* synthetic */ SkiaLayer(Function1 function1, SkiaLayerProperties skiaLayerProperties, RenderFactory renderFactory, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            function1 = null;
        }
        if ((n2 & 4) != 0) {
            renderFactory = RenderFactory.Companion.getDefault();
        }
        if ((n2 & 8) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n2 & 0x10) != 0) {
            pixelGeometry = PixelGeometry.UNKNOWN;
        }
        this((Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties, renderFactory, skiaLayerAnalytics, pixelGeometry);
    }

    public final PixelGeometry getPixelGeometry() {
        return this.pixelGeometry;
    }

    public final boolean getTransparency() {
        return this._transparency;
    }

    public final void setTransparency(boolean bl) {
        this._transparency = bl;
        if (!bl) {
            this.setBackground(UIManager.getColor("Panel.background"));
        } else {
            this.setBackground(new Color(0, 0, 0, 0));
        }
    }

    public final HardwareLayer getBackedLayer$skiko() {
        return this.backedLayer;
    }

    public SkiaLayer(Function1<? super Component, ? extends Accessible> function1, boolean bl, boolean bl2, FrameBuffering frameBuffering, GraphicsApi graphicsApi, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry) {
        Intrinsics.checkNotNullParameter((Object)((Object)frameBuffering), (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelGeometry), (String)"");
        this(function1, new SkiaLayerProperties(bl, bl2, frameBuffering, graphicsApi, null, 16, null), RenderFactory.Companion.getDefault(), skiaLayerAnalytics, pixelGeometry);
    }

    public /* synthetic */ SkiaLayer(Function1 function1, boolean bl, boolean bl2, FrameBuffering frameBuffering, GraphicsApi graphicsApi, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            function1 = null;
        }
        if ((n2 & 2) != 0) {
            bl = SkikoProperties.INSTANCE.getVsyncEnabled();
        }
        if ((n2 & 4) != 0) {
            bl2 = SkikoProperties.INSTANCE.getVsyncFramelimitFallbackEnabled();
        }
        if ((n2 & 8) != 0) {
            frameBuffering = SkikoProperties.INSTANCE.getFrameBuffering();
        }
        if ((n2 & 0x10) != 0) {
            graphicsApi = SkikoProperties.INSTANCE.getRenderApi();
        }
        if ((n2 & 0x20) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n2 & 0x40) != 0) {
            pixelGeometry = PixelGeometry.UNKNOWN;
        }
        this((Function1<? super Component, ? extends Accessible>)function1, bl, bl2, frameBuffering, graphicsApi, skiaLayerAnalytics, pixelGeometry);
    }

    public SkiaLayer(Function1<? super Component, ? extends Accessible> function1, SkiaLayerProperties skiaLayerProperties, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry) {
        Intrinsics.checkNotNullParameter((Object)skiaLayerProperties, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelGeometry), (String)"");
        this(function1, skiaLayerProperties, RenderFactory.Companion.getDefault(), skiaLayerAnalytics, pixelGeometry);
    }

    public /* synthetic */ SkiaLayer(Function1 function1, SkiaLayerProperties skiaLayerProperties, SkiaLayerAnalytics skiaLayerAnalytics, PixelGeometry pixelGeometry, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            function1 = null;
        }
        if ((n2 & 4) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        if ((n2 & 8) != 0) {
            pixelGeometry = PixelGeometry.UNKNOWN;
        }
        this((Function1<? super Component, ? extends Accessible>)function1, skiaLayerProperties, skiaLayerAnalytics, pixelGeometry);
    }

    public final Canvas getCanvas() {
        return this.backedLayer;
    }

    @Override
    public void removeNotify() {
        Object object = Logger.INSTANCE;
        boolean bl = false;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = ((Logger)object).getLoggerImpl();
            boolean bl2 = false;
            skikoLoggerInterface.debug("SkiaLayer.awt#removeNotify " + this);
        }
        object = SwingUtilities.getWindowAncestor(this);
        ((Component)object).removeComponentListener(this.fullscreenAdapter);
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Object object = Logger.INSTANCE;
        boolean bl = false;
        if (((Logger)object).getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = ((Logger)object).getLoggerImpl();
            boolean bl2 = false;
            skikoLoggerInterface.debug("SkiaLayer.awt#addNotify " + this);
        }
        super.addNotify();
        object = SwingUtilities.getWindowAncestor(this);
        ((Component)object).addComponentListener(this.fullscreenAdapter);
        this.checkShowing();
        this.init(this.isInited);
    }

    public final void detach() {
        this.dispose();
    }

    private final void checkShowing() {
        boolean bl;
        boolean bl2 = this.isShowingCached;
        boolean bl3 = bl = super.isShowing();
        boolean bl4 = false;
        this.isShowingCached = bl3;
        boolean bl5 = bl;
        if (bl2 != bl5 && SwingUtilities.getWindowAncestor(this).isShowing()) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.setVisible(bl5);
            }
        }
        if (bl5) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.syncBounds();
            }
            this.repaint();
        }
    }

    @Override
    public boolean isShowing() {
        return this.isShowingCached;
    }

    public final float getContentScale() {
        return (float)this.getGraphicsConfiguration().getDefaultTransform().getScaleX();
    }

    public final long getContentHandle() {
        return this.backedLayer.getContentHandle();
    }

    public final long getWindowHandle() {
        return this.backedLayer.getWindowHandle();
    }

    public final int getCurrentDPI() {
        return this.backedLayer.getCurrentDPI();
    }

    public final boolean getFullscreen() {
        return this.fullscreenAdapter.getFullscreen();
    }

    public final void setFullscreen(boolean bl) {
        this.fullscreenAdapter.setFullscreen(bl);
    }

    public final Object getComponent() {
        return this.backedLayer;
    }

    public final SkikoRenderDelegate getRenderDelegate() {
        return this.renderDelegate;
    }

    public final void setRenderDelegate(SkikoRenderDelegate skikoRenderDelegate) {
        this.renderDelegate = skikoRenderDelegate;
    }

    public final void attachTo(Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        this.attachTo((JComponent)object);
    }

    public final void attachTo(JComponent jComponent) {
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"");
        jComponent.add(this);
    }

    public final List<ClipRectangle> getClipComponents() {
        return this.clipComponents;
    }

    public final Redrawer getRedrawer$skiko() {
        return this.redrawerManager.getRedrawer();
    }

    private static Object getRedrawer$skiko$delegate(SkiaLayer skiaLayer) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(skiaLayer.redrawerManager, RedrawerManager.class, "redrawer", "getRedrawer()Ljava/lang/Object;", 0)));
    }

    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    public final void setRenderApi(GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        this.redrawerManager.setRenderApi(graphicsApi);
    }

    private static Object getRenderApi$delegate(SkiaLayer skiaLayer) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl(skiaLayer.redrawerManager, RedrawerManager.class, "renderApi", "getRenderApi()Lorg/jetbrains/skiko/GraphicsApi;", 0)));
    }

    public final String getRenderInfo() {
        String string;
        if (this.getRedrawer$skiko() == null) {
            string = "SkiaLayer isn't initialized yet";
        } else {
            Redrawer redrawer = this.getRedrawer$skiko();
            Intrinsics.checkNotNull((Object)redrawer);
            string = redrawer.getRenderInfo();
        }
        return string;
    }

    private final void init(boolean bl) {
        this.isDisposed = false;
        this.backedLayer.init();
        this.pictureRecorder = new PictureRecorder();
        this.redrawerManager.findNextWorkingRenderApi(bl);
        this.isInited = true;
    }

    static /* synthetic */ void init$default(SkiaLayer skiaLayer, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n2 & 1) != 0) {
            bl = false;
        }
        skiaLayer.init(bl);
    }

    public final void onStateChanged(PropertyKind propertyKind, Function1<? super SkiaLayer, Unit> function1) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)propertyKind), (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Map<PropertyKind, List<Function1<SkiaLayer, Unit>>> map = this.stateChangeListeners;
        boolean bl = false;
        List list3 = map.get((Object)propertyKind);
        if (list3 == null) {
            boolean bl2 = false;
            List list4 = new ArrayList();
            map.put(propertyKind, list4);
            list2 = list4;
        } else {
            list2 = list3;
        }
        ((Collection)list2).add(function1);
    }

    private final void notifyChange(PropertyKind propertyKind) {
        block1: {
            List<Function1<SkiaLayer, Unit>> list2 = this.stateChangeListeners.get((Object)propertyKind);
            if (list2 == null) break block1;
            List<Function1<SkiaLayer, Unit>> list3 = list2;
            boolean bl = false;
            Iterable iterable = list3;
            boolean bl2 = false;
            for (Object t : iterable) {
                Function1 function1 = (Function1)t;
                boolean bl3 = false;
                function1.invoke((Object)this);
            }
        }
    }

    public void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInited && !this.isDisposed) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.dispose();
            }
            this.redrawerManager.dispose();
            Object object = this.picture;
            if (object != null && (object = ((PictureHolder)object).getInstance()) != null) {
                ((Managed)object).close();
            }
            this.picture = null;
            PictureRecorder pictureRecorder = this.pictureRecorder;
            if (pictureRecorder != null) {
                pictureRecorder.close();
            }
            this.pictureRecorder = null;
            this.backedLayer.dispose();
            aw aw2 = this.peerBufferSizeFixJob;
            if (aw2 != null) {
                aw.a.a((aw)aw2, null, (int)1, null);
            }
            this.isDisposed = true;
        }
    }

    @Override
    public void doLayout() {
        block1: {
            Logger logger = Logger.INSTANCE;
            boolean bl = false;
            if (logger.getLoggerImpl().isDebugEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                boolean bl2 = false;
                skikoLoggerInterface.debug("doLayout on " + this);
            }
            this.backedLayer.setBounds(0, 0, SkiaLayer_awtKt.access$adjustSizeToContentScale(this.getContentScale(), this.getWidth()), SkiaLayer_awtKt.access$adjustSizeToContentScale(this.getContentScale(), this.getHeight()));
            this.backedLayer.validate();
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer == null) break block1;
            redrawer.syncBounds();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"");
        Logger logger = Logger.INSTANCE;
        boolean bl = false;
        if (logger.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
            boolean bl2 = false;
            skikoLoggerInterface.debug("Paint called on: " + this);
        }
        this.checkContentScale();
        this.tryRedrawImmediately();
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        super.setBounds(n2, n3, n4, n5);
        if (this.getRenderApi() == GraphicsApi.DIRECT3D && this.isShowing()) {
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer != null) {
                redrawer.syncBounds();
            }
            this.tryRedrawImmediately();
        }
    }

    private final void tryRedrawImmediately() {
        block1: {
            block0: {
                if (!this.isRendering) break block0;
                Redrawer redrawer = this.getRedrawer$skiko();
                if (redrawer == null) break block1;
                redrawer.needRedraw();
                break block1;
            }
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer == null) break block1;
            redrawer.redrawImmediately();
        }
    }

    public final void checkContentScale() {
        AffineTransform affineTransform = this.getGraphicsConfiguration().getDefaultTransform();
        if (!Intrinsics.areEqual((Object)affineTransform, (Object)this.latestReceivedGraphicsContextScaleTransform)) {
            this.firePropertyChange("graphicsContextScaleTransform", this.latestReceivedGraphicsContextScaleTransform, affineTransform);
        }
    }

    @Override
    public void enableInputMethods(boolean bl) {
        this.backedLayer.enableInputMethods(bl);
    }

    @Override
    public InputMethodListener[] getInputMethodListeners() {
        InputMethodListener[] inputMethodListenerArray = this.backedLayer.getInputMethodListeners();
        Intrinsics.checkNotNullExpressionValue((Object)inputMethodListenerArray, (String)"");
        return inputMethodListenerArray;
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        this.backedLayer.doProcessInputMethodEvent(inputMethodEvent);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.backedLayer.addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.backedLayer.removeFocusListener(focusListener);
    }

    @Override
    public void setFocusable(boolean bl) {
        this.backedLayer.setFocusable(bl);
    }

    @Override
    public boolean isFocusable() {
        return this.backedLayer.isFocusable();
    }

    @Override
    public boolean hasFocus() {
        return this.backedLayer.hasFocus();
    }

    @Override
    public boolean isFocusOwner() {
        return this.backedLayer.isFocusOwner();
    }

    @Override
    public void requestFocus() {
        this.backedLayer.requestFocus();
    }

    @Override
    public void requestFocus(FocusEvent.Cause cause) {
        this.backedLayer.requestFocus(cause);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.backedLayer.requestFocusInWindow();
    }

    @Override
    public boolean requestFocusInWindow(FocusEvent.Cause cause) {
        return this.backedLayer.requestFocusInWindow(cause);
    }

    @Override
    public void setFocusTraversalKeysEnabled(boolean bl) {
        this.backedLayer.setFocusTraversalKeysEnabled(bl);
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return this.backedLayer.getFocusTraversalKeysEnabled();
    }

    @Override
    public void addInputMethodListener(InputMethodListener inputMethodListener) {
        Intrinsics.checkNotNullParameter((Object)inputMethodListener, (String)"");
        super.addInputMethodListener(inputMethodListener);
        this.backedLayer.addInputMethodListener(inputMethodListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        Intrinsics.checkNotNullParameter((Object)mouseListener, (String)"");
        this.backedLayer.addMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        Intrinsics.checkNotNullParameter((Object)mouseMotionListener, (String)"");
        this.backedLayer.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelListener, (String)"");
        this.backedLayer.addMouseWheelListener(mouseWheelListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        Intrinsics.checkNotNullParameter((Object)keyListener, (String)"");
        this.backedLayer.addKeyListener(keyListener);
    }

    @Override
    public void removeInputMethodListener(InputMethodListener inputMethodListener) {
        Intrinsics.checkNotNullParameter((Object)inputMethodListener, (String)"");
        super.removeInputMethodListener(inputMethodListener);
        this.backedLayer.removeInputMethodListener(inputMethodListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        Intrinsics.checkNotNullParameter((Object)mouseListener, (String)"");
        this.backedLayer.removeMouseListener(mouseListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        Intrinsics.checkNotNullParameter((Object)mouseMotionListener, (String)"");
        this.backedLayer.removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelListener, (String)"");
        this.backedLayer.removeMouseWheelListener(mouseWheelListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        Intrinsics.checkNotNullParameter((Object)keyListener, (String)"");
        this.backedLayer.removeKeyListener(keyListener);
    }

    public final void needRedraw() {
        block2: {
            if (!SwingUtilities.isEventDispatchThread()) {
                boolean bl = false;
                String string = "Method should be called from AWT event dispatch thread";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.isDisposed)) {
                boolean bl = false;
                String string = "SkiaLayer is disposed";
                throw new IllegalStateException(string.toString());
            }
            Redrawer redrawer = this.getRedrawer$skiko();
            if (redrawer == null) break block2;
            redrawer.needRedraw();
        }
    }

    private static /* synthetic */ void getFpsCounter$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update$skiko(long l) {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = "SkiaLayer is disposed";
            throw new IllegalStateException(string.toString());
        }
        this.checkContentScale();
        FrameWatcher.INSTANCE.nextFrame();
        FPSCounter fPSCounter = this.fpsCounter;
        if (fPSCounter != null) {
            fPSCounter.tick();
        }
        int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getWidth() * this.getContentScale())), (int)0);
        int n3 = RangesKt.coerceAtLeast((int)((int)((float)this.getHeight() * this.getContentScale())), (int)0);
        Rect rect2 = Rect.Companion.makeWH(n2, n3);
        PictureRecorder pictureRecorder = this.pictureRecorder;
        Intrinsics.checkNotNull((Object)pictureRecorder);
        PictureRecorder pictureRecorder2 = pictureRecorder;
        org.jetbrains.skia.Canvas canvas = PictureRecorder.beginRecording$default(pictureRecorder2, rect2, null, 2, null);
        for (ClipRectangle object : this.clipComponents) {
            SkiaLayer_awtKt.clipRectBy(canvas, object, this.getContentScale());
        }
        try {
            this.isRendering = true;
            SkikoRenderDelegate skikoRenderDelegate = this.renderDelegate;
            if (skikoRenderDelegate != null) {
                skikoRenderDelegate.onRender(canvas, n2, n3, l);
            }
        }
        finally {
            this.isRendering = false;
        }
        if (!this.isDisposed && !pictureRecorder2.isClosed()) {
            Object object = this.pictureLock;
            synchronized (object) {
                boolean unit = false;
                Object object2 = this.picture;
                if (object2 != null && (object2 = ((PictureHolder)object2).getInstance()) != null) {
                    ((Managed)object2).close();
                }
                Picture picture = pictureRecorder2.finishRecordingAsPicture();
                this.picture = new PictureHolder(picture, n2, n3);
                Unit unit2 = Unit.INSTANCE;
            }
        }
    }

    public final void inDrawScope$skiko(Function0<Unit> function0) {
        block7: {
            Intrinsics.checkNotNullParameter(function0, (String)"");
            boolean bl = false;
            if (!SwingUtilities.isEventDispatchThread()) {
                boolean bl2 = false;
                String string = "Method should be called from AWT event dispatch thread";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.isDisposed)) {
                boolean bl3 = false;
                String string = "SkiaLayer is disposed";
                throw new IllegalStateException(string.toString());
            }
            try {
                function0.invoke();
            }
            catch (CancellationException cancellationException) {
            }
            catch (RenderException renderException) {
                if (this.isDisposed) break block7;
                Logger logger = Logger.INSTANCE;
                boolean bl4 = false;
                if (logger.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = renderException;
                    SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                    boolean bl5 = false;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface.warn(throwable, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                Redrawer redrawer = this.getRedrawer$skiko();
                if (redrawer != null) {
                    redrawer.redrawImmediately();
                }
            }
        }
    }

    public final void draw$skiko(org.jetbrains.skia.Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = "SkiaLayer is disposed";
            throw new IllegalStateException(string.toString());
        }
        this.lockPicture((Function1)new Function1<PictureHolder, org.jetbrains.skia.Canvas>(canvas){
            final /* synthetic */ org.jetbrains.skia.Canvas $canvas;
            {
                this.$canvas = canvas;
                super(1);
            }

            public final org.jetbrains.skia.Canvas invoke(PictureHolder pictureHolder) {
                Intrinsics.checkNotNullParameter((Object)pictureHolder, (String)"");
                return org.jetbrains.skia.Canvas.drawPicture$default(this.$canvas, pictureHolder.getInstance(), null, null, 6, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T lockPicture(Function1<? super PictureHolder, ? extends T> function1) {
        Object object;
        Object object2 = this.pictureLock;
        synchronized (object2) {
            boolean bl = false;
            PictureHolder pictureHolder = this.picture;
            object = pictureHolder != null ? function1.invoke((Object)pictureHolder) : null;
        }
        return (T)object;
    }

    public final Bitmap screenshot() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = "SkiaLayer is disposed";
            throw new IllegalStateException(string.toString());
        }
        return (Bitmap)this.lockPicture(screenshot.2.INSTANCE);
    }

    public final void requestNativeFocusOnAccessible(Accessible accessible) {
        this.backedLayer.requestNativeFocusOnAccessible(accessible);
    }

    private static final void _init_$lambda$0(SkiaLayer skiaLayer, HierarchyEvent hierarchyEvent) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
            skiaLayer.checkShowing();
        }
    }

    private static final void _init_$lambda$2(SkiaLayer skiaLayer, PropertyChangeEvent propertyChangeEvent) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Logger logger = Logger.INSTANCE;
        boolean bl = false;
        if (logger.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
            boolean bl2 = false;
            skikoLoggerInterface.debug("graphicsContextScaleTransform changed for " + skiaLayer);
        }
        Object object = propertyChangeEvent.getNewValue();
        Intrinsics.checkNotNull((Object)object);
        skiaLayer.latestReceivedGraphicsContextScaleTransform = (AffineTransform)object;
        skiaLayer.revalidate();
        skiaLayer.notifyChange(PropertyKind.ContentScale);
        if (OsArch_jvmKt.getHostOs() == OS.Windows) {
            aw aw2 = skiaLayer.peerBufferSizeFixJob;
            if (aw2 != null) {
                aw.a.a((aw)aw2, null, (int)1, null);
            }
            skiaLayer.peerBufferSizeFixJob = i.a((CoroutineScope)((CoroutineScope)ap.a), (CoroutineContext)((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(skiaLayer, null){
                int label;
                final /* synthetic */ SkiaLayer this$0;
                {
                    this.this$0 = skiaLayer;
                    super(2, continuation);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.this$0.getBackedLayer$skiko().setLocation(1, 0);
                            this.this$0.getBackedLayer$skiko().setLocation(0, 0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope coroutineScope, Continuation<? super Unit> continuation) {
                    return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public static final /* synthetic */ RenderFactory access$getRenderFactory$p(SkiaLayer skiaLayer) {
        return skiaLayer.renderFactory;
    }

    public static final /* synthetic */ SkiaLayerAnalytics access$getAnalytics$p(SkiaLayer skiaLayer) {
        return skiaLayer.analytics;
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaLayer skiaLayer) {
        return skiaLayer.properties;
    }

    public static final /* synthetic */ void access$notifyChange(SkiaLayer skiaLayer, PropertyKind propertyKind) {
        skiaLayer.notifyChange(propertyKind);
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/SkiaLayer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/skiko/SkiaLayer$PropertyKind;", "", "(Ljava/lang/String;I)V", "Renderer", "ContentScale", "skiko"})
    public static final class PropertyKind
    extends Enum<PropertyKind> {
        public static final /* enum */ PropertyKind Renderer = new PropertyKind();
        public static final /* enum */ PropertyKind ContentScale = new PropertyKind();
        private static final /* synthetic */ PropertyKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PropertyKind[] values() {
            return (PropertyKind[])$VALUES.clone();
        }

        public static PropertyKind valueOf(String string) {
            return Enum.valueOf(PropertyKind.class, string);
        }

        public static EnumEntries<PropertyKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = propertyKindArray = new PropertyKind[]{PropertyKind.Renderer, PropertyKind.ContentScale};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

