/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Surface;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/skiko/swing/SoftwareSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "storage", "Lorg/jetbrains/skia/Bitmap;", "dispose", "", "flush", "g", "Ljava/awt/Graphics2D;", "surface", "Lorg/jetbrains/skia/Surface;", "onRender", "width", "", "height", "nanoTime", "", "skiko"})
public final class SoftwareSwingRedrawer
extends SwingRedrawerBase {
    private final SkikoRenderDelegate renderDelegate;
    private final SwingPainter painter;
    private final Bitmap storage;

    public SoftwareSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate skikoRenderDelegate, SkiaLayerAnalytics skiaLayerAnalytics) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skikoRenderDelegate, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        super(swingLayerProperties2, skiaLayerAnalytics, GraphicsApi.SOFTWARE_FAST);
        this.renderDelegate = skikoRenderDelegate;
        this.onDeviceChosen("Software");
        this.painter = new SoftwareSwingPainter(swingLayerProperties2);
        this.storage = new Bitmap();
        this.onContextInit();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.storage.close();
        this.painter.dispose();
    }

    @Override
    protected void onRender(Graphics2D graphics2D, int n2, int n3, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, n2, n3, l, graphics2D){
            final /* synthetic */ SoftwareSwingRedrawer this$0;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ long $nanoTime;
            final /* synthetic */ Graphics2D $g;
            {
                this.this$0 = softwareSwingRedrawer;
                this.$width = n2;
                this.$height = n3;
                this.$nanoTime = l;
                this.$g = graphics2D;
                super(1);
            }

            public final void invoke(CloseScope closeScope) {
                Intrinsics.checkNotNullParameter((Object)closeScope, (String)"");
                if (SoftwareSwingRedrawer.access$getStorage$p(this.this$0).getWidth() != this.$width || SoftwareSwingRedrawer.access$getStorage$p(this.this$0).getHeight() != this.$height) {
                    SoftwareSwingRedrawer.access$getStorage$p(this.this$0).allocPixelsFlags(ImageInfo.Companion.makeS32(this.$width, this.$height, ColorAlphaType.PREMUL), false);
                }
                Pixmap pixmap = SoftwareSwingRedrawer.access$getStorage$p(this.this$0).peekPixels();
                Long l = pixmap != null ? Long.valueOf(pixmap.getAddr()) : null;
                Intrinsics.checkNotNull((Object)l);
                long l2 = l;
                Surface surface = (Surface)closeScope.autoClose((AutoCloseable)Surface.Companion.makeRasterDirect(SoftwareSwingRedrawer.access$getStorage$p(this.this$0).getImageInfo(), l2, SoftwareSwingRedrawer.access$getStorage$p(this.this$0).getRowBytes()));
                surface.getCanvas().clear(0);
                SoftwareSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender(surface.getCanvas(), this.$width, this.$height, this.$nanoTime);
                SoftwareSwingRedrawer.access$flush(this.this$0, this.$g, surface);
            }
        }));
    }

    private final void flush(Graphics2D graphics2D, Surface surface) {
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, graphics2D, surface){
            final /* synthetic */ SoftwareSwingRedrawer this$0;
            final /* synthetic */ Graphics2D $g;
            final /* synthetic */ Surface $surface;
            {
                this.this$0 = softwareSwingRedrawer;
                this.$g = graphics2D;
                this.$surface = surface;
                super(1);
            }

            public final void invoke(CloseScope closeScope) {
                Intrinsics.checkNotNullParameter((Object)closeScope, (String)"");
                SoftwareSwingRedrawer.access$getPainter$p(this.this$0).paint(this.$g, this.$surface, 0L);
            }
        }));
    }

    public static final /* synthetic */ Bitmap access$getStorage$p(SoftwareSwingRedrawer softwareSwingRedrawer) {
        return softwareSwingRedrawer.storage;
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(SoftwareSwingRedrawer softwareSwingRedrawer) {
        return softwareSwingRedrawer.renderDelegate;
    }

    public static final /* synthetic */ void access$flush(SoftwareSwingRedrawer softwareSwingRedrawer, Graphics2D graphics2D, Surface surface) {
        softwareSwingRedrawer.flush(graphics2D, surface);
    }

    public static final /* synthetic */ SwingPainter access$getPainter$p(SoftwareSwingRedrawer softwareSwingRedrawer) {
        return softwareSwingRedrawer.painter;
    }
}

