/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.ChannelException;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.DatagramSocketAddress;
import io.netty.channel.unix.DomainDatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class Socket
extends FileDescriptor {
    private static volatile boolean isIpv6Preferred;
    @Deprecated
    public static final int UDS_SUN_PATH_SIZE = 100;
    protected final boolean ipv6;

    public Socket(int n) {
        super(n);
        this.ipv6 = Socket.isIPv6(n);
    }

    private boolean useIpv6(InetAddress inetAddress) {
        return Socket.useIpv6(this, inetAddress);
    }

    protected static boolean useIpv6(Socket socket, InetAddress inetAddress) {
        return socket.ipv6 || inetAddress instanceof Inet6Address;
    }

    public final void shutdown() {
        this.shutdown(true, true);
    }

    public final void shutdown(boolean bl, boolean bl2) {
        int n;
        int n2;
        do {
            if (Socket.isClosed(n2 = this.state)) {
                throw new ClosedChannelException();
            }
            n = n2;
            if (bl && !Socket.isInputShutdown(n)) {
                n = Socket.inputShutdown(n);
            }
            if (bl2 && !Socket.isOutputShutdown(n)) {
                n = Socket.outputShutdown(n);
            }
            if (n != n2) continue;
            return;
        } while (!this.casState(n2, n));
        n2 = Socket.shutdown(this.fd, bl, bl2);
        if (n2 < 0) {
            Errors.ioResult("shutdown", n2);
        }
    }

    public final boolean isShutdown() {
        int n = this.state;
        return Socket.isInputShutdown(n) && Socket.isOutputShutdown(n);
    }

    public final boolean isInputShutdown() {
        return Socket.isInputShutdown(this.state);
    }

    public final boolean isOutputShutdown() {
        return Socket.isOutputShutdown(this.state);
    }

    public final int sendTo(ByteBuffer byteBuffer, int n, int n2, InetAddress inetAddress, int n3) {
        return this.sendTo(byteBuffer, n, n2, inetAddress, n3, false);
    }

    public final int sendTo(ByteBuffer byteBuffer, int n, int n2, InetAddress inetAddress, int n3, boolean bl) {
        int n4;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n4 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n4 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n5 = bl ? Socket.msgFastopen() : 0;
        int n6 = Socket.sendTo(this.fd, this.useIpv6(inetAddress), byteBuffer, n, n2, byArray, n4, n3, n5);
        if (n6 >= 0) {
            return n6;
        }
        if (n6 == Errors.ERRNO_EINPROGRESS_NEGATIVE && bl) {
            return 0;
        }
        if (n6 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendTo failed");
        }
        return Errors.ioResult("sendTo", n6);
    }

    public final int sendToDomainSocket(ByteBuffer byteBuffer, int n, int n2, byte[] byArray) {
        int n3 = Socket.sendToDomainSocket(this.fd, byteBuffer, n, n2, byArray);
        if (n3 >= 0) {
            return n3;
        }
        return Errors.ioResult("sendToDomainSocket", n3);
    }

    public final int sendToAddress(long l, int n, int n2, InetAddress inetAddress, int n3) {
        return this.sendToAddress(l, n, n2, inetAddress, n3, false);
    }

    public final int sendToAddress(long l, int n, int n2, InetAddress inetAddress, int n3, boolean bl) {
        int n4;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n4 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n4 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n5 = bl ? Socket.msgFastopen() : 0;
        int n6 = Socket.sendToAddress(this.fd, this.useIpv6(inetAddress), l, n, n2, byArray, n4, n3, n5);
        if (n6 >= 0) {
            return n6;
        }
        if (n6 == Errors.ERRNO_EINPROGRESS_NEGATIVE && bl) {
            return 0;
        }
        if (n6 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddress failed");
        }
        return Errors.ioResult("sendToAddress", n6);
    }

    public final int sendToAddressDomainSocket(long l, int n, int n2, byte[] byArray) {
        int n3 = Socket.sendToAddressDomainSocket(this.fd, l, n, n2, byArray);
        if (n3 >= 0) {
            return n3;
        }
        return Errors.ioResult("sendToAddressDomainSocket", n3);
    }

    public final int sendToAddresses(long l, int n, InetAddress inetAddress, int n2) {
        return this.sendToAddresses(l, n, inetAddress, n2, false);
    }

    public final int sendToAddresses(long l, int n, InetAddress inetAddress, int n2, boolean bl) {
        int n3;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n3 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n3 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n4 = bl ? Socket.msgFastopen() : 0;
        int n5 = Socket.sendToAddresses(this.fd, this.useIpv6(inetAddress), l, n, byArray, n3, n2, n4);
        if (n5 >= 0) {
            return n5;
        }
        if (n5 == Errors.ERRNO_EINPROGRESS_NEGATIVE && bl) {
            return 0;
        }
        if (n5 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddresses failed");
        }
        return Errors.ioResult("sendToAddresses", n5);
    }

    public final int sendToAddressesDomainSocket(long l, int n, byte[] byArray) {
        int n2 = Socket.sendToAddressesDomainSocket(this.fd, l, n, byArray);
        if (n2 >= 0) {
            return n2;
        }
        return Errors.ioResult("sendToAddressesDomainSocket", n2);
    }

    public final DatagramSocketAddress recvFrom(ByteBuffer byteBuffer, int n, int n2) {
        return Socket.recvFrom(this.fd, byteBuffer, n, n2);
    }

    public final DatagramSocketAddress recvFromAddress(long l, int n, int n2) {
        return Socket.recvFromAddress(this.fd, l, n, n2);
    }

    public final DomainDatagramSocketAddress recvFromDomainSocket(ByteBuffer byteBuffer, int n, int n2) {
        return Socket.recvFromDomainSocket(this.fd, byteBuffer, n, n2);
    }

    public final DomainDatagramSocketAddress recvFromAddressDomainSocket(long l, int n, int n2) {
        return Socket.recvFromAddressDomainSocket(this.fd, l, n, n2);
    }

    public int recv(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = Socket.recv(this.intValue(), byteBuffer, n, n2);
        if (n3 > 0) {
            return n3;
        }
        if (n3 == 0) {
            return -1;
        }
        return Errors.ioResult("recv", n3);
    }

    public int recvAddress(long l, int n, int n2) {
        int n3 = Socket.recvAddress(this.intValue(), l, n, n2);
        if (n3 > 0) {
            return n3;
        }
        if (n3 == 0) {
            return -1;
        }
        return Errors.ioResult("recvAddress", n3);
    }

    public int send(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = Socket.send(this.intValue(), byteBuffer, n, n2);
        if (n3 >= 0) {
            return n3;
        }
        return Errors.ioResult("send", n3);
    }

    public int sendAddress(long l, int n, int n2) {
        int n3 = Socket.sendAddress(this.intValue(), l, n, n2);
        if (n3 >= 0) {
            return n3;
        }
        return Errors.ioResult("sendAddress", n3);
    }

    public final int recvFd() {
        int n = Socket.recvFd(this.fd);
        if (n > 0) {
            return n;
        }
        if (n == 0) {
            return -1;
        }
        if (n == Errors.ERRNO_EAGAIN_NEGATIVE || n == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        throw Errors.newIOException("recvFd", n);
    }

    public final int sendFd(int n) {
        int n2 = Socket.sendFd(this.fd, n);
        if (n2 >= 0) {
            return n2;
        }
        if (n2 == Errors.ERRNO_EAGAIN_NEGATIVE || n2 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("sendFd", n2);
    }

    public final boolean connect(SocketAddress socketAddress) {
        int n;
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetAddress);
            n = Socket.connect(this.fd, this.useIpv6(inetAddress), nativeInetAddress.address, nativeInetAddress.scopeId, inetSocketAddress.getPort());
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress domainSocketAddress = (DomainSocketAddress)socketAddress;
            n = Socket.connectDomainSocket(this.fd, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
        if (n < 0) {
            return Errors.handleConnectErrno("connect", n);
        }
        return true;
    }

    public final boolean finishConnect() {
        int n = Socket.finishConnect(this.fd);
        if (n < 0) {
            return Errors.handleConnectErrno("finishConnect", n);
        }
        return true;
    }

    public final void disconnect() {
        int n = Socket.disconnect(this.fd, this.ipv6);
        if (n < 0) {
            Errors.handleConnectErrno("disconnect", n);
        }
    }

    public final void bind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetAddress);
            int n = Socket.bind(this.fd, this.useIpv6(inetAddress), nativeInetAddress.address, nativeInetAddress.scopeId, inetSocketAddress.getPort());
            if (n < 0) {
                throw Errors.newIOException("bind", n);
            }
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress domainSocketAddress = (DomainSocketAddress)socketAddress;
            int n = Socket.bindDomainSocket(this.fd, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
            if (n < 0) {
                throw Errors.newIOException("bind", n);
            }
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
    }

    public final void listen(int n) {
        int n2 = Socket.listen(this.fd, n);
        if (n2 < 0) {
            throw Errors.newIOException("listen", n2);
        }
    }

    public final int accept(byte[] byArray) {
        int n = Socket.accept(this.fd, byArray);
        if (n >= 0) {
            return n;
        }
        if (n == Errors.ERRNO_EAGAIN_NEGATIVE || n == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("accept", n);
    }

    public final InetSocketAddress remoteAddress() {
        byte[] byArray = Socket.remoteAddress(this.fd);
        return byArray == null ? null : NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final DomainSocketAddress remoteDomainSocketAddress() {
        byte[] byArray = Socket.remoteDomainSocketAddress(this.fd);
        return byArray == null ? null : new DomainSocketAddress(new String(byArray));
    }

    public final InetSocketAddress localAddress() {
        byte[] byArray = Socket.localAddress(this.fd);
        return byArray == null ? null : NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final DomainSocketAddress localDomainSocketAddress() {
        byte[] byArray = Socket.localDomainSocketAddress(this.fd);
        return byArray == null ? null : new DomainSocketAddress(new String(byArray));
    }

    public final int getReceiveBufferSize() {
        return Socket.getReceiveBufferSize(this.fd);
    }

    public final int getSendBufferSize() {
        return Socket.getSendBufferSize(this.fd);
    }

    public final boolean isKeepAlive() {
        return Socket.isKeepAlive(this.fd) != 0;
    }

    public final boolean isTcpNoDelay() {
        return Socket.isTcpNoDelay(this.fd) != 0;
    }

    public final boolean isReuseAddress() {
        return Socket.isReuseAddress(this.fd) != 0;
    }

    public final boolean isReusePort() {
        return Socket.isReusePort(this.fd) != 0;
    }

    public final boolean isBroadcast() {
        return Socket.isBroadcast(this.fd) != 0;
    }

    public final int getSoLinger() {
        return Socket.getSoLinger(this.fd);
    }

    public final int getSoError() {
        return Socket.getSoError(this.fd);
    }

    public final int getTrafficClass() {
        return Socket.getTrafficClass(this.fd, this.ipv6);
    }

    public final void setKeepAlive(boolean bl) {
        Socket.setKeepAlive(this.fd, bl ? 1 : 0);
    }

    public final void setReceiveBufferSize(int n) {
        Socket.setReceiveBufferSize(this.fd, n);
    }

    public final void setSendBufferSize(int n) {
        Socket.setSendBufferSize(this.fd, n);
    }

    public final void setTcpNoDelay(boolean bl) {
        Socket.setTcpNoDelay(this.fd, bl ? 1 : 0);
    }

    public final void setSoLinger(int n) {
        Socket.setSoLinger(this.fd, n);
    }

    public final void setReuseAddress(boolean bl) {
        Socket.setReuseAddress(this.fd, bl ? 1 : 0);
    }

    public final void setReusePort(boolean bl) {
        Socket.setReusePort(this.fd, bl ? 1 : 0);
    }

    public final void setBroadcast(boolean bl) {
        Socket.setBroadcast(this.fd, bl ? 1 : 0);
    }

    public final void setTrafficClass(int n) {
        Socket.setTrafficClass(this.fd, this.ipv6, n);
    }

    public void setIntOpt(int n, int n2, int n3) {
        Socket.setIntOpt(this.fd, n, n2, n3);
    }

    public void setRawOpt(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            Socket.setRawOptAddress(this.fd, n, n2, Buffer.memoryAddress(byteBuffer) + (long)byteBuffer.position(), byteBuffer.remaining());
        } else if (byteBuffer.hasArray()) {
            Socket.setRawOptArray(this.fd, n, n2, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.duplicate().get(byArray);
            Socket.setRawOptArray(this.fd, n, n2, byArray, 0, byArray.length);
        }
        byteBuffer.position(n3);
    }

    public int getIntOpt(int n, int n2) {
        return Socket.getIntOpt(this.fd, n, n2);
    }

    public void getRawOpt(int n, int n2, ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            Socket.getRawOptAddress(this.fd, n, n2, Buffer.memoryAddress(byteBuffer) + (long)byteBuffer.position(), byteBuffer.remaining());
        } else if (byteBuffer.hasArray()) {
            Socket.getRawOptArray(this.fd, n, n2, byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            Socket.getRawOptArray(this.fd, n, n2, byArray, 0, byArray.length);
            byteBuffer.put(byArray);
        }
        byteBuffer.position(byteBuffer.limit());
    }

    public static boolean isIPv6Preferred() {
        return isIpv6Preferred;
    }

    public static boolean shouldUseIpv6(InternetProtocolFamily internetProtocolFamily) {
        return internetProtocolFamily == null ? Socket.isIPv6Preferred() : internetProtocolFamily == InternetProtocolFamily.IPv6;
    }

    private static native boolean isIPv6Preferred0(boolean var0);

    private static native boolean isIPv6(int var0);

    @Override
    public String toString() {
        return "Socket{fd=" + this.fd + '}';
    }

    public static Socket newSocketStream() {
        return new Socket(Socket.newSocketStream0());
    }

    public static Socket newSocketDgram() {
        return new Socket(Socket.newSocketDgram0());
    }

    public static Socket newSocketDomain() {
        return new Socket(Socket.newSocketDomain0());
    }

    public static Socket newSocketDomainDgram() {
        return new Socket(Socket.newSocketDomainDgram0());
    }

    public static void initialize() {
        isIpv6Preferred = Socket.isIPv6Preferred0(NetUtil.isIpV4StackPreferred());
    }

    protected static int newSocketStream0() {
        return Socket.newSocketStream0(Socket.isIPv6Preferred());
    }

    protected static int newSocketStream0(InternetProtocolFamily internetProtocolFamily) {
        return Socket.newSocketStream0(Socket.shouldUseIpv6(internetProtocolFamily));
    }

    protected static int newSocketStream0(boolean bl) {
        int n = Socket.newSocketStreamFd(bl);
        if (n < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketStream", n));
        }
        return n;
    }

    protected static int newSocketDgram0() {
        return Socket.newSocketDgram0(Socket.isIPv6Preferred());
    }

    protected static int newSocketDgram0(InternetProtocolFamily internetProtocolFamily) {
        return Socket.newSocketDgram0(Socket.shouldUseIpv6(internetProtocolFamily));
    }

    protected static int newSocketDgram0(boolean bl) {
        int n = Socket.newSocketDgramFd(bl);
        if (n < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketDgram", n));
        }
        return n;
    }

    protected static int newSocketDomain0() {
        int n = Socket.newSocketDomainFd();
        if (n < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketDomain", n));
        }
        return n;
    }

    protected static int newSocketDomainDgram0() {
        int n = Socket.newSocketDomainDgramFd();
        if (n < 0) {
            throw new ChannelException((Throwable)Errors.newIOException("newSocketDomainDgram", n));
        }
        return n;
    }

    private static native int shutdown(int var0, boolean var1, boolean var2);

    private static native int connect(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int connectDomainSocket(int var0, byte[] var1);

    private static native int finishConnect(int var0);

    private static native int disconnect(int var0, boolean var1);

    private static native int bind(int var0, boolean var1, byte[] var2, int var3, int var4);

    private static native int bindDomainSocket(int var0, byte[] var1);

    private static native int listen(int var0, int var1);

    private static native int accept(int var0, byte[] var1);

    private static native byte[] remoteAddress(int var0);

    private static native byte[] remoteDomainSocketAddress(int var0);

    private static native byte[] localAddress(int var0);

    private static native byte[] localDomainSocketAddress(int var0);

    private static native int send(int var0, ByteBuffer var1, int var2, int var3);

    private static native int sendAddress(int var0, long var1, int var3, int var4);

    private static native int recv(int var0, ByteBuffer var1, int var2, int var3);

    private static native int recvAddress(int var0, long var1, int var3, int var4);

    private static native int sendTo(int var0, boolean var1, ByteBuffer var2, int var3, int var4, byte[] var5, int var6, int var7, int var8);

    private static native int sendToAddress(int var0, boolean var1, long var2, int var4, int var5, byte[] var6, int var7, int var8, int var9);

    private static native int sendToAddresses(int var0, boolean var1, long var2, int var4, byte[] var5, int var6, int var7, int var8);

    private static native int sendToDomainSocket(int var0, ByteBuffer var1, int var2, int var3, byte[] var4);

    private static native int sendToAddressDomainSocket(int var0, long var1, int var3, int var4, byte[] var5);

    private static native int sendToAddressesDomainSocket(int var0, long var1, int var3, byte[] var4);

    private static native DatagramSocketAddress recvFrom(int var0, ByteBuffer var1, int var2, int var3);

    private static native DatagramSocketAddress recvFromAddress(int var0, long var1, int var3, int var4);

    private static native DomainDatagramSocketAddress recvFromDomainSocket(int var0, ByteBuffer var1, int var2, int var3);

    private static native DomainDatagramSocketAddress recvFromAddressDomainSocket(int var0, long var1, int var3, int var4);

    private static native int recvFd(int var0);

    private static native int sendFd(int var0, int var1);

    private static native int msgFastopen();

    private static native int newSocketStreamFd(boolean var0);

    private static native int newSocketDgramFd(boolean var0);

    private static native int newSocketDomainFd();

    private static native int newSocketDomainDgramFd();

    private static native int isReuseAddress(int var0);

    private static native int isReusePort(int var0);

    private static native int getReceiveBufferSize(int var0);

    private static native int getSendBufferSize(int var0);

    private static native int isKeepAlive(int var0);

    private static native int isTcpNoDelay(int var0);

    private static native int isBroadcast(int var0);

    private static native int getSoLinger(int var0);

    private static native int getSoError(int var0);

    private static native int getTrafficClass(int var0, boolean var1);

    private static native void setReuseAddress(int var0, int var1);

    private static native void setReusePort(int var0, int var1);

    private static native void setKeepAlive(int var0, int var1);

    private static native void setReceiveBufferSize(int var0, int var1);

    private static native void setSendBufferSize(int var0, int var1);

    private static native void setTcpNoDelay(int var0, int var1);

    private static native void setSoLinger(int var0, int var1);

    private static native void setBroadcast(int var0, int var1);

    private static native void setTrafficClass(int var0, boolean var1, int var2);

    private static native void setIntOpt(int var0, int var1, int var2, int var3);

    private static native void setRawOptArray(int var0, int var1, int var2, byte[] var3, int var4, int var5);

    private static native void setRawOptAddress(int var0, int var1, int var2, long var3, int var5);

    private static native int getIntOpt(int var0, int var1, int var2);

    private static native void getRawOptArray(int var0, int var1, int var2, byte[] var3, int var4, int var5);

    private static native void getRawOptAddress(int var0, int var1, int var2, long var3, int var5);
}

