/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.DefaultMaxMessagesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayList;

public class AdaptiveRecvByteBufAllocator
extends DefaultMaxMessagesRecvByteBufAllocator {
    public static final int DEFAULT_MINIMUM = 64;
    public static final int DEFAULT_INITIAL = 2048;
    public static final int DEFAULT_MAXIMUM = 65536;
    private static final int INDEX_INCREMENT = 4;
    private static final int INDEX_DECREMENT = 1;
    private static final int[] SIZE_TABLE;
    @Deprecated
    public static final AdaptiveRecvByteBufAllocator DEFAULT;
    private final int minIndex;
    private final int maxIndex;
    private final int initialIndex;
    private final int minCapacity;
    private final int maxCapacity;

    private static int getSizeTableIndex(int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = SIZE_TABLE.length - 1;
        while (true) {
            if (n5 < n4) {
                return n4;
            }
            if (n5 == n4) {
                return n5;
            }
            n3 = n4 + n5 >>> 1;
            n2 = SIZE_TABLE[n3];
            int n6 = SIZE_TABLE[n3 + 1];
            if (n > n6) {
                n4 = n3 + 1;
                continue;
            }
            if (n >= n2) break;
            n5 = n3 - 1;
        }
        if (n == n2) {
            return n3;
        }
        return n3 + 1;
    }

    public AdaptiveRecvByteBufAllocator() {
        this(64, 2048, 65536);
    }

    public AdaptiveRecvByteBufAllocator(int n, int n2, int n3) {
        ObjectUtil.checkPositive((int)n, (String)"minimum");
        if (n2 < n) {
            throw new IllegalArgumentException("initial: " + n2);
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("maximum: " + n3);
        }
        int n4 = AdaptiveRecvByteBufAllocator.getSizeTableIndex(n);
        this.minIndex = SIZE_TABLE[n4] < n ? n4 + 1 : n4;
        int n5 = AdaptiveRecvByteBufAllocator.getSizeTableIndex(n3);
        this.maxIndex = SIZE_TABLE[n5] > n3 ? n5 - 1 : n5;
        int n6 = AdaptiveRecvByteBufAllocator.getSizeTableIndex(n2);
        this.initialIndex = SIZE_TABLE[n6] > n2 ? n6 - 1 : n6;
        this.minCapacity = n;
        this.maxCapacity = n3;
    }

    @Override
    public RecvByteBufAllocator.Handle newHandle() {
        return new HandleImpl(this.minIndex, this.maxIndex, this.initialIndex, this.minCapacity, this.maxCapacity);
    }

    @Override
    public AdaptiveRecvByteBufAllocator respectMaybeMoreData(boolean bl) {
        super.respectMaybeMoreData(bl);
        return this;
    }

    static {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 16; n < 512; n += 16) {
            arrayList.add(n);
        }
        for (n = 512; n > 0; n <<= 1) {
            arrayList.add(n);
        }
        SIZE_TABLE = new int[arrayList.size()];
        for (n = 0; n < SIZE_TABLE.length; ++n) {
            AdaptiveRecvByteBufAllocator.SIZE_TABLE[n] = (Integer)arrayList.get(n);
        }
        DEFAULT = new AdaptiveRecvByteBufAllocator();
    }

    private final class HandleImpl
    extends DefaultMaxMessagesRecvByteBufAllocator.MaxMessageHandle {
        private final int minIndex;
        private final int maxIndex;
        private final int minCapacity;
        private final int maxCapacity;
        private int index;
        private int nextReceiveBufferSize;
        private boolean decreaseNow;

        HandleImpl(int n, int n2, int n3, int n4, int n5) {
            super(AdaptiveRecvByteBufAllocator.this);
            this.minIndex = n;
            this.maxIndex = n2;
            this.index = n3;
            this.nextReceiveBufferSize = Math.max(SIZE_TABLE[this.index], n4);
            this.minCapacity = n4;
            this.maxCapacity = n5;
        }

        @Override
        public void lastBytesRead(int n) {
            if (n == this.attemptedBytesRead()) {
                this.record(n);
            }
            super.lastBytesRead(n);
        }

        @Override
        public int guess() {
            return this.nextReceiveBufferSize;
        }

        private void record(int n) {
            if (n <= SIZE_TABLE[Math.max(0, this.index - 1)]) {
                if (this.decreaseNow) {
                    this.index = Math.max(this.index - 1, this.minIndex);
                    this.nextReceiveBufferSize = Math.max(SIZE_TABLE[this.index], this.minCapacity);
                    this.decreaseNow = false;
                } else {
                    this.decreaseNow = true;
                }
            } else if (n >= this.nextReceiveBufferSize) {
                this.index = Math.min(this.index + 4, this.maxIndex);
                this.nextReceiveBufferSize = Math.min(SIZE_TABLE[this.index], this.maxCapacity);
                this.decreaseNow = false;
            }
        }

        @Override
        public void readComplete() {
            this.record(this.totalBytesRead());
        }
    }
}

