/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AddressedEnvelope;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;

public class DefaultAddressedEnvelope<M, A extends SocketAddress>
implements AddressedEnvelope<M, A> {
    private final M message;
    private final A sender;
    private final A recipient;

    public DefaultAddressedEnvelope(M m, A a, A a2) {
        ObjectUtil.checkNotNull(m, (String)"message");
        if (a == null && a2 == null) {
            throw new NullPointerException("recipient and sender");
        }
        this.message = m;
        this.sender = a2;
        this.recipient = a;
    }

    public DefaultAddressedEnvelope(M m, A a) {
        this(m, a, null);
    }

    @Override
    public M content() {
        return this.message;
    }

    @Override
    public A sender() {
        return this.sender;
    }

    @Override
    public A recipient() {
        return this.recipient;
    }

    public int refCnt() {
        if (this.message instanceof ReferenceCounted) {
            return ((ReferenceCounted)this.message).refCnt();
        }
        return 1;
    }

    @Override
    public AddressedEnvelope<M, A> retain() {
        ReferenceCountUtil.retain(this.message);
        return this;
    }

    @Override
    public AddressedEnvelope<M, A> retain(int n) {
        ReferenceCountUtil.retain(this.message, (int)n);
        return this;
    }

    public boolean release() {
        return ReferenceCountUtil.release(this.message);
    }

    public boolean release(int n) {
        return ReferenceCountUtil.release(this.message, (int)n);
    }

    @Override
    public AddressedEnvelope<M, A> touch() {
        ReferenceCountUtil.touch(this.message);
        return this;
    }

    @Override
    public AddressedEnvelope<M, A> touch(Object object) {
        ReferenceCountUtil.touch(this.message, (Object)object);
        return this;
    }

    public String toString() {
        if (this.sender != null) {
            return StringUtil.simpleClassName((Object)this) + '(' + this.sender + " => " + this.recipient + ", " + this.message + ')';
        }
        return StringUtil.simpleClassName((Object)this) + "(=> " + this.recipient + ", " + this.message + ')';
    }
}

