/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class DefaultFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultFileRegion.class);
    private final File f;
    private final long position;
    private final long count;
    private long transferred;
    private FileChannel file;

    public DefaultFileRegion(FileChannel fileChannel, long l, long l2) {
        this.file = (FileChannel)ObjectUtil.checkNotNull((Object)fileChannel, (String)"fileChannel");
        this.position = ObjectUtil.checkPositiveOrZero((long)l, (String)"position");
        this.count = ObjectUtil.checkPositiveOrZero((long)l2, (String)"count");
        this.f = null;
    }

    public DefaultFileRegion(File file, long l, long l2) {
        this.f = (File)ObjectUtil.checkNotNull((Object)file, (String)"file");
        this.position = ObjectUtil.checkPositiveOrZero((long)l, (String)"position");
        this.count = ObjectUtil.checkPositiveOrZero((long)l2, (String)"count");
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void open() {
        if (!this.isOpen() && this.refCnt() > 0) {
            this.file = new RandomAccessFile(this.f, "r").getChannel();
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    @Deprecated
    public long transfered() {
        return this.transferred;
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    @Override
    public long transferTo(WritableByteChannel writableByteChannel, long l) {
        long l2 = this.count - l;
        if (l2 < 0L || l < 0L) {
            throw new IllegalArgumentException("position out of range: " + l + " (expected: 0 - " + (this.count - 1L) + ')');
        }
        if (l2 == 0L) {
            return 0L;
        }
        if (this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
        this.open();
        long l3 = this.file.transferTo(this.position + l, l2, writableByteChannel);
        if (l3 > 0L) {
            this.transferred += l3;
        } else if (l3 == 0L) {
            DefaultFileRegion.validate(this, l);
        }
        return l3;
    }

    protected void deallocate() {
        FileChannel fileChannel = this.file;
        if (fileChannel == null) {
            return;
        }
        this.file = null;
        try {
            fileChannel.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a file.", (Throwable)iOException);
        }
    }

    @Override
    public FileRegion retain() {
        super.retain();
        return this;
    }

    @Override
    public FileRegion retain(int n) {
        super.retain(n);
        return this;
    }

    @Override
    public FileRegion touch() {
        return this;
    }

    @Override
    public FileRegion touch(Object object) {
        return this;
    }

    static void validate(DefaultFileRegion defaultFileRegion, long l) {
        long l2 = defaultFileRegion.count - l;
        long l3 = defaultFileRegion.file.size();
        if (defaultFileRegion.position + l2 + l > l3) {
            throw new IOException("Underlying file size " + l3 + " smaller then requested count " + defaultFileRegion.count);
        }
    }
}

