/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.MaxBytesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractMap;
import java.util.Map;

public class DefaultMaxBytesRecvByteBufAllocator
implements MaxBytesRecvByteBufAllocator {
    private volatile int maxBytesPerRead;
    private volatile int maxBytesPerIndividualRead;

    public DefaultMaxBytesRecvByteBufAllocator() {
        this(65536, 65536);
    }

    public DefaultMaxBytesRecvByteBufAllocator(int n, int n2) {
        DefaultMaxBytesRecvByteBufAllocator.checkMaxBytesPerReadPair(n, n2);
        this.maxBytesPerRead = n;
        this.maxBytesPerIndividualRead = n2;
    }

    @Override
    public RecvByteBufAllocator.Handle newHandle() {
        return new HandleImpl();
    }

    @Override
    public int maxBytesPerRead() {
        return this.maxBytesPerRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerRead(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxBytesPerRead");
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            int n2 = this.maxBytesPerIndividualRead();
            if (n < n2) {
                throw new IllegalArgumentException("maxBytesPerRead cannot be less than maxBytesPerIndividualRead (" + n2 + "): " + n);
            }
            this.maxBytesPerRead = n;
        }
        return this;
    }

    @Override
    public int maxBytesPerIndividualRead() {
        return this.maxBytesPerIndividualRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerIndividualRead(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxBytesPerIndividualRead");
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            int n2 = this.maxBytesPerRead();
            if (n > n2) {
                throw new IllegalArgumentException("maxBytesPerIndividualRead cannot be greater than maxBytesPerRead (" + n2 + "): " + n);
            }
            this.maxBytesPerIndividualRead = n;
        }
        return this;
    }

    @Override
    public synchronized Map.Entry<Integer, Integer> maxBytesPerReadPair() {
        return new AbstractMap.SimpleEntry<Integer, Integer>(this.maxBytesPerRead, this.maxBytesPerIndividualRead);
    }

    private static void checkMaxBytesPerReadPair(int n, int n2) {
        ObjectUtil.checkPositive((int)n, (String)"maxBytesPerRead");
        ObjectUtil.checkPositive((int)n2, (String)"maxBytesPerIndividualRead");
        if (n < n2) {
            throw new IllegalArgumentException("maxBytesPerRead cannot be less than maxBytesPerIndividualRead (" + n2 + "): " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerReadPair(int n, int n2) {
        DefaultMaxBytesRecvByteBufAllocator.checkMaxBytesPerReadPair(n, n2);
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            this.maxBytesPerRead = n;
            this.maxBytesPerIndividualRead = n2;
        }
        return this;
    }

    private final class HandleImpl
    implements RecvByteBufAllocator.ExtendedHandle {
        private int individualReadMax;
        private int bytesToRead;
        private int lastBytesRead;
        private int attemptBytesRead;
        private final UncheckedBooleanSupplier defaultMaybeMoreSupplier = new UncheckedBooleanSupplier(){

            public boolean get() {
                return HandleImpl.this.attemptBytesRead == HandleImpl.this.lastBytesRead;
            }
        };

        private HandleImpl() {
        }

        @Override
        public ByteBuf allocate(ByteBufAllocator byteBufAllocator) {
            return byteBufAllocator.ioBuffer(this.guess());
        }

        @Override
        public int guess() {
            return Math.min(this.individualReadMax, this.bytesToRead);
        }

        @Override
        public void reset(ChannelConfig channelConfig) {
            this.bytesToRead = DefaultMaxBytesRecvByteBufAllocator.this.maxBytesPerRead();
            this.individualReadMax = DefaultMaxBytesRecvByteBufAllocator.this.maxBytesPerIndividualRead();
        }

        @Override
        public void incMessagesRead(int n) {
        }

        @Override
        public void lastBytesRead(int n) {
            this.lastBytesRead = n;
            this.bytesToRead -= n;
        }

        @Override
        public int lastBytesRead() {
            return this.lastBytesRead;
        }

        @Override
        public boolean continueReading() {
            return this.continueReading(this.defaultMaybeMoreSupplier);
        }

        @Override
        public boolean continueReading(UncheckedBooleanSupplier uncheckedBooleanSupplier) {
            return this.bytesToRead > 0 && uncheckedBooleanSupplier.get();
        }

        @Override
        public void readComplete() {
        }

        @Override
        public void attemptedBytesRead(int n) {
            this.attemptBytesRead = n;
        }

        @Override
        public int attemptedBytesRead() {
            return this.attemptBytesRead;
        }
    }
}

