/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

public abstract class SingleThreadEventLoop
extends SingleThreadEventExecutor
implements EventLoop {
    protected static final int DEFAULT_MAX_PENDING_TASKS = Math.max(16, SystemPropertyUtil.getInt((String)"io.netty.eventLoop.maxPendingTasks", (int)Integer.MAX_VALUE));
    private final Queue<Runnable> tailTasks;

    protected SingleThreadEventLoop(EventLoopGroup eventLoopGroup, ThreadFactory threadFactory, boolean bl) {
        this(eventLoopGroup, threadFactory, bl, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    protected SingleThreadEventLoop(EventLoopGroup eventLoopGroup, Executor executor, boolean bl) {
        this(eventLoopGroup, executor, bl, DEFAULT_MAX_PENDING_TASKS, RejectedExecutionHandlers.reject());
    }

    protected SingleThreadEventLoop(EventLoopGroup eventLoopGroup, ThreadFactory threadFactory, boolean bl, int n, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)eventLoopGroup, threadFactory, bl, n, rejectedExecutionHandler);
        this.tailTasks = this.newTaskQueue(n);
    }

    protected SingleThreadEventLoop(EventLoopGroup eventLoopGroup, Executor executor, boolean bl, int n, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)eventLoopGroup, executor, bl, n, rejectedExecutionHandler);
        this.tailTasks = this.newTaskQueue(n);
    }

    protected SingleThreadEventLoop(EventLoopGroup eventLoopGroup, Executor executor, boolean bl, Queue<Runnable> queue, Queue<Runnable> queue2, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventExecutorGroup)eventLoopGroup, executor, bl, queue, rejectedExecutionHandler);
        this.tailTasks = (Queue)ObjectUtil.checkNotNull(queue2, (String)"tailTaskQueue");
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, (EventExecutor)this));
    }

    @Override
    public ChannelFuture register(ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)channelPromise, (String)"promise");
        channelPromise.channel().unsafe().register(this, channelPromise);
        return channelPromise;
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull((Object)channelPromise, (String)"promise");
        ObjectUtil.checkNotNull((Object)channel, (String)"channel");
        channel.unsafe().register(this, channelPromise);
        return channelPromise;
    }

    public final void executeAfterEventLoopIteration(Runnable runnable) {
        ObjectUtil.checkNotNull((Object)runnable, (String)"task");
        if (this.isShutdown()) {
            SingleThreadEventLoop.reject();
        }
        if (!this.tailTasks.offer(runnable)) {
            this.reject(runnable);
        }
        if (this.wakesUpForTask(runnable)) {
            this.wakeup(this.inEventLoop());
        }
    }

    final boolean removeAfterEventLoopIterationTask(Runnable runnable) {
        return this.tailTasks.remove(ObjectUtil.checkNotNull((Object)runnable, (String)"task"));
    }

    protected void afterRunningAllTasks() {
        this.runAllTasksFrom(this.tailTasks);
    }

    protected boolean hasTasks() {
        return super.hasTasks() || !this.tailTasks.isEmpty();
    }

    public int pendingTasks() {
        return super.pendingTasks() + this.tailTasks.size();
    }

    public int registeredChannels() {
        return -1;
    }

    public Iterator<Channel> registeredChannelsIterator() {
        throw new UnsupportedOperationException("registeredChannelsIterator");
    }

    protected static final class ChannelsReadOnlyIterator<T extends Channel>
    implements Iterator<Channel> {
        private final Iterator<T> channelIterator;
        private static final Iterator<Object> EMPTY = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };

        public ChannelsReadOnlyIterator(Iterable<T> iterable) {
            this.channelIterator = ((Iterable)ObjectUtil.checkNotNull(iterable, (String)"channelIterable")).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.channelIterator.hasNext();
        }

        @Override
        public Channel next() {
            return (Channel)this.channelIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public static <T> Iterator<T> empty() {
            return EMPTY;
        }
    }
}

