/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.PreferHeapByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannelRegistry;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LocalChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LocalChannel.class);
    private static final AtomicReferenceFieldUpdater<LocalChannel, Future> FINISH_READ_FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LocalChannel.class, Future.class, "finishReadFuture");
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final int MAX_READER_STACK_DEPTH = 8;
    private final ChannelConfig config = new DefaultChannelConfig(this);
    final Queue<Object> inboundBuffer = PlatformDependent.newSpscQueue();
    private final Runnable readTask = new Runnable(){

        @Override
        public void run() {
            if (!LocalChannel.this.inboundBuffer.isEmpty()) {
                LocalChannel.this.readInbound();
            }
        }
    };
    private final Runnable shutdownHook = new Runnable(){

        @Override
        public void run() {
            LocalChannel.this.unsafe().close(LocalChannel.this.unsafe().voidPromise());
        }
    };
    private volatile State state;
    private volatile LocalChannel peer;
    private volatile LocalAddress localAddress;
    private volatile LocalAddress remoteAddress;
    private volatile ChannelPromise connectPromise;
    private volatile boolean readInProgress;
    private volatile boolean writeInProgress;
    private volatile Future<?> finishReadFuture;

    public LocalChannel() {
        super(null);
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
    }

    protected LocalChannel(LocalServerChannel localServerChannel, LocalChannel localChannel) {
        super(localServerChannel);
        this.config().setAllocator(new PreferHeapByteBufAllocator(this.config.getAllocator()));
        this.peer = localChannel;
        this.localAddress = localServerChannel.localAddress();
        this.remoteAddress = localChannel.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public LocalServerChannel parent() {
        return (LocalServerChannel)super.parent();
    }

    @Override
    public LocalAddress localAddress() {
        return (LocalAddress)super.localAddress();
    }

    @Override
    public LocalAddress remoteAddress() {
        return (LocalAddress)super.remoteAddress();
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.CONNECTED;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new LocalUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof SingleThreadEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remoteAddress;
    }

    @Override
    protected void doRegister() {
        if (this.peer != null && this.parent() != null) {
            final LocalChannel localChannel = this.peer;
            this.state = State.CONNECTED;
            localChannel.remoteAddress = this.parent() == null ? null : this.parent().localAddress();
            localChannel.state = State.CONNECTED;
            localChannel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelPromise channelPromise = localChannel.connectPromise;
                    if (channelPromise != null && channelPromise.trySuccess()) {
                        localChannel.pipeline().fireChannelActive();
                    }
                }
            });
        }
        ((SingleThreadEventExecutor)this.eventLoop()).addShutdownHook(this.shutdownHook);
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        this.localAddress = LocalChannelRegistry.register(this, this.localAddress, socketAddress);
        this.state = State.BOUND;
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        final LocalChannel localChannel = this.peer;
        State state = this.state;
        try {
            Object object;
            if (state != State.CLOSED) {
                if (this.localAddress != null) {
                    if (this.parent() == null) {
                        LocalChannelRegistry.unregister(this.localAddress);
                    }
                    this.localAddress = null;
                }
                this.state = State.CLOSED;
                if (this.writeInProgress && localChannel != null) {
                    this.finishPeerRead(localChannel);
                }
                if ((object = this.connectPromise) != null) {
                    object.tryFailure((Throwable)new ClosedChannelException());
                    this.connectPromise = null;
                }
            }
            if (localChannel != null) {
                this.peer = null;
                object = localChannel.eventLoop();
                final boolean bl = localChannel.isActive();
                try {
                    object.execute(new Runnable(){

                        @Override
                        public void run() {
                            localChannel.tryClose(bl);
                        }
                    });
                }
                catch (Throwable throwable) {
                    logger.warn("Releasing Inbound Queues for channels {}-{} because exception occurred!", new Object[]{this, localChannel, throwable});
                    if (object.inEventLoop()) {
                        localChannel.releaseInboundBuffers();
                    } else {
                        localChannel.close();
                    }
                    PlatformDependent.throwException((Throwable)throwable);
                }
            }
        }
        finally {
            if (state != null && state != State.CLOSED) {
                this.releaseInboundBuffers();
            }
        }
    }

    private void tryClose(boolean bl) {
        if (bl) {
            this.unsafe().close(this.unsafe().voidPromise());
        } else {
            this.releaseInboundBuffers();
        }
    }

    @Override
    protected void doDeregister() {
        ((SingleThreadEventExecutor)this.eventLoop()).removeShutdownHook(this.shutdownHook);
    }

    private void readInbound() {
        Object object;
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.reset(this.config());
        ChannelPipeline channelPipeline = this.pipeline();
        while ((object = this.inboundBuffer.poll()) != null) {
            if (object instanceof ByteBuf && this.inboundBuffer.peek() instanceof ByteBuf) {
                ByteBuf byteBuf = (ByteBuf)object;
                ByteBuf byteBuf2 = handle.allocate(this.alloc());
                if (byteBuf.readableBytes() < byteBuf2.writableBytes()) {
                    byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                    byteBuf.release();
                    while ((object = this.inboundBuffer.peek()) instanceof ByteBuf && ((ByteBuf)object).readableBytes() < byteBuf2.writableBytes()) {
                        this.inboundBuffer.poll();
                        byteBuf = (ByteBuf)object;
                        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                        byteBuf.release();
                    }
                    handle.lastBytesRead(byteBuf2.readableBytes());
                    object = byteBuf2;
                } else {
                    handle.lastBytesRead(byteBuf2.capacity());
                    byteBuf2.release();
                }
            }
            handle.incMessagesRead(1);
            channelPipeline.fireChannelRead(object);
            if (handle.continueReading()) continue;
        }
        handle.readComplete();
        channelPipeline.fireChannelReadComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBeginRead() {
        if (this.readInProgress) {
            return;
        }
        Queue<Object> queue = this.inboundBuffer;
        if (queue.isEmpty()) {
            this.readInProgress = true;
            return;
        }
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        int n = internalThreadLocalMap.localChannelReaderStackDepth();
        if (n < 8) {
            internalThreadLocalMap.setLocalChannelReaderStackDepth(n + 1);
            try {
                this.readInbound();
            }
            finally {
                internalThreadLocalMap.setLocalChannelReaderStackDepth(n);
            }
        }
        try {
            this.eventLoop().execute(this.readTask);
        }
        catch (Throwable throwable) {
            logger.warn("Closing Local channels {}-{} because exception occurred!", new Object[]{this, this.peer, throwable});
            this.close();
            this.peer.close();
            PlatformDependent.throwException((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        switch (this.state) {
            case OPEN: 
            case BOUND: {
                throw new NotYetConnectedException();
            }
            case CLOSED: {
                throw new ClosedChannelException();
            }
        }
        LocalChannel localChannel = this.peer;
        this.writeInProgress = true;
        try {
            Object object;
            ClosedChannelException closedChannelException = null;
            while ((object = channelOutboundBuffer.current()) != null) {
                try {
                    if (localChannel.state == State.CONNECTED) {
                        localChannel.inboundBuffer.add(ReferenceCountUtil.retain((Object)object));
                        channelOutboundBuffer.remove();
                        continue;
                    }
                    if (closedChannelException == null) {
                        closedChannelException = new ClosedChannelException();
                    }
                    channelOutboundBuffer.remove(closedChannelException);
                }
                catch (Throwable throwable) {
                    channelOutboundBuffer.remove(throwable);
                }
            }
        }
        finally {
            this.writeInProgress = false;
        }
        this.finishPeerRead(localChannel);
    }

    private void finishPeerRead(LocalChannel localChannel) {
        if (localChannel.eventLoop() == this.eventLoop() && !localChannel.writeInProgress) {
            this.finishPeerRead0(localChannel);
        } else {
            this.runFinishPeerReadTask(localChannel);
        }
    }

    private void runFinishPeerReadTask(final LocalChannel localChannel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LocalChannel.this.finishPeerRead0(localChannel);
            }
        };
        try {
            if (localChannel.writeInProgress) {
                localChannel.finishReadFuture = localChannel.eventLoop().submit(runnable);
            } else {
                localChannel.eventLoop().execute(runnable);
            }
        }
        catch (Throwable throwable) {
            logger.warn("Closing Local channels {}-{} because exception occurred!", new Object[]{this, localChannel, throwable});
            this.close();
            localChannel.close();
            PlatformDependent.throwException((Throwable)throwable);
        }
    }

    private void releaseInboundBuffers() {
        Object object;
        assert (this.eventLoop() == null || this.eventLoop().inEventLoop());
        this.readInProgress = false;
        Queue<Object> queue = this.inboundBuffer;
        while ((object = queue.poll()) != null) {
            ReferenceCountUtil.release((Object)object);
        }
    }

    private void finishPeerRead0(LocalChannel localChannel) {
        Future<?> future = localChannel.finishReadFuture;
        if (future != null) {
            if (!future.isDone()) {
                this.runFinishPeerReadTask(localChannel);
                return;
            }
            FINISH_READ_FUTURE_UPDATER.compareAndSet(localChannel, future, null);
        }
        if (localChannel.readInProgress && !localChannel.inboundBuffer.isEmpty()) {
            localChannel.readInProgress = false;
            localChannel.readInbound();
        }
    }

    private class LocalUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private LocalUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            Channel channel;
            if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
                return;
            }
            if (LocalChannel.this.state == State.CONNECTED) {
                AlreadyConnectedException alreadyConnectedException = new AlreadyConnectedException();
                this.safeSetFailure(channelPromise, alreadyConnectedException);
                LocalChannel.this.pipeline().fireExceptionCaught(alreadyConnectedException);
                return;
            }
            if (LocalChannel.this.connectPromise != null) {
                throw new ConnectionPendingException();
            }
            LocalChannel.this.connectPromise = channelPromise;
            if (LocalChannel.this.state != State.BOUND && socketAddress2 == null) {
                socketAddress2 = new LocalAddress(LocalChannel.this);
            }
            if (socketAddress2 != null) {
                try {
                    LocalChannel.this.doBind(socketAddress2);
                }
                catch (Throwable throwable) {
                    this.safeSetFailure(channelPromise, throwable);
                    this.close(this.voidPromise());
                    return;
                }
            }
            if (!((channel = LocalChannelRegistry.get(socketAddress)) instanceof LocalServerChannel)) {
                ConnectException connectException = new ConnectException("connection refused: " + socketAddress);
                this.safeSetFailure(channelPromise, connectException);
                this.close(this.voidPromise());
                return;
            }
            LocalServerChannel localServerChannel = (LocalServerChannel)channel;
            LocalChannel.this.peer = localServerChannel.serve(LocalChannel.this);
        }
    }

    private static enum State {
        OPEN,
        BOUND,
        CONNECTED,
        CLOSED;

    }
}

