/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReadOnlyIterator;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannelPoolMap<K, P extends ChannelPool>
implements ChannelPoolMap<K, P>,
Closeable,
Iterable<Map.Entry<K, P>> {
    private final ConcurrentMap<K, P> map = PlatformDependent.newConcurrentHashMap();

    @Override
    public final P get(K k) {
        ChannelPool channelPool;
        ChannelPool channelPool2 = (ChannelPool)this.map.get(ObjectUtil.checkNotNull(k, (String)"key"));
        if (channelPool2 == null && (channelPool = this.map.putIfAbsent(k, channelPool2 = this.newPool(k))) != null) {
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(channelPool2);
            channelPool2 = channelPool;
        }
        return (P)channelPool2;
    }

    public final boolean remove(K k) {
        ChannelPool channelPool = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(k, (String)"key"));
        if (channelPool != null) {
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(channelPool);
            return true;
        }
        return false;
    }

    private Future<Boolean> removeAsyncIfSupported(K k) {
        ChannelPool channelPool = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(k, (String)"key"));
        if (channelPool != null) {
            final Promise promise = GlobalEventExecutor.INSTANCE.newPromise();
            AbstractChannelPoolMap.poolCloseAsyncIfSupported(channelPool).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) {
                    if (future.isSuccess()) {
                        promise.setSuccess((Object)Boolean.TRUE);
                    } else {
                        promise.setFailure(future.cause());
                    }
                }
            });
            return promise;
        }
        return GlobalEventExecutor.INSTANCE.newSucceededFuture((Object)Boolean.FALSE);
    }

    private static Future<Void> poolCloseAsyncIfSupported(ChannelPool channelPool) {
        if (channelPool instanceof SimpleChannelPool) {
            return ((SimpleChannelPool)channelPool).closeAsync();
        }
        try {
            channelPool.close();
            return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
        }
        catch (Exception exception) {
            return GlobalEventExecutor.INSTANCE.newFailedFuture((Throwable)exception);
        }
    }

    @Override
    public final Iterator<Map.Entry<K, P>> iterator() {
        return new ReadOnlyIterator(this.map.entrySet().iterator());
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final boolean contains(K k) {
        return this.map.containsKey(ObjectUtil.checkNotNull(k, (String)"key"));
    }

    protected abstract P newPool(K var1);

    @Override
    public final void close() {
        for (Object k : this.map.keySet()) {
            this.removeAsyncIfSupported(k).syncUninterruptibly();
        }
    }
}

