/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Stanza;

public abstract class StreamManagementException
extends SmackException {
    private static final long serialVersionUID = 3767590115788821101L;

    public StreamManagementException() {
    }

    public StreamManagementException(String string) {
        super(string);
    }

    public static final class UnacknowledgedQueueFullException
    extends StreamManagementException {
        private static final long serialVersionUID = 1L;
        private final int overflowElementNum;
        private final int droppedElements;
        private final List<Element> elements;
        private final List<Stanza> unacknowledgesStanzas;

        private UnacknowledgedQueueFullException(String string, int n, int n2, List<Element> list, List<Stanza> list2) {
            super(string);
            this.overflowElementNum = n;
            this.droppedElements = n2;
            this.elements = list;
            this.unacknowledgesStanzas = list2;
        }

        public int getOverflowElementNum() {
            return this.overflowElementNum;
        }

        public int getDroppedElements() {
            return this.droppedElements;
        }

        public List<Element> getElements() {
            return this.elements;
        }

        public List<Stanza> getUnacknowledgesStanzas() {
            return this.unacknowledgesStanzas;
        }

        public static UnacknowledgedQueueFullException newWith(int n, List<Element> list, BlockingQueue<Stanza> blockingQueue) {
            int n2 = blockingQueue.size();
            ArrayList<Stanza> arrayList = new ArrayList<Stanza>(n2);
            arrayList.addAll(blockingQueue);
            int n3 = list.size() - n - 1;
            String string = "The queue size " + n2 + " is not able to fit another " + n3 + " potential stanzas type top-level stream-elements.";
            return new UnacknowledgedQueueFullException(string, n, n3, list, arrayList);
        }
    }

    public static class StreamManagementCounterError
    extends StreamManagementException {
        private static final long serialVersionUID = 1L;
        private final long handledCount;
        private final long previousServerHandledCount;
        private final long ackedStanzaCount;
        private final int outstandingStanzasCount;
        private final List<Stanza> ackedStanzas;

        public StreamManagementCounterError(long l, long l2, long l3, List<Stanza> list) {
            super("There was an error regarding the Stream Management counters. Server reported " + l + " handled stanzas, which means that the " + l3 + " recently send stanzas by client are now acked by the server. But Smack had only " + list.size() + " to acknowledge. The stanza id of the last acked outstanding stanza is " + (list.isEmpty() ? "<no acked stanzas>" : list.get(list.size() - 1).getStanzaId()));
            this.handledCount = l;
            this.previousServerHandledCount = l2;
            this.ackedStanzaCount = l3;
            this.outstandingStanzasCount = list.size();
            this.ackedStanzas = Collections.unmodifiableList(list);
        }

        public long getHandledCount() {
            return this.handledCount;
        }

        public long getPreviousServerHandledCount() {
            return this.previousServerHandledCount;
        }

        public long getAckedStanzaCount() {
            return this.ackedStanzaCount;
        }

        public int getOutstandingStanzasCount() {
            return this.outstandingStanzasCount;
        }

        public List<Stanza> getAckedStanzas() {
            return this.ackedStanzas;
        }
    }

    public static class StreamIdDoesNotMatchException
    extends StreamManagementException {
        private static final long serialVersionUID = 1191073341336559621L;

        public StreamIdDoesNotMatchException(String string, String string2) {
            super("Stream IDs do not match. Expected '" + string + "', but got '" + string2 + "'");
        }
    }

    public static class StreamManagementNotEnabledException
    extends StreamManagementException {
        private static final long serialVersionUID = 2624821584352571307L;
    }
}

