/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.EntityIDFunctionProvider;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016J\u0016\u0010\u0013\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/exposed/sql/EntityIDColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/dao/id/EntityID;", "idColumn", "Lorg/jetbrains/exposed/sql/Column;", "(Lorg/jetbrains/exposed/sql/Column;)V", "getIdColumn", "()Lorg/jetbrains/exposed/sql/Column;", "equals", "", "other", "", "hashCode", "", "nonNullValueToString", "", "value", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "sqlType", "valueFromDB", "exposed-core"})
public final class EntityIDColumnType<T extends Comparable<? super T>>
extends ColumnType<EntityID<T>> {
    private final Column<T> idColumn;

    public EntityIDColumnType(Column<T> column) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        super(false, 1, null);
        this.idColumn = column;
        if (!(this.idColumn.getTable() instanceof IdTable)) {
            boolean bl = false;
            String string = "EntityId supported only for IdTables";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final Column<T> getIdColumn() {
        return this.idColumn;
    }

    @Override
    public String sqlType() {
        return this.idColumn.getColumnType().sqlType();
    }

    @Override
    public Object notNullValueToDB(EntityID<T> entityID) {
        Intrinsics.checkNotNullParameter(entityID, (String)"");
        return this.idColumn.getColumnType().notNullValueToDB(entityID.getValue());
    }

    @Override
    public String nonNullValueToString(EntityID<T> entityID) {
        Intrinsics.checkNotNullParameter(entityID, (String)"");
        return this.idColumn.getColumnType().nonNullValueToString(entityID.getValue());
    }

    @Override
    public EntityID<T> valueFromDB(Object object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (object instanceof EntityID) {
            Object t = ((EntityID)object).getValue();
            object2 = t;
            Intrinsics.checkNotNull(t);
        } else {
            T t = this.idColumn.getColumnType().valueFromDB(object);
            Intrinsics.checkNotNull(t);
            object2 = (Comparable)t;
        }
        Table table = this.idColumn.getTable();
        Intrinsics.checkNotNull((Object)table);
        return EntityIDFunctionProvider.INSTANCE.createEntityID(object2, (IdTable)table);
    }

    @Override
    public Object readObject(ResultSet resultSet, int n) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"");
        return this.idColumn.getColumnType().readObject(resultSet, n);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Object object2 = object;
        return object2 instanceof EntityIDColumnType ? Intrinsics.areEqual(this.idColumn, ((EntityIDColumnType)object).idColumn) : (object2 instanceof IColumnType ? Intrinsics.areEqual(this.idColumn.getColumnType(), (Object)object) : false);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.idColumn.hashCode();
    }
}

