/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.exposed.exceptions.LongQueryException;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.UserDataHolder;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementInterceptor;
import org.jetbrains.exposed.sql.statements.StatementResult;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00a3\u00012\u00020\u00012\u00020\u0002:\u0002\u00a3\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\t\u0010w\u001a\u00020xH\u0096\u0001J\u0006\u0010y\u001a\u00020xJ\b\u0010z\u001a\u00020xH\u0016J\u0018\u0010{\u001a\u00020-2\u0006\u0010|\u001a\u00020\u001d2\u0006\u0010}\u001a\u00020-H\u0002JK\u0010~\u001a\u0004\u0018\u00010x2\b\b\u0001\u0010}\u001a\u00020-2#\b\u0002\u0010\u007f\u001a\u001d\u0012\u0018\u0012\u0016\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u0081\u0001\u0012\u0007\u0012\u0005\u0018\u00010\u0082\u00010e0\u0080\u00012\f\b\u0002\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001\u00a2\u0006\u0003\u0010\u0085\u0001Jr\u0010~\u001a\u0005\u0018\u0001H\u0086\u0001\"\n\b\u0000\u0010\u0086\u0001*\u00030\u0082\u00012\b\b\u0001\u0010}\u001a\u00020-2#\b\u0002\u0010\u007f\u001a\u001d\u0012\u0018\u0012\u0016\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u0081\u0001\u0012\u0007\u0012\u0005\u0018\u00010\u0082\u00010e0\u0080\u00012\f\b\u0002\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u00012\u0018\u0010\u0087\u0001\u001a\u0013\u0012\u0005\u0012\u00030\u0089\u0001\u0012\u0007\u0012\u0005\u0018\u0001H\u0086\u00010\u0088\u0001\u00a2\u0006\u0003\u0010\u008a\u0001J%\u0010~\u001a\u0005\u0018\u0001H\u0086\u0001\"\u0005\b\u0000\u0010\u0086\u00012\r\u0010}\u001a\t\u0012\u0005\u0012\u0003H\u0086\u00010'\u00a2\u0006\u0003\u0010\u008b\u0001JW\u0010~\u001a\u0005\u0018\u0001H\u008c\u0001\"\u0005\b\u0000\u0010\u0086\u0001\"\u0005\b\u0001\u0010\u008c\u00012\r\u0010}\u001a\t\u0012\u0005\u0012\u0003H\u0086\u00010'2)\u0010\u008d\u0001\u001a$\u0012\u000b\u0012\t\u0012\u0005\u0012\u0003H\u0086\u00010'\u0012\u0005\u0012\u0003H\u0086\u0001\u0012\u0005\u0012\u0003H\u008c\u00010\u008e\u0001\u00a2\u0006\u0003\b\u008f\u0001\u00a2\u0006\u0003\u0010\u0090\u0001J\u0017\u0010\u0091\u0001\u001a\u00020x2\u000e\u0010\u0092\u0001\u001a\t\u0012\u0004\u0012\u00020-0\u0093\u0001J\u0015\u0010\u0094\u0001\u001a\u00020-2\f\u0010\u0095\u0001\u001a\u0007\u0012\u0002\b\u00030\u0096\u0001J'\u0010\u0094\u0001\u001a\u00020x2\f\u0010\u0095\u0001\u001a\u0007\u0012\u0002\b\u00030\u0096\u00012\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0000\u00a2\u0006\u0003\b\u0099\u0001J\u000f\u0010\u009a\u0001\u001a\u00020\u001dH\u0000\u00a2\u0006\u0003\b\u009b\u0001J\u0015\u0010\u009c\u0001\u001a\u00020-2\f\u0010\u0095\u0001\u001a\u0007\u0012\u0002\b\u00030\u0096\u0001J\u0011\u0010\u009c\u0001\u001a\u00020-2\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001J\u0010\u0010\u009f\u0001\u001a\u00020\u00062\u0007\u0010\u00a0\u0001\u001a\u000204J\t\u0010\u00a1\u0001\u001a\u00020xH\u0016J\u0010\u0010\u00a2\u0001\u001a\u00020\u00062\u0007\u0010\u00a0\u0001\u001a\u000204R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R \u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001b\u0010,\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R$\u00102\u001a\u0012\u0012\u0004\u0012\u00020403j\b\u0012\u0004\u0012\u000204`5X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R$\u0010:\u001a\u0002092\u0006\u00108\u001a\u000209@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R*\u0010?\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\u001d8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b@\u0010A\u001a\u0004\bB\u0010\u001f\"\u0004\bC\u0010!R\u001a\u0010D\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u001f\"\u0004\bF\u0010!R*\u0010G\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\u001d8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bH\u0010A\u001a\u0004\bI\u0010\u001f\"\u0004\bJ\u0010!R\u001a\u0010K\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010\u001f\"\u0004\bM\u0010!R\u001a\u0010N\u001a\u000209X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010<\"\u0004\bP\u0010>R\u0014\u0010Q\u001a\u0004\u0018\u00010\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u001e\u0010T\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010Y\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u0012\u0010Z\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b[\u0010\bR*\u0010\\\u001a\u0002092\u0006\u00108\u001a\u0002098F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b]\u0010A\u001a\u0004\b^\u0010<\"\u0004\b_\u0010>R\u001a\u0010`\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010<\"\u0004\bb\u0010>RO\u0010c\u001a6\u0012\u0004\u0012\u00020-\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001d0e0dj\u001a\u0012\u0004\u0012\u00020-\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020\u001d0e`f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bi\u00101\u001a\u0004\bg\u0010hR\u0015\u0010j\u001a\u00060kj\u0002`l\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010nR\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010o\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bp\u0010<R\u001e\u0010q\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010v\u001a\u0004\br\u0010s\"\u0004\bt\u0010u\u00a8\u0006\u00a4\u0001"}, d2={"Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/UserDataHolder;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "transactionImpl", "(Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;)V", "blockStatementExecution", "", "getBlockStatementExecution$exposed_core", "()Z", "setBlockStatementExecution$exposed_core", "(Z)V", "connection", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "currentStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "getCurrentStatement", "()Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "setCurrentStatement", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "debug", "getDebug", "setDebug", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "executedStatements", "", "getExecutedStatements$exposed_core", "()Ljava/util/List;", "explainStatement", "Lorg/jetbrains/exposed/sql/statements/Statement;", "getExplainStatement$exposed_core", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "setExplainStatement$exposed_core", "(Lorg/jetbrains/exposed/sql/statements/Statement;)V", "id", "", "getId", "()Ljava/lang/String;", "id$delegate", "Lkotlin/Lazy;", "interceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/StatementInterceptor;", "Lkotlin/collections/ArrayList;", "getInterceptors$exposed_core", "()Ljava/util/ArrayList;", "value", "", "maxAttempts", "getMaxAttempts", "()I", "setMaxAttempts", "(I)V", "maxRepetitionDelay", "getMaxRepetitionDelay$annotations", "()V", "getMaxRepetitionDelay", "setMaxRepetitionDelay", "maxRetryDelay", "getMaxRetryDelay", "setMaxRetryDelay", "minRepetitionDelay", "getMinRepetitionDelay$annotations", "getMinRepetitionDelay", "setMinRepetitionDelay", "minRetryDelay", "getMinRetryDelay", "setMinRetryDelay", "openResultSetsCount", "getOpenResultSetsCount$exposed_core", "setOpenResultSetsCount$exposed_core", "outerTransaction", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "queryTimeout", "getQueryTimeout", "()Ljava/lang/Integer;", "setQueryTimeout", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "readOnly", "getReadOnly", "repetitionAttempts", "getRepetitionAttempts$annotations", "getRepetitionAttempts", "setRepetitionAttempts", "statementCount", "getStatementCount", "setStatementCount", "statementStats", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lkotlin/collections/HashMap;", "getStatementStats", "()Ljava/util/HashMap;", "statementStats$delegate", "statements", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getStatements", "()Ljava/lang/StringBuilder;", "transactionIsolation", "getTransactionIsolation", "warnLongQueriesDuration", "getWarnLongQueriesDuration", "()Ljava/lang/Long;", "setWarnLongQueriesDuration", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "close", "", "closeExecutedStatements", "commit", "describeStatement", "delta", "stmt", "exec", "args", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "explicitStatementType", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;)Lkotlin/Unit;", "T", "transform", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/sql/statements/StatementType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/exposed/sql/statements/Statement;)Ljava/lang/Object;", "R", "body", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/statements/Statement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "execInBatch", "stmts", "", "fullIdentity", "column", "Lorg/jetbrains/exposed/sql/Column;", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "fullIdentity$exposed_core", "getRetryInterval", "getRetryInterval$exposed_core", "identity", "table", "Lorg/jetbrains/exposed/sql/Table;", "registerInterceptor", "interceptor", "rollback", "unregisterInterceptor", "Companion", "exposed-core"})
public class Transaction
extends UserDataHolder
implements TransactionInterface {
    public static final Companion Companion = new Companion(null);
    private final TransactionInterface transactionImpl;
    private final Database db;
    private int statementCount;
    private long duration;
    private Long warnLongQueriesDuration;
    private boolean debug;
    private int maxAttempts;
    private long minRetryDelay;
    private long maxRetryDelay;
    private Integer queryTimeout;
    private final Lazy id$delegate;
    private PreparedStatementApi currentStatement;
    private Statement<?> explainStatement;
    private boolean blockStatementExecution;
    private final List<PreparedStatementApi> executedStatements;
    private int openResultSetsCount;
    private final ArrayList<StatementInterceptor> interceptors;
    private final StringBuilder statements;
    private final Lazy statementStats$delegate;
    private static final ArrayList<GlobalStatementInterceptor> globalInterceptors = new ArrayList();

    public Transaction(TransactionInterface transactionInterface) {
        Intrinsics.checkNotNullParameter((Object)transactionInterface, (String)"");
        this.transactionImpl = transactionInterface;
        this.db = this.transactionImpl.getDb();
        this.warnLongQueriesDuration = this.db.getConfig().getWarnLongQueriesDuration();
        this.maxAttempts = TransactionApiKt.getTransactionManager(this.db).getDefaultMaxAttempts();
        this.minRetryDelay = TransactionApiKt.getTransactionManager(this.db).getDefaultMinRetryDelay();
        this.maxRetryDelay = TransactionApiKt.getTransactionManager(this.db).getDefaultMaxRetryDelay();
        this.id$delegate = LazyKt.lazy((Function0)id.2.INSTANCE);
        this.executedStatements = new ArrayList();
        this.interceptors = new ArrayList();
        this.statements = new StringBuilder();
        this.statementStats$delegate = LazyKt.lazy((Function0)statementStats.2.INSTANCE);
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{this.db.getConfig().getSqlLogger()};
        SQLLogKt.addLogger(this, sqlLoggerArray);
    }

    @Override
    public ExposedConnection<?> getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    public Transaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    public boolean getReadOnly() {
        return this.transactionImpl.getReadOnly();
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionImpl.getTransactionIsolation();
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    @Override
    public final Database getDb() {
        return this.db;
    }

    public final int getStatementCount() {
        return this.statementCount;
    }

    public final void setStatementCount(int n) {
        this.statementCount = n;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    public final Long getWarnLongQueriesDuration() {
        return this.warnLongQueriesDuration;
    }

    public final void setWarnLongQueriesDuration(Long l) {
        this.warnLongQueriesDuration = l;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final void setMaxAttempts(int n) {
        if (!(n > 0)) {
            boolean bl = false;
            String string = "maxAttempts must be set to perform at least 1 attempt.";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxAttempts = n;
    }

    public final long getMinRetryDelay() {
        return this.minRetryDelay;
    }

    public final void setMinRetryDelay(long l) {
        this.minRetryDelay = l;
    }

    public final long getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public final void setMaxRetryDelay(long l) {
        this.maxRetryDelay = l;
    }

    public final int getRepetitionAttempts() {
        return this.maxAttempts;
    }

    public final void setRepetitionAttempts(int n) {
        this.setMaxAttempts(n);
    }

    @Deprecated(message="This property will be removed in future releases", replaceWith=@ReplaceWith(expression="maxAttempts", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getRepetitionAttempts$annotations() {
    }

    public final long getMinRepetitionDelay() {
        return this.minRetryDelay;
    }

    public final void setMinRepetitionDelay(long l) {
        this.minRetryDelay = l;
    }

    @Deprecated(message="This property will be removed in future releases", replaceWith=@ReplaceWith(expression="minRetryDelay", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMinRepetitionDelay$annotations() {
    }

    public final long getMaxRepetitionDelay() {
        return this.maxRetryDelay;
    }

    public final void setMaxRepetitionDelay(long l) {
        this.maxRetryDelay = l;
    }

    @Deprecated(message="This property will be removed in future releases", replaceWith=@ReplaceWith(expression="maxRetryDelay", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMaxRepetitionDelay$annotations() {
    }

    public final Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public final void setQueryTimeout(Integer n) {
        this.queryTimeout = n;
    }

    public final String getId() {
        Lazy lazy = this.id$delegate;
        return (String)lazy.getValue();
    }

    public final PreparedStatementApi getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(PreparedStatementApi preparedStatementApi) {
        this.currentStatement = preparedStatementApi;
    }

    public final Statement<?> getExplainStatement$exposed_core() {
        return this.explainStatement;
    }

    public final void setExplainStatement$exposed_core(Statement<?> statement) {
        this.explainStatement = statement;
    }

    public final boolean getBlockStatementExecution$exposed_core() {
        return this.blockStatementExecution;
    }

    public final void setBlockStatementExecution$exposed_core(boolean bl) {
        this.blockStatementExecution = bl;
    }

    public final List<PreparedStatementApi> getExecutedStatements$exposed_core() {
        return this.executedStatements;
    }

    public final int getOpenResultSetsCount$exposed_core() {
        return this.openResultSetsCount;
    }

    public final void setOpenResultSetsCount$exposed_core(int n) {
        this.openResultSetsCount = n;
    }

    public final ArrayList<StatementInterceptor> getInterceptors$exposed_core() {
        return this.interceptors;
    }

    public final StringBuilder getStatements() {
        return this.statements;
    }

    public final HashMap<String, Pair<Integer, Long>> getStatementStats() {
        Lazy lazy = this.statementStats$delegate;
        return (HashMap)lazy.getValue();
    }

    public final boolean registerInterceptor(StatementInterceptor statementInterceptor) {
        Intrinsics.checkNotNullParameter((Object)statementInterceptor, (String)"");
        return this.interceptors.add(statementInterceptor);
    }

    public final boolean unregisterInterceptor(StatementInterceptor statementInterceptor) {
        Intrinsics.checkNotNullParameter((Object)statementInterceptor, (String)"");
        return this.interceptors.remove(statementInterceptor);
    }

    @Override
    public void commit() {
        boolean bl;
        StatementInterceptor statementInterceptor;
        HashMap hashMap = new HashMap();
        Iterable iterable = globalInterceptors;
        boolean bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (GlobalStatementInterceptor)t;
            bl = false;
            hashMap.putAll(statementInterceptor.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            statementInterceptor.beforeCommit(this);
        }
        iterable = this.interceptors;
        bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (StatementInterceptor)t;
            bl = false;
            hashMap.putAll(statementInterceptor.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            statementInterceptor.beforeCommit(this);
        }
        this.transactionImpl.commit();
        this.getUserdata().clear();
        iterable = globalInterceptors;
        bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (GlobalStatementInterceptor)t;
            bl = false;
            statementInterceptor.afterCommit(this);
        }
        iterable = this.interceptors;
        bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (StatementInterceptor)t;
            bl = false;
            statementInterceptor.afterCommit(this);
        }
        this.getUserdata().putAll(hashMap);
    }

    @Override
    public void rollback() {
        boolean bl;
        StatementInterceptor statementInterceptor;
        Iterable iterable = globalInterceptors;
        boolean bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (GlobalStatementInterceptor)t;
            bl = false;
            statementInterceptor.beforeRollback(this);
        }
        iterable = this.interceptors;
        bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (StatementInterceptor)t;
            bl = false;
            statementInterceptor.beforeRollback(this);
        }
        this.transactionImpl.rollback();
        iterable = globalInterceptors;
        bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (GlobalStatementInterceptor)t;
            bl = false;
            statementInterceptor.afterRollback(this);
        }
        iterable = this.interceptors;
        bl2 = false;
        for (Object t : iterable) {
            statementInterceptor = (StatementInterceptor)t;
            bl = false;
            statementInterceptor.afterRollback(this);
        }
        this.getUserdata().clear();
    }

    private final String describeStatement(long l, String string) {
        return "" + '[' + l + "ms] " + StringsKt.take((String)string, (int)1024) + "\n\n";
    }

    public final Unit exec(String string, Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> iterable, StatementType statementType) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        return (Unit)this.exec(string, iterable, statementType, exec.1.INSTANCE);
    }

    public static /* synthetic */ Unit exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType);
    }

    public final <T> T exec(String string, Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> iterable, StatementType statementType, Function1<? super ResultSet, ? extends T> function1) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        if (((CharSequence)string).length() == 0) {
            return null;
        }
        StatementType statementType2 = statementType;
        if (statementType2 == null) {
            Object v1;
            block4: {
                Iterable iterable2 = (Iterable)StatementType.getEntries();
                for (Object t : iterable2) {
                    StatementType statementType3 = (StatementType)((Object)t);
                    boolean bl = false;
                    if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)statementType3.name(), (boolean)true)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((statementType2 = (StatementType)v1) == null) {
                statementType2 = StatementType.OTHER;
            }
        }
        StatementType statementType4 = statementType2;
        List list = CollectionsKt.emptyList();
        return this.exec(new Statement<T>(statementType4, function1, string, iterable, list){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            final /* synthetic */ String $stmt;
            final /* synthetic */ Iterable<Pair<IColumnType<?>, Object>> $args;
            {
                this.$type = statementType;
                this.$transform = function1;
                this.$stmt = string;
                this.$args = iterable;
                super(statementType, list);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public T executeInternal(PreparedStatementApi var1_1, Transaction var2_2) {
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"");
                Intrinsics.checkNotNullParameter((Object)var2_2, (String)"");
                switch (exec.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v0 = var1_1.executeQuery();
                        break;
                    }
                    case 5: {
                        var7_3 = var1_1.executeMultiple();
                        var8_6 = false;
                        var9_7 = var7_3.iterator();
                        while (var9_7.hasNext()) {
                            var10_8 = var9_7.next();
                            var11_9 = (StatementResult)var10_8;
                            var12_10 = false;
                            if (!(var11_9 instanceof StatementResult.Object)) continue;
                            v1 = var10_8;
                            ** GOTO lbl19
                        }
                        v1 = null;
lbl19:
                        // 2 sources

                        var6_11 = v1;
                        v2 = var6_11 instanceof StatementResult.Object != false ? (StatementResult.Object)var6_11 : null;
                        if (v2 != null) {
                            v0 = v2.getResultSet();
                            break;
                        }
                        v0 = null;
                        break;
                    }
                    default: {
                        var1_1.executeUpdate();
                        v0 = var1_1.getResultSet();
                    }
                }
                v3 = var3_12 = v0;
                if (v3 != null) {
                    var4_13 = v3;
                    var5_14 = this.$transform;
                    var6_11 = null;
                    try {
                        var7_3 = (ResultSet)var4_13;
                        var8_6 = false;
                        var7_3 = var5_14.invoke(var7_3);
                        v4 = var7_3;
                    }
                    catch (Throwable var7_4) {
                        var6_11 = var7_4;
                        throw var7_4;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)var4_13, (Throwable)var6_11);
                    }
                } else {
                    v4 = null;
                }
                return (T)v4;
            }

            public String prepareSQL(Transaction transaction2, boolean bl) {
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
                return this.$stmt;
            }

            public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
                Iterable<Pair<IColumnType<?>, Object>> iterable = this.$args;
                boolean bl = false;
                Iterable<Pair<IColumnType<?>, Object>> iterable2 = iterable;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
                boolean bl2 = false;
                Iterator<Pair<IColumnType<?>, Object>> iterator2 = iterable2.iterator();
                while (iterator2.hasNext()) {
                    IColumnType iColumnType;
                    Pair<IColumnType<?>, Object> pair;
                    Pair<IColumnType<?>, Object> pair2 = pair = iterator2.next();
                    Collection collection2 = collection;
                    boolean bl3 = false;
                    IColumnType iColumnType2 = (IColumnType)pair2.component1();
                    Object object = pair2.component2();
                    IColumnType iColumnType3 = iColumnType = iColumnType2;
                    boolean bl4 = false;
                    iColumnType3.setNullable(true);
                    collection2.add(TuplesKt.to((Object)iColumnType, (Object)object));
                }
                return CollectionsKt.listOf((Object)((List)collection));
            }
        });
    }

    public static /* synthetic */ Object exec$default(Transaction transaction2, String string, Iterable iterable, StatementType statementType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return transaction2.exec(string, iterable, statementType, function1);
    }

    public final <T> T exec(Statement<? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"");
        return (T)this.exec(statement, exec.3.INSTANCE);
    }

    public final void execInBatch(List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.getConnection().executeInBatch(list);
    }

    public final <T, R> R exec(Statement<? extends T> statement, Function2<? super Statement<? extends T>, ? super T, ? extends R> function2) {
        Object object;
        int n;
        Intrinsics.checkNotNullParameter(statement, (String)"");
        Intrinsics.checkNotNullParameter(function2, (String)"");
        int n2 = this.statementCount;
        this.statementCount = n2 + 1;
        long l = System.nanoTime();
        Pair<? extends T, List<StatementContext>> pair = statement.executeIn$exposed_core(this);
        long l2 = System.nanoTime() - l;
        boolean bl = false;
        long l3 = TimeUnit.NANOSECONDS.toMillis(l2);
        Lazy lazy = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(pair, this){
            final /* synthetic */ Pair<T, List<StatementContext>> $answer;
            final /* synthetic */ Transaction this$0;
            {
                this.$answer = pair;
                this.this$0 = transaction2;
                super(0);
            }

            public final String invoke() {
                Iterable iterable = (Iterable)this.$answer.getSecond();
                Transaction transaction2 = this.this$0;
                boolean bl = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl2 = false;
                for (T t : iterable2) {
                    StatementContext statementContext = (StatementContext)t;
                    Collection collection2 = collection;
                    boolean bl3 = false;
                    collection2.add(statementContext.sql(transaction2));
                }
                return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)collection)), null, null, null, (int)0, null, null, (int)63, null);
            }
        }));
        this.duration += l3;
        if (this.debug) {
            Object object2;
            this.statements.append(this.describeStatement(l3, (String)lazy.getValue()));
            Map map = this.getStatementStats();
            Object object3 = lazy.getValue();
            bl = false;
            Object v = map.get(object3);
            if (v == null) {
                boolean bl2 = false;
                Pair pair2 = TuplesKt.to((Object)0, (Object)0L);
                map.put(object3, pair2);
                object2 = pair2;
            } else {
                object2 = v;
            }
            object3 = (Pair)object2;
            bl = false;
            n = ((Number)object3.component1()).intValue();
            long l4 = ((Number)object3.component2()).longValue();
            ((Map)this.getStatementStats()).put(lazy.getValue(), TuplesKt.to((Object)(n + 1), (Object)(l4 + l3)));
        }
        Long l5 = this.warnLongQueriesDuration;
        if (l3 > (l5 != null ? l5 : Long.MAX_VALUE)) {
            SQLLogKt.getExposedLogger().warn("Long query: " + this.describeStatement(l3, (String)lazy.getValue()), (Throwable)new LongQueryException());
        }
        Object object4 = pair.getFirst();
        if (object4 != null) {
            Object object5 = object4;
            n = 0;
            object = function2.invoke(statement, object5);
        } else {
            object = null;
        }
        return (R)object;
    }

    public final String identity(Table table) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)table, (String)"");
                object = table instanceof Alias ? (Alias)table : null;
                if (object == null) break block2;
                Alias alias = object;
                boolean bl = false;
                String string = this.identity((Table)alias.getDelegate()) + ' ' + this.db.getIdentifierManager().quoteIfNecessary(alias.getAlias());
                object = string;
                if (string != null) break block3;
            }
            object = this.db.getIdentifierManager().quoteIfNecessary(DatabaseDialectKt.inProperCase(table.getTableName()));
        }
        return object;
    }

    public final String fullIdentity(Column<?> column) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter(column, (String)"");
        QueryBuilder queryBuilder2 = queryBuilder = new QueryBuilder(false);
        boolean bl = false;
        this.fullIdentity$exposed_core(column, queryBuilder2);
        return queryBuilder.toString();
    }

    public final void fullIdentity$exposed_core(Column<?> column, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(column, this){
            final /* synthetic */ Column<?> $column;
            final /* synthetic */ Transaction this$0;
            {
                this.$column = column;
                this.this$0 = transaction2;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                if (this.$column.getTable() instanceof Alias) {
                    queryBuilder.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(((Alias)this.$column.getTable()).getAlias()));
                } else {
                    queryBuilder.append(this.this$0.getDb().getIdentifierManager().quoteIfNecessary(DatabaseDialectKt.inProperCase(this.$column.getTable().getTableName())));
                }
                queryBuilder.append('.');
                queryBuilder.append(this.this$0.identity(this.$column));
            }
        }));
    }

    public final String identity(Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        return this.db.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(column.getName());
    }

    public final void closeExecutedStatements() {
        Iterable iterable = this.executedStatements;
        boolean bl = false;
        for (Object t : iterable) {
            PreparedStatementApi preparedStatementApi = (PreparedStatementApi)t;
            boolean bl2 = false;
            preparedStatementApi.closeIfPossible();
        }
        this.openResultSetsCount = 0;
        this.executedStatements.clear();
    }

    public final long getRetryInterval$exposed_core() {
        return this.maxAttempts > 0 ? Math.max((this.maxRetryDelay - this.minRetryDelay) / (long)(this.maxAttempts + 1), 1L) : 0L;
    }

    static {
        ServiceLoader<GlobalStatementInterceptor> serviceLoader = ServiceLoader.load(GlobalStatementInterceptor.class, GlobalStatementInterceptor.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"");
        Iterable iterable = serviceLoader;
        boolean bl = false;
        for (Object t : iterable) {
            GlobalStatementInterceptor globalStatementInterceptor = (GlobalStatementInterceptor)t;
            boolean bl2 = false;
            globalInterceptors.add(globalStatementInterceptor);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/Transaction$Companion;", "", "()V", "globalInterceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "Lkotlin/collections/ArrayList;", "getGlobalInterceptors$exposed_core", "()Ljava/util/ArrayList;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public final ArrayList<GlobalStatementInterceptor> getGlobalInterceptors$exposed_core() {
            return globalInterceptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

