/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u0010\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00120\u00110\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u001b\u0010\u001a\u001a\u0004\u0018\u00010\u0002*\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001cR\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/statements/InsertSelectStatement;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "selectQuery", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "isIgnore", "", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/AbstractQuery;Z)V", "getColumns", "()Ljava/util/List;", "()Z", "getSelectQuery", "()Lorg/jetbrains/exposed/sql/AbstractQuery;", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "prepared", "executeInternal", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "exposed-core"})
public class InsertSelectStatement
extends Statement<Integer> {
    private final List<Column<?>> columns;
    private final AbstractQuery<?> selectQuery;
    private final boolean isIgnore;

    public InsertSelectStatement(List<? extends Column<?>> list, AbstractQuery<?> abstractQuery, boolean bl) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(abstractQuery, (String)"");
        super(StatementType.INSERT, CollectionsKt.listOf((Object)((Column)CollectionsKt.first(list)).getTable()));
        this.columns = list;
        this.selectQuery = abstractQuery;
        this.isIgnore = bl;
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("Can't insert without provided columns".toString());
        }
        Iterable iterable = this.columns;
        boolean bl2 = false;
        HashSet<Column> hashSet = new HashSet<Column>();
        ArrayList arrayList = new ArrayList();
        for (Object t : iterable) {
            DdlAware ddlAware = (Column)t;
            boolean bl3 = false;
            if (!hashSet.add((Column)(ddlAware = ddlAware.getTable()))) continue;
            arrayList.add(t);
        }
        List list2 = arrayList;
        if (((Collection)list2).size() > 1) {
            throw new IllegalStateException(("Can't insert to different tables " + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)1.INSTANCE, (int)31, null) + " from single select").toString());
        }
        if (this.columns.size() != this.selectQuery.getSet().getFields().size()) {
            throw new IllegalStateException("Columns count doesn't equal to query columns count".toString());
        }
    }

    public /* synthetic */ InsertSelectStatement(List list, AbstractQuery abstractQuery, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list, abstractQuery, bl);
    }

    public final List<Column<?>> getColumns() {
        return this.columns;
    }

    public final AbstractQuery<?> getSelectQuery() {
        return this.selectQuery;
    }

    public final boolean isIgnore() {
        return this.isIgnore;
    }

    @Override
    public Integer executeInternal(PreparedStatementApi preparedStatementApi, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)preparedStatementApi, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return preparedStatementApi.executeUpdate();
    }

    @Override
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.selectQuery.arguments();
    }

    @Override
    public String prepareSQL(Transaction transaction2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return transaction2.getDb().getDialect().getFunctionProvider().insert(this.isIgnore, (Table)CollectionsKt.single(this.getTargets()), this.columns, this.selectQuery.prepareSQL(transaction2, bl), transaction2);
    }
}

