/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.CompositeColumn;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0015\u0010\u0018\u001a\u00020\n2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0096\u0002JL\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u001a\"\u000e\b\u0002\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001a0\u001c\"\u000e\b\u0003\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u00112\u0006\u0010\u001f\u001a\u0002H\u001dH\u0087\u0002\u00a2\u0006\u0004\b \u0010!J*\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00112\u0006\u0010\u001f\u001a\u0002H\u001aH\u0097\u0002\u00a2\u0006\u0002\u0010\"J%\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u00112\u0006\u0010\u001f\u001a\u00020#H\u0096\u0002JF\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001a*\u0004\u0018\u0001H\u0001\"\u000e\b\u0003\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001a0\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\u0006\u0010\u001f\u001a\u0002H\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010!J<\u0010\u0019\u001a\u00020\u0016\"\u000e\b\u0001\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0$2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u001c0\u00112\u0006\u0010\u001f\u001a\u0002H\u001aH\u0087\u0002\u00a2\u0006\u0004\b%\u0010&J@\u0010\u0019\u001a\u00020\u0016\"\u000e\b\u0001\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0$2\u0014\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001a\u0018\u00010\u001c0\u00112\b\u0010\u001f\u001a\u0004\u0018\u0001H\u001aH\u0087\u0002\u00a2\u0006\u0004\b'\u0010&J*\u0010\u0019\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001a0(2\u0006\u0010\u001f\u001a\u0002H\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010)J6\u0010*\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001a*\u0004\u0018\u0001H\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eH\u0016JG\u0010*\u001a\u00020\u0016\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001a*\u0004\u0018\u0001H\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00112\u001d\u0010\u001f\u001a\u0019\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0\u001e0+\u00a2\u0006\u0002\b-H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006."}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "T", "Lorg/jetbrains/exposed/sql/statements/Statement;", "type", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "targets", "", "Lorg/jetbrains/exposed/sql/Table;", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "hasBatchedValues", "", "getHasBatchedValues", "()Z", "setHasBatchedValues", "(Z)V", "values", "", "Lorg/jetbrains/exposed/sql/Column;", "", "getValues", "()Ljava/util/Map;", "checkThatExpressionWasNotSetInPreviousBatch", "", "column", "contains", "set", "S", "ID", "Lorg/jetbrains/exposed/dao/id/EntityID;", "E", "Lorg/jetbrains/exposed/sql/Expression;", "value", "setWithEntityIdExpression", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/Expression;)V", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "Lorg/jetbrains/exposed/sql/Query;", "", "setWithEntityIdValue", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Comparable;)V", "setWithNullableEntityIdValue", "Lorg/jetbrains/exposed/sql/CompositeColumn;", "(Lorg/jetbrains/exposed/sql/CompositeColumn;Ljava/lang/Object;)V", "update", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "Lkotlin/ExtensionFunctionType;", "exposed-core"})
public abstract class UpdateBuilder<T>
extends Statement<T> {
    private final Map<Column<?>, Object> values;
    private boolean hasBatchedValues;

    public UpdateBuilder(StatementType statementType, List<? extends Table> list) {
        Intrinsics.checkNotNullParameter((Object)((Object)statementType), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        super(statementType, list);
        this.values = new LinkedHashMap();
    }

    protected final Map<Column<?>, Object> getValues() {
        return this.values;
    }

    public boolean contains(Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        return this.values.containsKey(column);
    }

    protected final boolean getHasBatchedValues() {
        return this.hasBatchedValues;
    }

    protected final void setHasBatchedValues(boolean bl) {
        this.hasBatchedValues = bl;
    }

    private final void checkThatExpressionWasNotSetInPreviousBatch(Column<?> column) {
        if (!(!this.values.containsKey(column) || !this.hasBatchedValues)) {
            boolean bl = false;
            String string = column + " is already initialized in a batch";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public <S> void set(Column<S> column, S s) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        if (!(column.getColumnType().getNullable() || s != null && !(s instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        column.getColumnType().validateValueBeforeUpdate(s);
        this.values.put(column, s);
    }

    public final <S extends Comparable<? super S>> void setWithEntityIdValue(Column<EntityID<S>> column, S s) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter(s, (String)"");
        DdlAware ddlAware = column.getForeignKey();
        if (ddlAware == null || (ddlAware = ddlAware.getTargetTable()) == null) {
            ddlAware = column.getTable();
        }
        Intrinsics.checkNotNull((Object)ddlAware);
        EntityID<S> entityID = new EntityID<S>(s, (IdTable)ddlAware);
        column.getColumnType().validateValueBeforeUpdate(entityID);
        this.values.put(column, entityID);
    }

    public final <S extends Comparable<? super S>> void setWithNullableEntityIdValue(Column<EntityID<S>> column, S s) {
        EntityID<S> entityID;
        Intrinsics.checkNotNullParameter(column, (String)"");
        if (!(column.getColumnType().getNullable() || s != null)) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        S s2 = s;
        if (s2 != null) {
            S s3 = s2;
            boolean bl = false;
            DdlAware ddlAware = column.getForeignKey();
            if (ddlAware == null || (ddlAware = ddlAware.getTargetTable()) == null) {
                ddlAware = column.getTable();
            }
            Intrinsics.checkNotNull((Object)ddlAware);
            entityID = new EntityID<S>(s3, (IdTable)ddlAware);
        } else {
            entityID = null;
        }
        EntityID<S> entityID2 = entityID;
        column.getColumnType().validateValueBeforeUpdate(entityID2);
        this.values.put(column, entityID2);
    }

    public final <S, ID extends EntityID<S>, E extends Expression<S>> void setWithEntityIdExpression(Column<ID> column, E e) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter(e, (String)"");
        if (!(column.getColumnType().getNullable() || !(e instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        this.values.put(column, e);
    }

    public <T, S extends T, E extends Expression<S>> void set(Column<T> column, E e) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter(e, (String)"");
        this.update(column, e);
    }

    public <S> void set(Column<S> column, Query query2) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"");
        this.update(column, AliasKt.wrapAsExpression(query2));
    }

    public <S> void set(CompositeColumn<S> compositeColumn, S s) {
        Intrinsics.checkNotNullParameter(compositeColumn, (String)"");
        Map<Column<?>, Object> map = compositeColumn.getRealColumnsWithValues(s);
        boolean bl = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> entry;
            Map.Entry<Column<?>, Object> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            Column<?> column = entry2.getKey();
            Object object = entry2.getValue();
            Intrinsics.checkNotNull(column);
            this.set(column, (Expression)object);
        }
    }

    public <T, S extends T> void update(Column<T> column, Expression<S> expression) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter(expression, (String)"");
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        this.values.put(column, expression);
    }

    public <T, S extends T> void update(Column<T> column, Function1<? super SqlExpressionBuilder, ? extends Expression<S>> function1) {
        Intrinsics.checkNotNullParameter(column, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.update(column, (Expression)function1.invoke((Object)SqlExpressionBuilder.INSTANCE));
    }
}

