/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.GroupConcat;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.PostgreSQLFunctionProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0010\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J9\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ*\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010 \u001a\u00020\u0006\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070!2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\"\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J:\u0010#\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J>\u0010'\u001a\u00020\u00062\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\t2\b\u0010*\u001a\u0004\u0018\u00010\u00042\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\r\u001a\u00020\u000eH\u0016JK\u0010-\u001a\u00020\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040.\"\u00020\u00042\b\u0010/\u001a\u0004\u0018\u00010\u00042\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u00100JQ\u00101\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040.\"\u00020\u00042\u0006\u00102\u001a\u00020\u00142\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u00103J2\u00104\u001a\u00020\u0006\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u00105\u001a\u00020\u0004H\u0016J$\u00106\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u00107\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000eH\u0016J@\u0010<\u001a\u00020\u0006\"\n\b\u0000\u0010\u0007*\u0004\u0018\u00010\u00042\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010?\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\u0010\u0010@\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0%2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J$\u0010B\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016JW\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020E2\u001e\u0010F\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\u0006\u0012\u0004\u0018\u00010H0G0%2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010I2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010JJW\u0010C\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00162\u001e\u0010F\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\u0006\u0012\u0004\u0018\u00010H0G0%2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010I2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010KJ\u00a1\u0001\u0010L\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u001e\u0010M\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\u0006\u0012\u0004\u0018\u00010H0G0%2\"\u0010N\u001a\u001e\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0G\u0018\u00010%2\u0012\u0010O\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0018\u00010%2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010I2\u0006\u0010\u0019\u001a\u00020\u001a2\u001a\u0010P\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030&0.\"\u0006\u0012\u0002\b\u00030&H\u0016\u00a2\u0006\u0002\u0010QJ$\u0010R\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010S\u001a\u00020\u0006*\u00060Tj\u0002`U2\u0006\u0010\u001e\u001a\u00020\u0004H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLFunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "onConflictIgnore", "", "arraySlice", "", "T", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "lower", "", "upper", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "(Lorg/jetbrains/exposed/sql/Expression;Ljava/lang/Integer;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "day", "expr", "delete", "ignore", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "where", "limit", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "explain", "analyze", "options", "internalStatement", "groupConcat", "Lorg/jetbrains/exposed/sql/GroupConcat;", "hour", "insert", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "jsonContains", "target", "candidate", "path", "jsonType", "Lorg/jetbrains/exposed/sql/IColumnType;", "jsonExists", "", "optional", "(Lorg/jetbrains/exposed/sql/Expression;[Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/exposed/sql/IColumnType;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "jsonExtract", "toScalar", "(Lorg/jetbrains/exposed/sql/Expression;[Ljava/lang/String;ZLorg/jetbrains/exposed/sql/IColumnType;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "locate", "substring", "minute", "month", "nextVal", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "builder", "regexp", "expr1", "pattern", "caseSensitive", "returning", "mainSql", "second", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "Lkotlin/Pair;", "", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "upsert", "data", "onUpdate", "onUpdateExclude", "keys", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;[Lorg/jetbrains/exposed/sql/Column;)Ljava/lang/String;", "year", "appendOptionsToExplain", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "exposed-core"})
public final class PostgreSQLFunctionProvider
extends FunctionProvider {
    public static final PostgreSQLFunctionProvider INSTANCE = new PostgreSQLFunctionProvider();
    private static final String onConflictIgnore = "ON CONFLICT DO NOTHING";

    private PostgreSQLFunctionProvider() {
    }

    @Override
    public void nextVal(Sequence sequence, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(sequence){
            final /* synthetic */ Sequence $seq;
            {
                this.$seq = sequence;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                Object[] objectArray = new Object[]{"NEXTVAL('", this.$seq.getIdentifier(), "')"};
                ExpressionKt.append(queryBuilder, objectArray);
            }
        }));
    }

    @Override
    public <T extends String> void groupConcat(GroupConcat<T> groupConcat2, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(groupConcat2, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        Transaction transaction2 = TransactionManager.Companion.current();
        if (groupConcat2.getSeparator() == null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "PostgreSQL requires explicit separator in STRING_AGG function.");
            throw new KotlinNothingValueException();
        }
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(groupConcat2){
            final /* synthetic */ GroupConcat<T> $expr;
            {
                this.$expr = groupConcat2;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("STRING_AGG(");
                if (this.$expr.getDistinct()) {
                    queryBuilder.append(" DISTINCT ");
                }
                Object[] objectArray = new Object[]{this.$expr.getExpr(), ", '", this.$expr.getSeparator(), "'"};
                ExpressionKt.append(queryBuilder, objectArray);
                if (!(this.$expr.getOrderBy().length == 0)) {
                    QueryBuilder.appendTo$default(queryBuilder, this.$expr.getOrderBy(), null, (CharSequence)" ORDER BY ", null, (Function2)groupConcat.1.INSTANCE, 5, null);
                }
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public <T extends String> void locate(QueryBuilder queryBuilder, Expression<T> expression, String string) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(string, expression){
            final /* synthetic */ String $substring;
            final /* synthetic */ Expression<T> $expr;
            {
                this.$substring = string;
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                Object[] objectArray = new Object[]{"POSITION('", this.$substring, "' IN ", this.$expr, ")"};
                ExpressionKt.append(queryBuilder, objectArray);
            }
        }));
    }

    @Override
    public <T extends String> void regexp(Expression<T> expression, Expression<String> expression2, boolean bl, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter(expression2, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression, bl, expression2){
            final /* synthetic */ Expression<T> $expr1;
            final /* synthetic */ boolean $caseSensitive;
            final /* synthetic */ Expression<String> $pattern;
            {
                this.$expr1 = expression;
                this.$caseSensitive = bl;
                this.$pattern = expression2;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append(this.$expr1);
                if (this.$caseSensitive) {
                    queryBuilder.append(" ~ ");
                } else {
                    queryBuilder.append(" ~* ");
                }
                queryBuilder.append(this.$pattern);
            }
        }));
    }

    @Override
    public <T> void year(Expression<T> expression, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("Extract(YEAR FROM ");
                queryBuilder.append(this.$expr);
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public <T> void month(Expression<T> expression, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("Extract(MONTH FROM ");
                queryBuilder.append(this.$expr);
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public <T> void day(Expression<T> expression, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("Extract(DAY FROM ");
                queryBuilder.append(this.$expr);
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public <T> void hour(Expression<T> expression, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("Extract(HOUR FROM ");
                queryBuilder.append(this.$expr);
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public <T> void minute(Expression<T> expression, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("Extract(MINUTE FROM ");
                queryBuilder.append(this.$expr);
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public <T> void second(Expression<T> expression, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = expression;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("Extract(SECOND FROM ");
                queryBuilder.append(this.$expr);
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public <T> void arraySlice(Expression<T> expression, Integer n, Integer n2, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression, n, n2){
            final /* synthetic */ Expression<T> $expression;
            final /* synthetic */ Integer $lower;
            final /* synthetic */ Integer $upper;
            {
                this.$expression = expression;
                this.$lower = n;
                this.$upper = n2;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                boolean bl;
                int n;
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                Object[] objectArray = new Object[]{this.$expression, "["};
                ExpressionKt.append(queryBuilder, objectArray);
                Integer n2 = this.$lower;
                if (n2 != null) {
                    n = ((Number)n2).intValue();
                    bl = false;
                    queryBuilder.unaryPlus(String.valueOf(n));
                }
                queryBuilder.unaryPlus(":");
                Integer n3 = this.$upper;
                if (n3 != null) {
                    n = ((Number)n3).intValue();
                    bl = false;
                    queryBuilder.unaryPlus(String.valueOf(n));
                }
                queryBuilder.unaryPlus("]");
            }
        }));
    }

    @Override
    public <T> void jsonExtract(Expression<T> expression, String[] stringArray, boolean bl, IColumnType<?> iColumnType, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(iColumnType, bl, expression, stringArray){
            final /* synthetic */ IColumnType<?> $jsonType;
            final /* synthetic */ boolean $toScalar;
            final /* synthetic */ Expression<T> $expression;
            final /* synthetic */ String[] $path;
            {
                this.$jsonType = iColumnType;
                this.$toScalar = bl;
                this.$expression = expression;
                this.$path = stringArray;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append(this.$jsonType.sqlType() + "_EXTRACT_PATH");
                if (this.$toScalar) {
                    queryBuilder.append("_TEXT");
                }
                Object[] objectArray2 = new Object[]{"(", this.$expression, ", "};
                ExpressionKt.append(queryBuilder, objectArray2);
                QueryBuilder queryBuilder2 = queryBuilder;
                objectArray2 = this.$path;
                if (objectArray2.length == 0) {
                    QueryBuilder queryBuilder3 = queryBuilder2;
                    boolean bl = false;
                    String[] stringArray = new String[]{"$"};
                    objectArray = stringArray;
                    queryBuilder2 = queryBuilder3;
                } else {
                    objectArray = objectArray2;
                }
                QueryBuilder.appendTo$default(queryBuilder2, objectArray, null, null, null, (Function2)jsonExtract.2.INSTANCE, 7, null);
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public void jsonContains(Expression<?> expression, Expression<?> expression2, String string, IColumnType<?> iColumnType, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter(expression2, (String)"");
        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            ExceptionsKt.throwUnsupportedException(TransactionManager.Companion.current(), "PostgreSQL does not support a JSON path argument");
            throw new KotlinNothingValueException();
        }
        boolean bl = !((JsonColumnMarker)((Object)iColumnType)).getUsesBinaryFormat();
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expression, bl, expression2){
            final /* synthetic */ Expression<?> $target;
            final /* synthetic */ boolean $isNotJsonB;
            final /* synthetic */ Expression<?> $candidate;
            {
                this.$target = expression;
                this.$isNotJsonB = bl;
                this.$candidate = expression2;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append(this.$target);
                if (this.$isNotJsonB) {
                    queryBuilder.append("::jsonb");
                }
                Object[] objectArray = new Object[]{" @> ", this.$candidate};
                ExpressionKt.append(queryBuilder, objectArray);
                if (this.$isNotJsonB) {
                    queryBuilder.append("::jsonb");
                }
            }
        }));
    }

    @Override
    public void jsonExists(Expression<?> expression, String[] stringArray, String string, IColumnType<?> iColumnType, QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        Intrinsics.checkNotNullParameter(iColumnType, (String)"");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
        if (stringArray.length > 1) {
            ExceptionsKt.throwUnsupportedException(TransactionManager.Companion.current(), "PostgreSQL does not support multiple JSON path arguments");
            throw new KotlinNothingValueException();
        }
        boolean bl = !((JsonColumnMarker)((Object)iColumnType)).getUsesBinaryFormat();
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(bl, expression, stringArray, string){
            final /* synthetic */ boolean $isNotJsonB;
            final /* synthetic */ Expression<?> $expression;
            final /* synthetic */ String[] $path;
            final /* synthetic */ String $optional;
            {
                this.$isNotJsonB = bl;
                this.$expression = expression;
                this.$path = stringArray;
                this.$optional = string;
                super(1);
            }

            public final void invoke(QueryBuilder queryBuilder) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                queryBuilder.append("JSONB_PATH_EXISTS(");
                if (this.$isNotJsonB) {
                    objectArray = new Object[]{"CAST(", this.$expression, " as jsonb), "};
                    ExpressionKt.append(queryBuilder, objectArray);
                } else {
                    objectArray = new Object[]{this.$expression, ", "};
                    ExpressionKt.append(queryBuilder, objectArray);
                }
                objectArray = new Object[3];
                objectArray[0] = "'$";
                String string = (String)ArraysKt.firstOrNull((Object[])this.$path);
                if (string == null) {
                    string = "";
                }
                objectArray[1] = string;
                objectArray[2] = "'";
                ExpressionKt.append(queryBuilder, objectArray);
                String string2 = this.$optional;
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl = false;
                    queryBuilder.append(", '" + string3 + '\'');
                }
                queryBuilder.append(")");
            }
        }));
    }

    @Override
    public String insert(boolean bl, Table table, List<? extends Column<?>> list, String string, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        String string2 = super.insert(false, table, list, string, transaction2);
        return bl ? string2 + " ON CONFLICT DO NOTHING" : string2;
    }

    @Override
    public String update(Table table, List<? extends Pair<? extends Column<?>, ? extends Object>> list, Integer n, Op<Boolean> op, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        if (n != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "PostgreSQL doesn't support LIMIT in UPDATE clause.");
            throw new KotlinNothingValueException();
        }
        return super.update(table, list, n, op, transaction2);
    }

    @Override
    public String update(Join join, List<? extends Pair<? extends Column<?>, ? extends Object>> list, Integer n, Op<Boolean> op, Transaction transaction2) {
        QueryBuilder queryBuilder;
        block8: {
            boolean bl;
            Table table;
            boolean bl2;
            block7: {
                Intrinsics.checkNotNullParameter((Object)join, (String)"");
                Intrinsics.checkNotNullParameter(list, (String)"");
                Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
                queryBuilder = new QueryBuilder(true);
                boolean bl3 = false;
                if (n != null) {
                    ExceptionsKt.throwUnsupportedException(transaction2, "PostgreSQL doesn't support LIMIT in UPDATE clause.");
                    throw new KotlinNothingValueException();
                }
                Iterable iterable = list;
                bl2 = false;
                Iterable iterable22 = iterable;
                Object object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl4 = false;
                for (Object t : iterable22) {
                    Pair pair = (Pair)t;
                    Collection collection = object;
                    boolean bl5 = false;
                    collection.add(((Column)pair.getFirst()).getTable());
                }
                Table table2 = (Table)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)object)));
                if (table2 == null) {
                    ExceptionsKt.throwUnsupportedException(transaction2, "PostgreSQL supports a join updates with a single table columns to update.");
                    throw new KotlinNothingValueException();
                }
                table = table2;
                Iterable iterable3 = join.getJoinParts$exposed_core();
                boolean bl6 = false;
                if (iterable3 instanceof Collection && ((Collection)iterable3).isEmpty()) {
                    bl = false;
                } else {
                    for (Iterable iterable22 : iterable3) {
                        object = (Join.JoinPart)((Object)iterable22);
                        bl4 = false;
                        if (!(((Join.JoinPart)object).getJoinType() != JoinType.INNER)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
            }
            queryBuilder.unaryPlus("UPDATE ");
            table.describe(transaction2, queryBuilder);
            queryBuilder.unaryPlus(" SET ");
            ExpressionKt.appendTo$default(list, queryBuilder, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = transaction2;
                    super(2);
                }

                public final void invoke(QueryBuilder queryBuilder, Pair<? extends Column<?>, ? extends Object> pair) {
                    Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                    Intrinsics.checkNotNullParameter(pair, (String)"");
                    Column column = (Column)pair.component1();
                    Object object = pair.component2();
                    queryBuilder.append(this.$transaction.identity(column) + '=');
                    queryBuilder.registerArgument(column, object);
                }
            }, 14, null);
            INSTANCE.appendJoinPartForUpdateClause(queryBuilder, table, join, transaction2);
            Op<Boolean> op2 = op;
            if (op2 == null) break block8;
            Op<Boolean> op3 = op2;
            bl2 = false;
            queryBuilder.unaryPlus(" AND ");
            queryBuilder.unaryPlus((Expression)op3);
        }
        return queryBuilder.toString();
    }

    @Override
    public String upsert(Table table, List<? extends Pair<? extends Column<?>, ? extends Object>> list, List<? extends Pair<? extends Column<?>, ? extends Expression<?>>> list2, List<? extends Column<?>> list3, Op<Boolean> op, Transaction transaction2, Column<?> ... columnArray) {
        QueryBuilder queryBuilder;
        block1: {
            Intrinsics.checkNotNullParameter((Object)table, (String)"");
            Intrinsics.checkNotNullParameter(list, (String)"");
            Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
            Intrinsics.checkNotNullParameter(columnArray, (String)"");
            List<Column<?>> list4 = this.getKeyColumnsForUpsert(table, Arrays.copyOf(columnArray, columnArray.length));
            List<Column<?>> list5 = list4;
            if (list5 == null || list5.isEmpty()) {
                ExceptionsKt.throwUnsupportedException(transaction2, "UPSERT requires a unique key or constraint as a conflict target");
                throw new KotlinNothingValueException();
            }
            list5 = this.getUpdateColumnsForUpsert((List)CollectionsKt.unzip((Iterable)list).getFirst(), list3, list4);
            queryBuilder = new QueryBuilder(true);
            boolean bl = false;
            INSTANCE.appendInsertToUpsertClause(queryBuilder, table, list, transaction2);
            queryBuilder.unaryPlus(" ON CONFLICT ");
            QueryBuilder.appendTo$default(queryBuilder, list4, null, (CharSequence)"(", (CharSequence)")", new Function2<QueryBuilder, Column<?>, Unit>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = transaction2;
                    super(2);
                }

                public final void invoke(QueryBuilder queryBuilder, Column<?> column) {
                    Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"");
                    Intrinsics.checkNotNullParameter(column, (String)"");
                    queryBuilder.append(this.$transaction.identity(column));
                }
            }, 1, null);
            queryBuilder.unaryPlus(" DO");
            INSTANCE.appendUpdateToUpsertClause(queryBuilder, table, list5, list2, transaction2, false);
            Op<Boolean> op2 = op;
            if (op2 == null) break block1;
            Op<Boolean> op3 = op2;
            boolean bl2 = false;
            queryBuilder.unaryPlus(" WHERE ");
            queryBuilder.unaryPlus((Expression)op3);
        }
        return queryBuilder.toString();
    }

    @Override
    public String delete(boolean bl, Table table, String string, Integer n, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        if (n != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "PostgreSQL doesn't support LIMIT in DELETE clause.");
            throw new KotlinNothingValueException();
        }
        return super.delete(bl, table, string, n, transaction2);
    }

    @Override
    public String explain(boolean bl, String string, String string2, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        return bl && string != null ? super.explain(false, "ANALYZE TRUE, " + string, string2, transaction2) : super.explain(bl, string, string2, transaction2);
    }

    @Override
    protected void appendOptionsToExplain(StringBuilder stringBuilder, String string) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        stringBuilder.append('(' + string + ") ");
    }

    @Override
    public String returning(String string, List<? extends Expression<?>> list, Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"");
        QueryBuilder queryBuilder = new QueryBuilder(true);
        boolean bl = false;
        queryBuilder.unaryPlus(string + " RETURNING ");
        QueryBuilder.appendTo$default(queryBuilder, list, null, null, null, (Function2)returning.1.1.INSTANCE, 7, null);
        return queryBuilder.toString();
    }
}

