/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.XAttr;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class XAttrUtil {
    public static List<String> listXAttr(String string) {
        long l = XAttr.INSTANCE.listxattr(string, null, 0L, 0);
        if (l < 0L) {
            return null;
        }
        if (l == 0L) {
            return new ArrayList<String>(0);
        }
        Memory memory = new Memory(l);
        long l2 = XAttr.INSTANCE.listxattr(string, (Pointer)memory, l, 0);
        if (l2 < 0L) {
            return null;
        }
        return XAttrUtil.decodeStringSequence(memory.getByteBuffer(0L, l2));
    }

    public static String getXAttr(String string, String string2) {
        long l = XAttr.INSTANCE.getxattr(string, string2, null, 0L, 0, 0);
        if (l < 0L) {
            return null;
        }
        if (l == 0L) {
            return "";
        }
        Memory memory = new Memory(l);
        memory.clear();
        long l2 = XAttr.INSTANCE.getxattr(string, string2, (Pointer)memory, l, 0, 0);
        if (l2 < 0L) {
            return null;
        }
        return Native.toString((byte[])memory.getByteArray(0L, (int)l), (String)"UTF-8");
    }

    public static int setXAttr(String string, String string2, String string3) {
        Memory memory = XAttrUtil.encodeString(string3);
        return XAttr.INSTANCE.setxattr(string, string2, (Pointer)memory, memory.size(), 0, 0);
    }

    public static int removeXAttr(String string, String string2) {
        return XAttr.INSTANCE.removexattr(string, string2, 0);
    }

    protected static Memory encodeString(String string) {
        byte[] byArray = string.getBytes(Charset.forName("UTF-8"));
        Memory memory = new Memory((long)byArray.length);
        memory.write(0L, byArray, 0, byArray.length);
        return memory;
    }

    protected static String decodeString(ByteBuffer byteBuffer) {
        return Charset.forName("UTF-8").decode(byteBuffer).toString();
    }

    protected static List<String> decodeStringSequence(ByteBuffer byteBuffer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        byteBuffer.mark();
        while (byteBuffer.hasRemaining()) {
            if (byteBuffer.get() != 0) continue;
            ByteBuffer byteBuffer2 = (ByteBuffer)byteBuffer.duplicate().limit(byteBuffer.position() - 1).reset();
            if (byteBuffer2.hasRemaining()) {
                arrayList.add(XAttrUtil.decodeString(byteBuffer2));
            }
            byteBuffer.mark();
        }
        return arrayList;
    }
}

