/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectEncoder;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;

public class HttpResponseEncoder
extends HttpObjectEncoder<HttpResponse> {
    @Override
    public boolean acceptOutboundMessage(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == DefaultFullHttpResponse.class || clazz == DefaultHttpResponse.class) {
            return true;
        }
        return super.acceptOutboundMessage(object) && !(object instanceof HttpRequest);
    }

    @Override
    protected void encodeInitialLine(ByteBuf byteBuf, HttpResponse httpResponse) {
        httpResponse.protocolVersion().encode(byteBuf);
        byteBuf.writeByte(32);
        httpResponse.status().encode(byteBuf);
        ByteBufUtil.writeShortBE((ByteBuf)byteBuf, (int)3338);
    }

    @Override
    protected void sanitizeHeadersBeforeEncode(HttpResponse httpResponse, boolean bl) {
        if (bl) {
            HttpResponseStatus httpResponseStatus = httpResponse.status();
            if (httpResponseStatus.codeClass() == HttpStatusClass.INFORMATIONAL || httpResponseStatus.code() == HttpResponseStatus.NO_CONTENT.code()) {
                httpResponse.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                httpResponse.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            } else if (httpResponseStatus.code() == HttpResponseStatus.RESET_CONTENT.code()) {
                httpResponse.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                httpResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        }
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpResponse httpResponse) {
        HttpResponseStatus httpResponseStatus = httpResponse.status();
        if (httpResponseStatus.codeClass() == HttpStatusClass.INFORMATIONAL) {
            if (httpResponseStatus.code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code()) {
                return httpResponse.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION);
            }
            return true;
        }
        return httpResponseStatus.code() == HttpResponseStatus.NO_CONTENT.code() || httpResponseStatus.code() == HttpResponseStatus.NOT_MODIFIED.code() || httpResponseStatus.code() == HttpResponseStatus.RESET_CONTENT.code();
    }
}

