/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS = AsciiString.of((CharSequence)(HttpHeaderValues.CHARSET + "="));
    private static final AsciiString SEMICOLON = AsciiString.cached((String)";");
    private static final String COMMA_STRING = String.valueOf(',');
    private static final long TOKEN_CHARS_HIGH;
    private static final long TOKEN_CHARS_LOW;

    private HttpUtil() {
    }

    public static boolean isOriginForm(URI uRI) {
        return HttpUtil.isOriginForm(uRI.toString());
    }

    public static boolean isOriginForm(String string) {
        return string.startsWith("/");
    }

    public static boolean isAsteriskForm(URI uRI) {
        return HttpUtil.isAsteriskForm(uRI.toString());
    }

    public static boolean isAsteriskForm(String string) {
        return "*".equals(string);
    }

    public static boolean isKeepAlive(HttpMessage httpMessage) {
        return !httpMessage.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true) && (httpMessage.protocolVersion().isKeepAliveDefault() || httpMessage.headers().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true));
    }

    public static void setKeepAlive(HttpMessage httpMessage, boolean bl) {
        HttpUtil.setKeepAlive(httpMessage.headers(), httpMessage.protocolVersion(), bl);
    }

    public static void setKeepAlive(HttpHeaders httpHeaders, HttpVersion httpVersion, boolean bl) {
        if (httpVersion.isKeepAliveDefault()) {
            if (bl) {
                httpHeaders.remove((CharSequence)HttpHeaderNames.CONNECTION);
            } else {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
        } else if (bl) {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            httpHeaders.remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
    }

    public static long getContentLength(HttpMessage httpMessage) {
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l >= 0L) {
            return l;
        }
        throw new NumberFormatException("header not found: " + HttpHeaderNames.CONTENT_LENGTH);
    }

    public static long getContentLength(HttpMessage httpMessage, long l) {
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l2 = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l2 >= 0L) {
            return l2;
        }
        return l;
    }

    public static int getContentLength(HttpMessage httpMessage, int n) {
        return (int)Math.min(Integer.MAX_VALUE, HttpUtil.getContentLength(httpMessage, (long)n));
    }

    static int getWebSocketContentLength(HttpMessage httpMessage) {
        HttpResponse httpResponse;
        HttpHeaders httpHeaders = httpMessage.headers();
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            if (HttpMethod.GET.equals(httpRequest.method()) && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY1) && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (httpMessage instanceof HttpResponse && (httpResponse = (HttpResponse)httpMessage).status().code() == 101 && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && httpHeaders.contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static void setContentLength(HttpMessage httpMessage, long l) {
        httpMessage.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)l);
    }

    public static boolean isContentLengthSet(HttpMessage httpMessage) {
        return httpMessage.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage httpMessage) {
        return HttpUtil.isExpectHeaderValid(httpMessage) && httpMessage.headers().contains((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE, true);
    }

    static boolean isUnsupportedExpectation(HttpMessage httpMessage) {
        if (!HttpUtil.isExpectHeaderValid(httpMessage)) {
            return false;
        }
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.EXPECT);
        return string != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(string);
    }

    private static boolean isExpectHeaderValid(HttpMessage httpMessage) {
        return httpMessage instanceof HttpRequest && httpMessage.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static void set100ContinueExpected(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE);
        } else {
            httpMessage.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
        }
    }

    public static boolean isTransferEncodingChunked(HttpMessage httpMessage) {
        return httpMessage.headers().containsValue((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            httpMessage.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        } else {
            List<String> list = httpMessage.headers().getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            if (list.isEmpty()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CharSequence charSequence = (CharSequence)iterator.next();
                if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
                iterator.remove();
            }
            if (arrayList.isEmpty()) {
                httpMessage.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            } else {
                httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, arrayList);
            }
        }
    }

    public static Charset getCharset(HttpMessage httpMessage) {
        return HttpUtil.getCharset(httpMessage, CharsetUtil.ISO_8859_1);
    }

    public static Charset getCharset(CharSequence charSequence) {
        if (charSequence != null) {
            return HttpUtil.getCharset(charSequence, CharsetUtil.ISO_8859_1);
        }
        return CharsetUtil.ISO_8859_1;
    }

    public static Charset getCharset(HttpMessage httpMessage, Charset charset) {
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getCharset(string, charset);
        }
        return charset;
    }

    public static Charset getCharset(CharSequence charSequence, Charset charset) {
        CharSequence charSequence2;
        if (charSequence != null && (charSequence2 = HttpUtil.getCharsetAsSequence(charSequence)) != null) {
            if (charSequence2.length() > 2 && charSequence2.charAt(0) == '\"' && charSequence2.charAt(charSequence2.length() - 1) == '\"') {
                charSequence2 = charSequence2.subSequence(1, charSequence2.length() - 1);
            }
            try {
                return Charset.forName(charSequence2.toString());
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    @Deprecated
    public static CharSequence getCharsetAsString(HttpMessage httpMessage) {
        return HttpUtil.getCharsetAsSequence(httpMessage);
    }

    public static CharSequence getCharsetAsSequence(HttpMessage httpMessage) {
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getCharsetAsSequence(string);
        }
        return null;
    }

    public static CharSequence getCharsetAsSequence(CharSequence charSequence) {
        ObjectUtil.checkNotNull((Object)charSequence, (String)"contentTypeValue");
        int n = AsciiString.indexOfIgnoreCaseAscii((CharSequence)charSequence, (CharSequence)CHARSET_EQUALS, (int)0);
        if (n == -1) {
            return null;
        }
        int n2 = n + CHARSET_EQUALS.length();
        if (n2 < charSequence.length()) {
            CharSequence charSequence2 = charSequence.subSequence(n2, charSequence.length());
            int n3 = AsciiString.indexOfIgnoreCaseAscii((CharSequence)charSequence2, (CharSequence)SEMICOLON, (int)0);
            if (n3 == -1) {
                return charSequence2;
            }
            return charSequence2.subSequence(0, n3);
        }
        return null;
    }

    public static CharSequence getMimeType(HttpMessage httpMessage) {
        String string = httpMessage.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (string != null) {
            return HttpUtil.getMimeType(string);
        }
        return null;
    }

    public static CharSequence getMimeType(CharSequence charSequence) {
        ObjectUtil.checkNotNull((Object)charSequence, (String)"contentTypeValue");
        int n = AsciiString.indexOfIgnoreCaseAscii((CharSequence)charSequence, (CharSequence)SEMICOLON, (int)0);
        if (n != -1) {
            return charSequence.subSequence(0, n);
        }
        return charSequence.length() > 0 ? charSequence : null;
    }

    public static String formatHostnameForHttp(InetSocketAddress inetSocketAddress) {
        String string = NetUtil.getHostname((InetSocketAddress)inetSocketAddress);
        if (NetUtil.isValidIpV6Address((String)string)) {
            if (!inetSocketAddress.isUnresolved()) {
                string = NetUtil.toAddressString((InetAddress)inetSocketAddress.getAddress());
            } else if (string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
                return string;
            }
            return '[' + string + ']';
        }
        return string;
    }

    public static long normalizeAndGetContentLength(List<? extends CharSequence> list, boolean bl, boolean bl2) {
        boolean bl3;
        if (list.isEmpty()) {
            return -1L;
        }
        String string = list.get(0).toString();
        boolean bl4 = bl3 = list.size() > 1 || string.indexOf(44) >= 0;
        if (bl3 && !bl) {
            if (bl2) {
                String string2 = null;
                for (CharSequence charSequence : list) {
                    String[] stringArray;
                    for (String string3 : stringArray = charSequence.toString().split(COMMA_STRING, -1)) {
                        String string4 = string3.trim();
                        if (string2 == null) {
                            string2 = string4;
                            continue;
                        }
                        if (string4.equals(string2)) continue;
                        throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
                    }
                }
                string = string2;
            } else {
                throw new IllegalArgumentException("Multiple Content-Length values found: " + list);
            }
        }
        if (string.isEmpty() || !Character.isDigit(string.charAt(0))) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string);
        }
        try {
            long l = Long.parseLong(string);
            return ObjectUtil.checkPositiveOrZero((long)l, (String)"Content-Length value");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Content-Length value is not a number: " + string, numberFormatException);
        }
    }

    static int validateToken(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return HttpUtil.validateAsciiStringToken((AsciiString)charSequence);
        }
        return HttpUtil.validateCharSequenceToken(charSequence);
    }

    private static int validateAsciiStringToken(AsciiString asciiString) {
        byte[] byArray = asciiString.array();
        int n = asciiString.arrayOffset() + asciiString.length();
        for (int i = asciiString.arrayOffset(); i < n; ++i) {
            if (BitSet128.contains(byArray[i], TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i - asciiString.arrayOffset();
        }
        return -1;
    }

    private static int validateCharSequenceToken(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            byte by = (byte)charSequence.charAt(i);
            if (BitSet128.contains(by, TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i;
        }
        return -1;
    }

    static {
        BitSet128 bitSet128 = new BitSet128().range('0', '9').range('a', 'z').range('A', 'Z').bits('-', '.', '_', '~').bits('!', '#', '$', '%', '&', '\'', '*', '+', '^', '`', '|');
        TOKEN_CHARS_HIGH = bitSet128.high();
        TOKEN_CHARS_LOW = bitSet128.low();
    }

    private static final class BitSet128 {
        private long high;
        private long low;

        private BitSet128() {
        }

        BitSet128 range(char n, char c) {
            for (int i = n; i <= c; ++i) {
                if (i < 64) {
                    this.low |= 1L << i;
                    continue;
                }
                this.high |= 1L << i - 64;
            }
            return this;
        }

        BitSet128 bits(char ... cArray) {
            for (char c : cArray) {
                if (c < '@') {
                    this.low |= 1L << c;
                    continue;
                }
                this.high |= 1L << c - 64;
            }
            return this;
        }

        long high() {
            return this.high;
        }

        long low() {
            return this.low;
        }

        static boolean contains(byte by, long l, long l2) {
            if (by < 0) {
                return false;
            }
            if (by < 64) {
                return 0L != (l2 & 1L << by);
            }
            return 0L != (l & 1L << by - 64);
        }
    }
}

