/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final WebSocketServerProtocolConfig serverConfig;
    private ChannelHandlerContext ctx;
    private ChannelPromise handshakePromise;
    private boolean isWebSocketPath;

    WebSocketServerProtocolHandshakeHandler(WebSocketServerProtocolConfig webSocketServerProtocolConfig) {
        this.serverConfig = (WebSocketServerProtocolConfig)ObjectUtil.checkNotNull((Object)webSocketServerProtocolConfig, (String)"serverConfig");
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.handshakePromise = channelHandlerContext.newPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(final ChannelHandlerContext channelHandlerContext, Object object) {
        HttpObject httpObject = (HttpObject)object;
        if (httpObject instanceof HttpRequest) {
            final HttpRequest httpRequest = (HttpRequest)httpObject;
            this.isWebSocketPath = this.isWebSocketPath(httpRequest);
            if (!this.isWebSocketPath) {
                channelHandlerContext.fireChannelRead(object);
                return;
            }
            try {
                WebSocketServerHandshakerFactory webSocketServerHandshakerFactory = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(channelHandlerContext.pipeline(), httpRequest, this.serverConfig.websocketPath()), this.serverConfig.subprotocols(), this.serverConfig.decoderConfig());
                final WebSocketServerHandshaker webSocketServerHandshaker = webSocketServerHandshakerFactory.newHandshaker(httpRequest);
                final ChannelPromise channelPromise = this.handshakePromise;
                if (webSocketServerHandshaker == null) {
                    WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channelHandlerContext.channel());
                }
                WebSocketServerProtocolHandler.setHandshaker(channelHandlerContext.channel(), webSocketServerHandshaker);
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
                ChannelFuture channelFuture = webSocketServerHandshaker.handshake(channelHandlerContext.channel(), httpRequest);
                channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        if (!channelFuture.isSuccess()) {
                            channelPromise.tryFailure(channelFuture.cause());
                            channelHandlerContext.fireExceptionCaught(channelFuture.cause());
                        } else {
                            channelPromise.trySuccess();
                            channelHandlerContext.fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE);
                            channelHandlerContext.fireUserEventTriggered((Object)new WebSocketServerProtocolHandler.HandshakeComplete(httpRequest.uri(), httpRequest.headers(), webSocketServerHandshaker.selectedSubprotocol()));
                        }
                    }
                });
                this.applyHandshakeTimeout();
            }
            finally {
                ReferenceCountUtil.release((Object)httpRequest);
            }
        } else if (!this.isWebSocketPath) {
            channelHandlerContext.fireChannelRead(object);
        } else {
            ReferenceCountUtil.release((Object)object);
        }
    }

    private boolean isWebSocketPath(HttpRequest httpRequest) {
        String string = this.serverConfig.websocketPath();
        String string2 = httpRequest.uri();
        return this.serverConfig.checkStartsWith() ? string2.startsWith(string) && ("/".equals(string) || this.checkNextUri(string2, string)) : string2.equals(string);
    }

    private boolean checkNextUri(String string, String string2) {
        int n = string2.length();
        if (string.length() > n) {
            char c = string.charAt(n);
            return c == '/' || c == '?';
        }
        return true;
    }

    private static void sendHttpResponse(ChannelHandlerContext channelHandlerContext, HttpRequest httpRequest, HttpResponse httpResponse) {
        ChannelFuture channelFuture = channelHandlerContext.writeAndFlush((Object)httpResponse);
        if (!HttpUtil.isKeepAlive(httpRequest) || httpResponse.status().code() != 200) {
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline channelPipeline, HttpRequest httpRequest, String string) {
        String string2 = "ws";
        if (channelPipeline.get(SslHandler.class) != null) {
            string2 = "wss";
        }
        String string3 = httpRequest.headers().get((CharSequence)HttpHeaderNames.HOST);
        return string2 + "://" + string3 + string;
    }

    private void applyHandshakeTimeout() {
        final ChannelPromise channelPromise = this.handshakePromise;
        long l = this.serverConfig.handshakeTimeoutMillis();
        if (l <= 0L || channelPromise.isDone()) {
            return;
        }
        ScheduledFuture scheduledFuture = this.ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (!channelPromise.isDone() && channelPromise.tryFailure((Throwable)new WebSocketServerHandshakeException("handshake timed out"))) {
                    WebSocketServerProtocolHandshakeHandler.this.ctx.flush().fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT).close();
                }
            }
        }, l, TimeUnit.MILLISECONDS);
        channelPromise.addListener((GenericFutureListener)new FutureListener<Void>((Future)scheduledFuture){
            final /* synthetic */ Future val$timeoutFuture;
            {
                this.val$timeoutFuture = future;
            }

            public void operationComplete(Future<Void> future) {
                this.val$timeoutFuture.cancel(false);
            }
        });
    }
}

