/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class WebSocketExtensionUtil {
    private static final String EXTENSION_SEPARATOR = ",";
    private static final String PARAMETER_SEPARATOR = ";";
    private static final char PARAMETER_EQUAL = '=';
    private static final Pattern PARAMETER = Pattern.compile("^([^=]+)(=[\\\"]?([^\\\"]+)[\\\"]?)?$");

    static boolean isWebsocketUpgrade(HttpHeaders httpHeaders) {
        return httpHeaders.contains((CharSequence)HttpHeaderNames.UPGRADE) && httpHeaders.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && httpHeaders.contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }

    public static List<WebSocketExtensionData> extractExtensions(String string) {
        String[] stringArray = string.split(EXTENSION_SEPARATOR);
        if (stringArray.length > 0) {
            ArrayList<WebSocketExtensionData> arrayList = new ArrayList<WebSocketExtensionData>(stringArray.length);
            for (String string2 : stringArray) {
                Map<String, String> map;
                String[] stringArray2 = string2.split(PARAMETER_SEPARATOR);
                String string3 = stringArray2[0].trim();
                if (stringArray2.length > 1) {
                    map = new HashMap(stringArray2.length - 1);
                    for (int i = 1; i < stringArray2.length; ++i) {
                        String string4 = stringArray2[i].trim();
                        Matcher matcher = PARAMETER.matcher(string4);
                        if (!matcher.matches() || matcher.group(1) == null) continue;
                        map.put(matcher.group(1), matcher.group(3));
                    }
                } else {
                    map = Collections.emptyMap();
                }
                arrayList.add(new WebSocketExtensionData(string3, map));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    static String computeMergeExtensionsHeaderValue(String string, List<WebSocketExtensionData> list) {
        List<Object> list2 = string != null ? WebSocketExtensionUtil.extractExtensions(string) : Collections.emptyList();
        for (Object object : list2) {
            void object3;
            int n;
            Object var5_6 = null;
            for (n = 0; n < list.size(); ++n) {
                WebSocketExtensionData webSocketExtensionData = list.get(n);
                if (!webSocketExtensionData.name().equals(((WebSocketExtensionData)object).name())) continue;
                WebSocketExtensionData webSocketExtensionData2 = webSocketExtensionData;
                break;
            }
            if (object3 == null) {
                list.add((WebSocketExtensionData)object);
                continue;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(object3.parameters());
            hashMap.putAll(((WebSocketExtensionData)object).parameters());
            list.set(n, new WebSocketExtensionData(object3.name(), hashMap));
        }
        StringBuilder stringBuilder = new StringBuilder(150);
        for (WebSocketExtensionData webSocketExtensionData : list) {
            stringBuilder.append(webSocketExtensionData.name());
            for (Map.Entry<String, String> entry : webSocketExtensionData.parameters().entrySet()) {
                stringBuilder.append(PARAMETER_SEPARATOR);
                stringBuilder.append(entry.getKey());
                if (entry.getValue() == null) continue;
                stringBuilder.append('=');
                stringBuilder.append(entry.getValue());
            }
            stringBuilder.append(EXTENSION_SEPARATOR);
        }
        if (!list.isEmpty()) {
            stringBuilder.setLength(stringBuilder.length() - EXTENSION_SEPARATOR.length());
        }
        return stringBuilder.toString();
    }

    private WebSocketExtensionUtil() {
    }
}

