/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSsl;
import io.netty.internal.tcnative.CertificateVerifier;
import java.security.cert.CertificateException;

public final class OpenSslCertificateException
extends CertificateException {
    private static final long serialVersionUID = 5542675253797129798L;
    private final int errorCode;

    public OpenSslCertificateException(int n) {
        this((String)null, n);
    }

    public OpenSslCertificateException(String string, int n) {
        super(string);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n);
    }

    public OpenSslCertificateException(String string, Throwable throwable, int n) {
        super(string, throwable);
        this.errorCode = OpenSslCertificateException.checkErrorCode(n);
    }

    public OpenSslCertificateException(Throwable throwable, int n) {
        this(null, throwable, n);
    }

    public int errorCode() {
        return this.errorCode;
    }

    private static int checkErrorCode(int n) {
        if (OpenSsl.isAvailable() && !CertificateVerifier.isValid((int)n)) {
            throw new IllegalArgumentException("errorCode '" + n + "' invalid, see https://www.openssl.org/docs/man1.0.2/apps/verify.html.");
        }
        return n;
    }
}

