/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.X509KeyManagerWrapper;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public abstract class SimpleKeyManagerFactory
extends KeyManagerFactory {
    private static final Provider PROVIDER = new Provider("", 0.0, ""){
        private static final long serialVersionUID = -2680540247105807895L;
    };
    private static final FastThreadLocal<SimpleKeyManagerFactorySpi> CURRENT_SPI = new FastThreadLocal<SimpleKeyManagerFactorySpi>(){

        protected SimpleKeyManagerFactorySpi initialValue() {
            return new SimpleKeyManagerFactorySpi();
        }
    };

    protected SimpleKeyManagerFactory() {
        this("");
    }

    protected SimpleKeyManagerFactory(String string) {
        super((KeyManagerFactorySpi)CURRENT_SPI.get(), PROVIDER, (String)ObjectUtil.checkNotNull((Object)string, (String)"name"));
        ((SimpleKeyManagerFactorySpi)CURRENT_SPI.get()).init(this);
        CURRENT_SPI.remove();
    }

    protected abstract void engineInit(KeyStore var1, char[] var2);

    protected abstract void engineInit(ManagerFactoryParameters var1);

    protected abstract KeyManager[] engineGetKeyManagers();

    private static final class SimpleKeyManagerFactorySpi
    extends KeyManagerFactorySpi {
        private SimpleKeyManagerFactory parent;
        private volatile KeyManager[] keyManagers;

        private SimpleKeyManagerFactorySpi() {
        }

        void init(SimpleKeyManagerFactory simpleKeyManagerFactory) {
            this.parent = simpleKeyManagerFactory;
        }

        @Override
        protected void engineInit(KeyStore keyStore, char[] cArray) {
            try {
                this.parent.engineInit(keyStore, cArray);
            }
            catch (KeyStoreException keyStoreException) {
                throw keyStoreException;
            }
            catch (Exception exception) {
                throw new KeyStoreException(exception);
            }
        }

        @Override
        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            try {
                this.parent.engineInit(managerFactoryParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw invalidAlgorithmParameterException;
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception);
            }
        }

        @Override
        protected KeyManager[] engineGetKeyManagers() {
            KeyManager[] keyManagerArray = this.keyManagers;
            if (keyManagerArray == null) {
                keyManagerArray = this.parent.engineGetKeyManagers();
                if (PlatformDependent.javaVersion() >= 7) {
                    SimpleKeyManagerFactorySpi.wrapIfNeeded(keyManagerArray);
                }
                this.keyManagers = keyManagerArray;
            }
            return (KeyManager[])keyManagerArray.clone();
        }

        private static void wrapIfNeeded(KeyManager[] keyManagerArray) {
            for (int i = 0; i < keyManagerArray.length; ++i) {
                KeyManager keyManager = keyManagerArray[i];
                if (!(keyManager instanceof X509KeyManager) || keyManager instanceof X509ExtendedKeyManager) continue;
                keyManagerArray[i] = new X509KeyManagerWrapper((X509KeyManager)keyManager);
            }
        }
    }
}

