/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime;

import androidx.compose.runtime.SlotTableKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0086\u0002J\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ%\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0017H\u0082\bJ\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Landroidx/compose/runtime/BitVector;", "", "<init>", "()V", "first", "", "second", "others", "", "size", "", "getSize", "()I", "get", "", "index", "set", "", "value", "nextSet", "nextClear", "nextBit", "valueSelector", "Lkotlin/Function1;", "setRange", "start", "end", "toString", "", "runtime"})
public final class BitVector {
    private long first;
    private long second;
    private long[] others = SlotTableKt.access$getEmptyLongArray$p();
    public static final int $stable = 8;

    public final int getSize() {
        return (this.others.length + 2) * 64;
    }

    public final boolean get(int n) {
        if (n < 64) {
            return (this.first & 1L << n) != 0L;
        }
        if (n < 128) {
            return (this.second & 1L << n - 64) != 0L;
        }
        long[] lArray = this.others;
        int n2 = lArray.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = n / 64 - 2;
        if (n3 >= n2) {
            return false;
        }
        int n4 = n % 64;
        return (lArray[n3] & 1L << n4) != 0L;
    }

    public final void set(int n, boolean bl) {
        if (n < 64) {
            long l = 1L << n;
            boolean bl2 = bl;
            boolean bl3 = false;
            this.first = this.first & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(bl2 ? 1 : 0) << n;
            return;
        }
        if (n < 128) {
            long l = 1L << n - 64;
            boolean bl4 = bl;
            boolean bl5 = false;
            this.second = this.second & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(bl4 ? 1 : 0) << n;
            return;
        }
        int n2 = n / 64 - 2;
        int n3 = n % 64;
        long l = 1L << n3;
        long[] lArray = this.others;
        if (n2 >= lArray.length) {
            long[] lArray2 = Arrays.copyOf(lArray, n2 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"");
            this.others = lArray = lArray2;
        }
        long l2 = lArray[n2];
        boolean bl6 = bl;
        boolean bl7 = false;
        lArray[n2] = l2 & (l ^ 0xFFFFFFFFFFFFFFFFL) | (long)(bl6 ? 1 : 0) << n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int nextSet(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        long l;
        BitVector bitVector = this;
        boolean bl2 = false;
        if (n < 64) {
            l = bitVector.first;
            bl = false;
            long l2 = l >>> n << n;
            n6 = 0;
            n5 = Long.numberOfTrailingZeros(l2);
            if (n5 < 64) {
                n4 = n5;
                return n4;
            }
        }
        if (n < 128) {
            n5 = n - 64;
            l = bitVector.second;
            bl = false;
            long l3 = l >>> n5 << n5;
            n3 = 0;
            n2 = Long.numberOfTrailingZeros(l3);
            if (n2 < 64) {
                n4 = 64 + n2;
                return n4;
            }
        }
        n5 = Math.max(n, 128);
        n2 = n5 / 64 - 2;
        long[] lArray = bitVector.others;
        n6 = n2;
        n3 = lArray.length;
        while (n6 < n3) {
            int n7;
            l = lArray[n6];
            bl = false;
            long l4 = l;
            if (n6 == n2) {
                n7 = n5 % 64;
                l4 = l4 >>> n7 << n7;
            }
            long l5 = l4;
            boolean bl3 = false;
            n7 = Long.numberOfTrailingZeros(l5);
            if (n7 < 64) {
                n4 = 128 + n6 * 64 + n7;
                return n4;
            }
            ++n6;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int nextClear(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        long l;
        BitVector bitVector = this;
        boolean bl2 = false;
        if (n < 64) {
            l = bitVector.first;
            bl = false;
            long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) >>> n << n;
            n6 = 0;
            n5 = Long.numberOfTrailingZeros(l2);
            if (n5 < 64) {
                n4 = n5;
                return n4;
            }
        }
        if (n < 128) {
            n5 = n - 64;
            l = bitVector.second;
            bl = false;
            long l3 = (l ^ 0xFFFFFFFFFFFFFFFFL) >>> n5 << n5;
            n3 = 0;
            n2 = Long.numberOfTrailingZeros(l3);
            if (n2 < 64) {
                n4 = 64 + n2;
                return n4;
            }
        }
        n5 = Math.max(n, 128);
        n2 = n5 / 64 - 2;
        long[] lArray = bitVector.others;
        n6 = n2;
        n3 = lArray.length;
        while (n6 < n3) {
            int n7;
            l = lArray[n6];
            bl = false;
            long l4 = l ^ 0xFFFFFFFFFFFFFFFFL;
            if (n6 == n2) {
                n7 = n5 % 64;
                l4 = l4 >>> n7 << n7;
            }
            long l5 = l4;
            boolean bl3 = false;
            n7 = Long.numberOfTrailingZeros(l5);
            if (n7 < 64) {
                n4 = 128 + n6 * 64 + n7;
                return n4;
            }
            ++n6;
        }
        return Integer.MAX_VALUE;
    }

    private final int nextBit(int n, Function1<? super Long, Long> function1) {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        if (n < 64) {
            long l = ((Number)function1.invoke((Object)this.first)).longValue() >>> n << n;
            n4 = 0;
            n3 = Long.numberOfTrailingZeros(l);
            if (n3 < 64) {
                return n3;
            }
        }
        if (n < 128) {
            n3 = n - 64;
            long l = ((Number)function1.invoke((Object)this.second)).longValue() >>> n3 << n3;
            n2 = 0;
            int n5 = Long.numberOfTrailingZeros(l);
            if (n5 < 64) {
                return 64 + n5;
            }
        }
        n3 = Math.max(n, 128);
        int n6 = n3 / 64 - 2;
        long[] lArray = this.others;
        n2 = lArray.length;
        for (n4 = n6; n4 < n2; ++n4) {
            int n7;
            long l = ((Number)function1.invoke((Object)lArray[n4])).longValue();
            if (n4 == n6) {
                n7 = n3 % 64;
                l = l >>> n7 << n7;
            }
            long l2 = l;
            boolean bl2 = false;
            n7 = Long.numberOfTrailingZeros(l2);
            if (n7 >= 64) continue;
            return 128 + n4 * 64 + n7;
        }
        return Integer.MAX_VALUE;
    }

    public final void setRange(int n, int n2) {
        int n3 = n;
        long l = n3 < n2 ? -1L : 0L;
        boolean bl = n3 < 64;
        boolean bl2 = false;
        long l2 = l * (long)(bl ? 1 : 0);
        long l3 = l2 >>> 64 - (Math.min(64, n2) - n3) << n3;
        this.first |= l3;
        if (n2 <= 64) {
            return;
        }
        n3 = Math.max(n3, 64);
        boolean bl3 = n3 < 128;
        boolean bl4 = false;
        l2 = l * (long)(bl3 ? 1 : 0);
        long l4 = l2 >>> 128 - (Math.min(128, n2) - n3) << n3;
        this.second |= l4;
        if (n2 <= 128) {
            return;
        }
        n3 = Math.max(n3, 128);
        for (int i = n3; i < n2; ++i) {
            this.set(i, true);
        }
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = true;
        stringBuilder2.append("BitVector [");
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            if (!bl2) {
                stringBuilder2.append(", ");
            }
            bl2 = false;
            stringBuilder2.append(i);
        }
        stringBuilder2.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }
}

