/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor;

import dorkbox.executor.DeferredProcessResult;
import dorkbox.executor.Executor;
import dorkbox.executor.JvmExecOptions;
import dorkbox.executor.LogHelper;
import dorkbox.executor.Params;
import dorkbox.executor.ProcessAttributes;
import dorkbox.executor.SshExecOptions;
import dorkbox.executor.exceptions.ProcessInitException;
import dorkbox.executor.listener.CompositeProcessListener;
import dorkbox.executor.listener.DestroyerListenerAdapter;
import dorkbox.executor.listener.ProcessDestroyer;
import dorkbox.executor.listener.ProcessListener;
import dorkbox.executor.listener.ShutdownHookProcessDestroyer;
import dorkbox.executor.processResults.ProcessResult;
import dorkbox.executor.processResults.SyncProcessResult;
import dorkbox.executor.stop.DestroyProcessStopper;
import dorkbox.executor.stop.NopProcessStopper;
import dorkbox.executor.stop.ProcessStopper;
import dorkbox.executor.stream.CallerLoggerUtil;
import dorkbox.executor.stream.IOStreamHandler;
import dorkbox.executor.stream.NopPumpStreamHandler;
import dorkbox.executor.stream.nopStreams.NopInputStream;
import dorkbox.executor.stream.nopStreams.NopOutputStream;
import dorkbox.executor.stream.slf4j.Slf4jStream;
import dorkbox.updates.Updates;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.J;
import kotlinx.coroutines.Z;
import kotlinx.coroutines.i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 \u0088\u00012\u00020\u0001:\u0002\u0088\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001f\u00102\u001a\u00020\u00002\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u00104J\u0014\u00102\u001a\u00020\u00002\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u001f\u0010;\u001a\u00020\u00002\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u00104J\u000e\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020?J\u0014\u0010=\u001a\u00020$2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0005H\u0007J\u0006\u0010@\u001a\u00020-J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0017J'\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020?2\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010IJ\u001f\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u00104J\u0014\u0010\u0003\u001a\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0005J\u0006\u0010L\u001a\u00020\u0000J\u0006\u0010M\u001a\u00020\u0000J\u0010\u00106\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u000107J\u0006\u0010N\u001a\u00020\u0000J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010O\u001a\u00020\u00052\b\u0010P\u001a\u0004\u0018\u00010\u0005J\u001c\u0010\u0018\u001a\u00020\u00002\u0014\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050RJ\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020?J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0005J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u000bJ\u0006\u0010V\u001a\u00020\u0000J\u0006\u0010W\u001a\u00020\u0000J\u0012\u0010X\u001a\u00020\u00002\n\u0010X\u001a\u00020Y\"\u00020\u000bJ\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00050[J\u000e\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00050[H\u0016J\u0006\u0010]\u001a\u00020\u0005J\u0006\u0010^\u001a\u00020\u0005J\b\u0010_\u001a\u0004\u0018\u00010?J\u0006\u0010!\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0000J\u0010\u00109\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:J \u0010`\u001a\u00020a2\u0006\u0010F\u001a\u00020\u00152\u0006\u0010b\u001a\u00020\u00172\u0006\u0010c\u001a\u00020\u001dH\u0002J\u0010\u0010d\u001a\u00020\u00002\b\u0010e\u001a\u0004\u0018\u00010fJ\u000e\u0010g\u001a\u00020\u00002\u0006\u0010e\u001a\u00020fJ\u0006\u0010h\u001a\u00020\u0000J\u000e\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010j\u001a\u00020\u0000J\u000e\u0010j\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010k\u001a\u00020\u0000J\u000e\u0010k\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010l\u001a\u00020\u0000J\u000e\u0010l\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010m\u001a\u00020\u0000J\u000e\u0010m\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u000e\u0010n\u001a\u00020\u00002\u0006\u0010n\u001a\u00020\u001dJ\u0010\u0010o\u001a\u00020\u00002\b\u0010p\u001a\u0004\u0018\u00010qJ\u0014\u0010r\u001a\u00020\u00002\n\b\u0002\u0010e\u001a\u0004\u0018\u00010fH\u0007J\u000e\u0010s\u001a\u00020\u00002\u0006\u0010e\u001a\u00020fJ\u0006\u0010t\u001a\u00020\u0000J\u000e\u0010t\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010u\u001a\u00020\u0000J\u000e\u0010u\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010v\u001a\u00020\u0000J\u000e\u0010v\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010w\u001a\u00020\u0000J\u000e\u0010w\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u0006\u0010x\u001a\u00020\u0000J\u000e\u0010x\u001a\u00020\u00002\u0006\u0010i\u001a\u00020(J\u000e\u0010y\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u0016\u0010z\u001a\u00020\u00002\u000e\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0|J%\u0010}\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u007fJ&\u0010\u0080\u0001\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u007fJ\u001d\u0010\u0081\u0001\u001a\u00020a2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u001d\u0010\u0082\u0001\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u001d\u0010\u0083\u0001\u001a\u00020a2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u001d\u0010\u0084\u0001\u001a\u00020~2\b\b\u0002\u0010F\u001a\u00020\u00152\b\b\u0002\u0010b\u001a\u00020\u0017H\u0007J\u0010\u0010.\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u00100\u001a\u000201J\u000e\u00100\u001a\u00020\u00002\u0006\u00100\u001a\u000201J\u0007\u0010\u0085\u0001\u001a\u00020\u0000J\u0012\u0010\u0086\u0001\u001a\u00020\u00002\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010?J\u0012\u0010\u0086\u0001\u001a\u00020\u00002\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u0005R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0089\u0001"}, d2={"Ldorkbox/executor/Executor;", "", "()V", "command", "", "", "(Ljava/lang/Iterable;)V", "", "([Ljava/lang/String;)V", "allowedExitValues", "", "", "attributes", "Ldorkbox/executor/ProcessAttributes;", "getAttributes", "()Ldorkbox/executor/ProcessAttributes;", "builder", "Ljava/lang/ProcessBuilder;", "getBuilder$Executor", "()Ljava/lang/ProcessBuilder;", "closeTimeout", "", "closeTimeoutUnit", "Ljava/util/concurrent/TimeUnit;", "environment", "", "getEnvironment", "()Ljava/util/Map;", "executeAsShell", "", "executingMessageParams", "getExecutingMessageParams", "()Ljava/lang/String;", "highPerformanceIO", "inheritIO", "jvmExecOptions", "Ldorkbox/executor/JvmExecOptions;", "listeners", "Ldorkbox/executor/listener/CompositeProcessListener;", "logger", "Lorg/slf4j/Logger;", "pathsToPrepend", "", "readOutput", "sshExecOptions", "Ldorkbox/executor/SshExecOptions;", "stopper", "Ldorkbox/executor/stop/ProcessStopper;", "streams", "Ldorkbox/executor/stream/IOStreamHandler;", "addArg", "arguments", "([Ljava/lang/String;)Ldorkbox/executor/Executor;", "addDestroyer", "destroyer", "Ldorkbox/executor/listener/ProcessDestroyer;", "addListener", "listener", "Ldorkbox/executor/listener/ProcessListener;", "addPath", "pathsToAdd", "asJvmProcess", "javaExecutable", "Ljava/io/File;", "asSshProcess", "checkExitValue", "", "result", "Ldorkbox/executor/processResults/ProcessResult;", "clearListeners", "timeout", "unit", "args", "(Ljava/io/File;[Ljava/lang/String;)Ldorkbox/executor/Executor;", "commandSplit", "commandWithArgs", "defaultLogger", "destroyOnExit", "enableRead", "name", "value", "env", "", "executable", "exe", "exitValue", "exitValueAny", "exitValueNormal", "exitValues", "", "getArgs", "", "getCommand", "getExecutable", "getSystemPath", "getWorkingDirectory", "prepareProcess", "Ldorkbox/executor/DeferredProcessResult;", "timeoutUnit", "asyncProcessStart", "redirectError", "output", "Ljava/io/OutputStream;", "redirectErrorAlsoTo", "redirectErrorAsDebug", "log", "redirectErrorAsError", "redirectErrorAsInfo", "redirectErrorAsTrace", "redirectErrorAsWarn", "redirectErrorStream", "redirectInput", "input", "Ljava/io/InputStream;", "redirectOutput", "redirectOutputAlsoTo", "redirectOutputAsDebug", "redirectOutputAsError", "redirectOutputAsInfo", "redirectOutputAsTrace", "redirectOutputAsWarn", "removeListener", "removeListeners", "listenerType", "Ljava/lang/Class;", "start", "Ldorkbox/executor/processResults/SyncProcessResult;", "(JLjava/util/concurrent/TimeUnit;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startAsShell", "startAsShellAsync", "startAsShellBlocking", "startAsync", "startBlocking", "useSystemEnvironment", "workingDirectory", "directory", "Companion", "Executor"})
public class Executor {
    public static final Companion Companion = new Companion(null);
    private final ProcessBuilder builder;
    private final Map<String, String> environment;
    private JvmExecOptions jvmExecOptions;
    private SshExecOptions sshExecOptions;
    private boolean executeAsShell;
    private List<String> pathsToPrepend;
    private Set<Integer> allowedExitValues;
    private ProcessStopper stopper;
    private IOStreamHandler streams;
    private long closeTimeout;
    private TimeUnit closeTimeoutUnit;
    private boolean readOutput;
    private boolean inheritIO;
    private boolean highPerformanceIO;
    private final CompositeProcessListener listeners;
    private Logger logger;
    public static final String version = "3.14";
    private static final Logger log;
    private static final boolean IS_OS_WINDOWS;
    private static final boolean IS_OS_MAC;
    private static final int NORMAL_EXIT_VALUE = 0;
    public static final boolean DEFAULT_REDIRECT_ERROR_STREAM = true;
    private static final CoroutineScope IO_DISPATCH;
    private static final String LINE_SEPARATOR;
    private static final Regex EXTRA_SPACE_REGEX;
    private static String DEFAULT_SHELL;

    public final ProcessBuilder getBuilder$Executor() {
        return this.builder;
    }

    public final Map<String, String> getEnvironment() {
        return this.environment;
    }

    private final ProcessAttributes getAttributes() {
        Set<Integer> set = this.allowedExitValues;
        return set != null ? new ProcessAttributes(this.getCommand(), this.getWorkingDirectory(), (Map<String, String>)new LinkedHashMap<String, String>(this.environment), CollectionsKt.toSet((Iterable)set)) : new ProcessAttributes(this.getCommand(), this.getWorkingDirectory(), new LinkedHashMap<String, String>(this.environment), null, 8, null);
    }

    private final String getExecutingMessageParams() {
        List<String> list = this.builder.command();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        String string2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        if (this.builder.directory() != null) {
            string2 = string2 + " in " + this.builder.directory();
        }
        if (!this.environment.isEmpty()) {
            string2 = string2 + " with environment " + this.environment;
        }
        return string2;
    }

    public Executor() {
        this.builder = new ProcessBuilder(new String[0]);
        this.environment = new LinkedHashMap();
        this.pathsToPrepend = new ArrayList();
        this.stopper = NopProcessStopper.Companion.getINSTANCE();
        this.streams = new NopPumpStreamHandler();
        this.closeTimeoutUnit = TimeUnit.SECONDS;
        this.listeners = new CompositeProcessListener();
        this.exitValueAny();
        this.stopper(DestroyProcessStopper.Companion.getINSTANCE());
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
    }

    public Executor(Iterable<String> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        this.builder = new ProcessBuilder(new String[0]);
        this.environment = new LinkedHashMap();
        this.pathsToPrepend = new ArrayList();
        this.stopper = NopProcessStopper.Companion.getINSTANCE();
        this.streams = new NopPumpStreamHandler();
        this.closeTimeoutUnit = TimeUnit.SECONDS;
        this.listeners = new CompositeProcessListener();
        this.exitValueAny();
        this.stopper(DestroyProcessStopper.Companion.getINSTANCE());
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(iterable);
    }

    public Executor(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.builder = new ProcessBuilder(new String[0]);
        this.environment = new LinkedHashMap();
        this.pathsToPrepend = new ArrayList();
        this.stopper = NopProcessStopper.Companion.getINSTANCE();
        this.streams = new NopPumpStreamHandler();
        this.closeTimeoutUnit = TimeUnit.SECONDS;
        this.listeners = new CompositeProcessListener();
        this.exitValueAny();
        this.stopper(DestroyProcessStopper.Companion.getINSTANCE());
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(Arrays.copyOf(stringArray, stringArray.length));
    }

    public List<String> getCommand() {
        return new ArrayList(this.builder.command());
    }

    public final Executor command(Iterable<String> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        Iterable<String> iterable2 = iterable;
        boolean bl = false;
        Iterable<String> iterable3 = iterable2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable2, (int)10));
        boolean bl2 = false;
        Iterator<String> iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = string2 = iterator.next();
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(string3);
        }
        List list = (List)collection;
        this.builder.command().addAll((Collection<String>)Companion.fixArguments$Executor(list));
        return this;
    }

    public final Executor command(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.builder.command().addAll((Collection<String>)Companion.fixArguments$Executor(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length))));
        return this;
    }

    public final Executor command(File file, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)file.getAbsolutePath());
        spreadBuilder.addSpread((Object)stringArray);
        List list = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        this.builder.command().addAll((Collection<String>)Companion.fixArguments$Executor(list));
        return this;
    }

    public final Executor commandSplit(String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        CharSequence charSequence = string2;
        Regex regex = EXTRA_SPACE_REGEX;
        int n = 0;
        this.builder.command().addAll(regex.split(charSequence, n));
        return this;
    }

    public final Executor executable(String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.builder.command().add(0, string2);
        return this;
    }

    public final Executor executable(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        this.builder.command().add(0, file.getAbsolutePath());
        return this;
    }

    public final String getExecutable() {
        List<String> list = this.builder.command();
        if (list.isEmpty()) {
            return "";
        }
        String string2 = list.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    public final Executor addArg(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        List<String> list = Companion.fixArguments$Executor(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
        this.builder.command().addAll((Collection<String>)list);
        return this;
    }

    public final Executor addArg(Iterable<String> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"");
        List<String> list = Companion.fixArguments$Executor(iterable);
        this.builder.command().addAll((Collection<String>)list);
        return this;
    }

    public final List<String> getArgs() {
        List<String> list = this.builder.command();
        return list.size() <= 1 ? CollectionsKt.emptyList() : list.subList(1, list.size());
    }

    public final File getWorkingDirectory() {
        return this.builder.directory();
    }

    public final Executor workingDirectory(File file) {
        this.builder.directory(file);
        return this;
    }

    public final Executor workingDirectory(String string2) {
        if (string2 != null) {
            this.builder.directory(new File(string2));
        } else {
            this.builder.directory((File)((Object)string2));
        }
        return this;
    }

    public final Executor environment(Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"");
        this.environment.putAll(map);
        return this;
    }

    public final Executor environment(String string2, String string3) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"");
        this.environment.put(string2, string3);
        return this;
    }

    public final Executor useSystemEnvironment() {
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"");
        this.environment.putAll(map);
        return this;
    }

    public final Executor addPath(String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        CollectionsKt.addAll((Collection)this.pathsToPrepend, (Object[])stringArray);
        this.executeAsShell = true;
        return this;
    }

    public final String getSystemPath() {
        Map<String, String> map = System.getenv();
        String string2 = map.get("PATH");
        if (string2 == null && (string2 = map.get("Path")) == null && (string2 = map.get("path")) == null) {
            string2 = "";
        }
        return string2;
    }

    public final Executor redirectErrorStream(boolean bl) {
        this.builder.redirectErrorStream(bl);
        return this;
    }

    public final Executor exitValueAny() {
        this.allowedExitValues = null;
        return this;
    }

    public final Executor exitValueNormal() {
        int[] nArray = new int[]{0};
        return this.exitValues(nArray);
    }

    public final Executor exitValue(int n) {
        int[] nArray = new int[]{n};
        return this.exitValues(nArray);
    }

    public final Executor exitValues(int ... nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
        this.allowedExitValues = ArraysKt.toSet((int[])nArray);
        return this;
    }

    public final Executor stopper(ProcessStopper processStopper) {
        this.stopper = processStopper == null ? NopProcessStopper.Companion.getINSTANCE() : processStopper;
        return this;
    }

    public final IOStreamHandler streams() {
        return this.streams;
    }

    public final Executor streams(IOStreamHandler iOStreamHandler) {
        Intrinsics.checkNotNullParameter((Object)iOStreamHandler, (String)"");
        this.streams = iOStreamHandler;
        return this;
    }

    public final Executor closeTimeout(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        this.closeTimeout = l;
        this.closeTimeoutUnit = timeUnit;
        return this;
    }

    public final Executor enableRead() {
        this.readOutput = true;
        return this;
    }

    public final Executor inheritIO() {
        this.inheritIO = true;
        return this;
    }

    public final Executor redirectInput(InputStream inputStream) {
        InputStream inputStream2 = inputStream == null ? (InputStream)NopInputStream.Companion.getINPUT_STREAM() : inputStream;
        this.streams = this.streams.setInputStream(inputStream2);
        return this;
    }

    public final Executor redirectOutput(OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        if (outputStream2 == null) {
            outputStream2 = NopOutputStream.Companion.getOUTPUT_STREAM();
        }
        this.streams = this.streams.setOutputStream(outputStream2);
        return this;
    }

    public static /* synthetic */ Executor redirectOutput$default(Executor executor, OutputStream outputStream, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: redirectOutput");
        }
        if ((n & 1) != 0) {
            outputStream = null;
        }
        return executor.redirectOutput(outputStream);
    }

    public final Executor redirectError(OutputStream outputStream) {
        OutputStream outputStream2 = outputStream;
        if (outputStream2 == null) {
            outputStream2 = NopOutputStream.Companion.getOUTPUT_STREAM();
        }
        this.streams = this.streams.setErrorStream(outputStream2);
        this.redirectErrorStream(false);
        return this;
    }

    public final Executor redirectOutputAlsoTo(OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"");
        this.streams = this.streams.teeOutputStream(outputStream);
        return this;
    }

    public final Executor redirectErrorAlsoTo(OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"");
        this.streams = this.streams.teeErrorStream(outputStream);
        this.redirectErrorStream(false);
        return this;
    }

    public final Executor redirectOutputAsTrace() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsDebug() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsInfo() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectOutputAsWarn() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectOutputAsError() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsTrace(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsDebug(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectOutputAsInfo(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectOutputAsWarn(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectOutputAsError(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectOutput(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectErrorAsTrace() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asTrace(logger));
    }

    public final Executor redirectErrorAsDebug() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectErrorAsInfo() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectErrorAsWarn() {
        Logger logger = LoggerFactory.getLogger((String)CallerLoggerUtil.INSTANCE.getName(null, 1));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectErrorAsError() {
        return this.redirectError(Slf4jStream.INSTANCE.asError(log));
    }

    public final Executor redirectErrorAsTrace(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asTrace(logger));
    }

    public final Executor redirectErrorAsDebug(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asDebug(logger));
    }

    public final Executor redirectErrorAsInfo(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asInfo(logger));
    }

    public final Executor redirectErrorAsWarn(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asWarn(logger));
    }

    public final Executor redirectErrorAsError(Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"");
        return this.redirectError(Slf4jStream.INSTANCE.asError(logger));
    }

    public final Executor addDestroyer(ProcessDestroyer processDestroyer) {
        Intrinsics.checkNotNullParameter((Object)processDestroyer, (String)"");
        return this.addListener(new DestroyerListenerAdapter(processDestroyer));
    }

    public final Executor destroyer(ProcessDestroyer processDestroyer) {
        this.removeListeners(DestroyerListenerAdapter.class);
        if (processDestroyer != null) {
            this.addListener(new DestroyerListenerAdapter(processDestroyer));
        }
        return this;
    }

    public final Executor destroyOnExit() {
        return this.destroyer(ShutdownHookProcessDestroyer.Companion.getINSTANCE());
    }

    public final Executor listener(ProcessListener processListener) {
        block0: {
            this.clearListeners();
            ProcessListener processListener2 = processListener;
            if (processListener2 == null) break block0;
            ProcessListener processListener3 = processListener2;
            boolean bl = false;
            this.addListener(processListener3);
        }
        return this;
    }

    public final Executor addListener(ProcessListener processListener) {
        Intrinsics.checkNotNullParameter((Object)processListener, (String)"");
        this.listeners.add(processListener);
        return this;
    }

    public final Executor removeListener(ProcessListener processListener) {
        Intrinsics.checkNotNullParameter((Object)processListener, (String)"");
        this.listeners.remove(processListener);
        return this;
    }

    public final Executor removeListeners(Class<? extends ProcessListener> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        this.listeners.removeAll(clazz);
        return this;
    }

    public final Executor clearListeners() {
        this.listeners.clear();
        return this;
    }

    public final void checkExitValue(ProcessResult processResult) {
        Intrinsics.checkNotNullParameter((Object)processResult, (String)"");
        DeferredProcessResult.Companion.checkExit$Executor(this.getAttributes(), processResult);
    }

    public final Executor defaultLogger() {
        this.logger = log;
        return this;
    }

    public final Executor highPerformanceIO() {
        this.highPerformanceIO = true;
        return this;
    }

    public final JvmExecOptions asJvmProcess(String string2) {
        JvmExecOptions jvmExecOptions = this.jvmExecOptions = new JvmExecOptions(this, string2);
        Intrinsics.checkNotNull((Object)jvmExecOptions);
        return jvmExecOptions;
    }

    public static /* synthetic */ JvmExecOptions asJvmProcess$default(Executor executor, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asJvmProcess");
        }
        if ((n & 1) != 0) {
            string2 = null;
        }
        return executor.asJvmProcess(string2);
    }

    public final JvmExecOptions asJvmProcess(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        if (!file.canExecute()) {
            throw new IllegalArgumentException("The java executable if specified, must be exist and be executable. Error with: " + file);
        }
        JvmExecOptions jvmExecOptions = this.jvmExecOptions = new JvmExecOptions(this, file.getCanonicalFile().getPath());
        Intrinsics.checkNotNull((Object)jvmExecOptions);
        return jvmExecOptions;
    }

    public final SshExecOptions asSshProcess() {
        SshExecOptions sshExecOptions = this.sshExecOptions = new SshExecOptions(this);
        Intrinsics.checkNotNull((Object)sshExecOptions);
        return sshExecOptions;
    }

    public final DeferredProcessResult startAsShellAsync(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        this.executeAsShell = true;
        return this.startAsync(l, timeUnit);
    }

    public static /* synthetic */ DeferredProcessResult startAsShellAsync$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsShellAsync");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsShellAsync(l, timeUnit);
    }

    public final DeferredProcessResult startAsync(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        return this.prepareProcess(l, timeUnit, true);
    }

    public static /* synthetic */ DeferredProcessResult startAsync$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsync");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsync(l, timeUnit);
    }

    public final Object startAsShell(long l, TimeUnit timeUnit, Continuation<? super SyncProcessResult> continuation) {
        this.executeAsShell = true;
        return this.start(l, timeUnit, continuation);
    }

    public static /* synthetic */ Object startAsShell$default(Executor executor, long l, TimeUnit timeUnit, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsShell");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsShell(l, timeUnit, (Continuation<? super SyncProcessResult>)continuation);
    }

    public final SyncProcessResult startAsShellBlocking(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        return (SyncProcessResult)i.a(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SyncProcessResult>, Object>(this, l, timeUnit, null){
            int label;
            final /* synthetic */ Executor this$0;
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $timeoutUnit;
            {
                this.this$0 = executor;
                this.$timeout = l;
                this.$timeoutUnit = timeUnit;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.startAsShell(this.$timeout, this.$timeoutUnit, (Continuation<? super SyncProcessResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = object;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super SyncProcessResult> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ SyncProcessResult startAsShellBlocking$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startAsShellBlocking");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startAsShellBlocking(l, timeUnit);
    }

    public final Object start(long l, TimeUnit timeUnit, Continuation<? super SyncProcessResult> continuation) {
        return this.prepareProcess(l, timeUnit, false).await(l, timeUnit, continuation);
    }

    public static /* synthetic */ Object start$default(Executor executor, long l, TimeUnit timeUnit, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.start(l, timeUnit, (Continuation<? super SyncProcessResult>)continuation);
    }

    public final SyncProcessResult startBlocking(long l, TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"");
        return (SyncProcessResult)i.a(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SyncProcessResult>, Object>(this, l, timeUnit, null){
            int label;
            final /* synthetic */ Executor this$0;
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $timeoutUnit;
            {
                this.this$0 = executor;
                this.$timeout = l;
                this.$timeoutUnit = timeUnit;
                super(2, continuation);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.start(this.$timeout, this.$timeoutUnit, (Continuation<? super SyncProcessResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = object;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object object, Continuation<?> continuation) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope coroutineScope, Continuation<? super SyncProcessResult> continuation) {
                return (this.create(coroutineScope, continuation)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ SyncProcessResult startBlocking$default(Executor executor, long l, TimeUnit timeUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startBlocking");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        return executor.startBlocking(l, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DeferredProcessResult prepareProcess(long l, TimeUnit timeUnit, boolean bl) {
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        boolean bl2;
        Map<String, String> map;
        String string2;
        String string3;
        boolean bl3;
        if (!(!this.inheritIO || !this.highPerformanceIO)) {
            boolean bl4 = false;
            String string4 = "inheritIO & highPerformanceIO cannot be both set at the same time, they cancel each-other out";
            throw new IllegalStateException(string4.toString());
        }
        this.listeners.beforeStart(this);
        List<String> list = this.builder.command();
        if (this.jvmExecOptions == null) {
            Intrinsics.checkNotNull(list);
            if (!(!((Collection)list).isEmpty())) {
                boolean bl5 = false;
                String string5 = "Command has not been set.";
                throw new IllegalStateException(string5.toString());
            }
        }
        boolean bl6 = bl3 = !((Collection)this.pathsToPrepend).isEmpty();
        if (bl3) {
            Iterable iterable = this.pathsToPrepend;
            String string6 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"");
            string3 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string6, null, null, (int)0, null, null, (int)62, null);
        } else {
            string3 = string2 = "";
        }
        if (!this.environment.isEmpty() || bl3) {
            map = System.getenv();
            boolean bl7 = map.get("PATH") != null;
            bl2 = map.get("Path") != null;
            n = map.get("path") != null ? 1 : 0;
            Object object6 = bl7 ? "PATH" : (object5 = bl2 ? "Path" : "path");
            if (bl7 || bl2 || n != 0) {
                String string7;
                String string8;
                Object object7;
                Object object8 = this.environment.remove("PATH");
                if (object8 == null) {
                    object8 = object4 = "";
                }
                if ((object7 = this.environment.remove("Path")) == null) {
                    object7 = object3 = "";
                }
                if ((string8 = this.environment.remove("path")) == null) {
                    string8 = string7 = "";
                }
                if (((CharSequence)object4).length() > 0 || ((CharSequence)object3).length() > 0 || ((CharSequence)string7).length() > 0) {
                    object2 = "";
                    if (((CharSequence)object4).length() > 0) {
                        object2 = (String)object2 + (String)object4;
                    }
                    if (((CharSequence)object3).length() > 0) {
                        if (((CharSequence)object2).length() > 0) {
                            object2 = (String)object2 + File.pathSeparator;
                        }
                        object2 = (String)object2 + (String)object3;
                    }
                    if (((CharSequence)string7).length() > 0) {
                        if (((CharSequence)object2).length() > 0) {
                            object2 = (String)object2 + File.pathSeparator;
                        }
                        object2 = (String)object2 + string7;
                    }
                    if (bl3) {
                        object2 = string2 + File.pathSeparator + (String)object2;
                    }
                    this.environment.put((String)object5, (String)object2);
                } else {
                    this.environment.put((String)object5, string2);
                }
            } else if (bl3) {
                this.environment.put((String)object5, string2);
            }
            object4 = this.builder.environment();
            object3 = this.environment;
            boolean bl8 = false;
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = object2.next();
                boolean bl9 = false;
                objectArray = entry2.getKey();
                String string9 = entry2.getValue();
                if (string9 == null) {
                    object4.remove(objectArray);
                    continue;
                }
                Intrinsics.checkNotNull((Object)object4);
                object4.put(objectArray, string9);
            }
        }
        if (this.jvmExecOptions != null) {
            JvmExecOptions jvmExecOptions = this.jvmExecOptions;
            Intrinsics.checkNotNull((Object)jvmExecOptions);
            map = jvmExecOptions;
            ((JvmExecOptions)((Object)map)).configure$Executor();
        }
        if (this.executeAsShell) {
            Object[] objectArray2;
            Intrinsics.checkNotNull(list);
            map = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            list.clear();
            if (IS_OS_WINDOWS) {
                objectArray2 = new String[]{"cmd", "/c"};
                list.addAll(CollectionsKt.listOf((Object[])objectArray2));
            } else {
                String string10;
                if (DEFAULT_SHELL == null && (string10 = System.getenv().get("SHELL")) != null && new File(string10).canExecute()) {
                    DEFAULT_SHELL = string10;
                }
                if (DEFAULT_SHELL == null) {
                    try {
                        Object object9 = new String[]{"sh", "-c", "echo $SHELL"};
                        object9 = Runtime.getRuntime().exec((String[])object9).getInputStream();
                        Throwable throwable = null;
                        try {
                            object5 = (InputStream)object9;
                            boolean bl10 = false;
                            object3 = new Scanner((InputStream)object5).useDelimiter("\\A");
                            Throwable throwable2 = null;
                            try {
                                String string11;
                                object2 = (Scanner)object3;
                                boolean bl11 = false;
                                if (((Scanner)object2).hasNext()) {
                                    String string12 = ((Scanner)object2).next();
                                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"");
                                    string11 = ((Object)StringsKt.trim((CharSequence)string12)).toString();
                                } else {
                                    string11 = null;
                                }
                                object2 = string11;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable2);
                            }
                            object5 = object2;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object9, (Throwable)throwable);
                        }
                        Object object10 = object5;
                        if (object10 != null && !StringsKt.isBlank((CharSequence)((CharSequence)object10)) && new File((String)object10).canExecute()) {
                            DEFAULT_SHELL = object10;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (DEFAULT_SHELL == null) {
                    String[] stringArray = new String[]{"/bin/bash", "/usr/bin/bash", "/bin/pfbash", "/usr/bin/pfbash", "/bin/csh", "/usr/bin/csh", "/bin/pfcsh", "/usr/bin/pfcsh", "/bin/jsh", "/usr/bin/jsh", "/bin/ksh", "/usr/bin/ksh", "/bin/pfksh", "/usr/bin/pfksh", "/bin/ksh93", "/usr/bin/ksh93", "/bin/pfksh93", "/usr/bin/pfksh93", "/bin/pfsh", "/usr/bin/pfsh", "/bin/tcsh", "/usr/bin/tcsh", "/bin/pftcsh", "/usr/bin/pftcsh", "/usr/xpg4/bin/sh", "/usr/xp4/bin/pfsh", "/bin/zsh", "/usr/bin/zsh", "/bin/pfzsh", "/usr/bin/pfzsh", "/bin/sh", "/usr/bin/sh"};
                    bl2 = false;
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        object3 = object4 = stringArray[n];
                        boolean bl12 = false;
                        if (!new File((String)object3).canExecute()) continue;
                        DEFAULT_SHELL = object3;
                    }
                }
                if (DEFAULT_SHELL == null) {
                    throw new IllegalStateException("Unable to determine the default shell for the linux/unix environment.");
                }
                objectArray2 = new String[2];
                Intrinsics.checkNotNull((Object)DEFAULT_SHELL);
                objectArray2[1] = "-c";
                list.addAll(CollectionsKt.listOf((Object[])objectArray2));
            }
            list.add((String)((Object)map));
            if (IS_OS_MAC && !this.environment.containsKey("SOFTWARE")) {
                this.environment.put("SOFTWARE", "");
            }
            if (!this.environment.containsKey("LANG")) {
                this.environment.put("LANG", "C");
            }
        }
        if (this.inheritIO) {
            this.builder.inheritIO();
        }
        map = this.getAttributes();
        CompositeProcessListener compositeProcessListener = this.listeners.clone();
        if (!this.readOutput && this.executeAsShell && this.streams.getOut$Executor() instanceof NopOutputStream) {
            if (IS_OS_WINDOWS) {
                list.add("2>&1>");
                list.add("nul");
            } else {
                list.add(">/dev/null");
                list.add("2>&1");
            }
        }
        try {
            Process process;
            object = l > 0L ? "(timeout: " + l + ' ' + (Object)((Object)timeUnit) + ") " : "";
            Object object11 = object5 = this.executeAsShell ? "Executing as shell " + (String)object : "Executing " + (String)object;
            if (this.sshExecOptions != null) {
                StringBuilder stringBuilder = new StringBuilder().append((String)object5).append(" on ");
                SshExecOptions sshExecOptions = this.sshExecOptions;
                Intrinsics.checkNotNull((Object)sshExecOptions);
                LogHelper.INSTANCE.logAtLowestLevel(this.logger, stringBuilder.append(sshExecOptions.info()).append(' ').append(this.getExecutingMessageParams()).toString(), new Object[0]);
                SshExecOptions sshExecOptions2 = this.sshExecOptions;
                Intrinsics.checkNotNull((Object)sshExecOptions2);
                process = sshExecOptions2.startProcess$Executor(l, timeUnit, this.logger);
            } else {
                LogHelper.INSTANCE.logAtLowestLevel(this.logger, (String)object5 + ' ' + this.getExecutingMessageParams(), new Object[0]);
                process = this.builder.start();
            }
            object = process;
        }
        catch (Exception exception) {
            String string13;
            if (this.sshExecOptions != null) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not execute on ");
                SshExecOptions sshExecOptions = this.sshExecOptions;
                Intrinsics.checkNotNull((Object)sshExecOptions);
                string13 = stringBuilder.append(sshExecOptions.info()).append(' ').append(this.getExecutingMessageParams()).toString();
            } else {
                string13 = "Could not execute " + this.getExecutingMessageParams();
            }
            object4 = string13;
            ProcessInitException processInitException = ProcessInitException.Companion.newInstance((String)object4, exception);
            throw processInitException != null ? (Throwable)processInitException : (Throwable)new IOException((String)object4, exception);
        }
        Object object12 = object;
        object = null;
        object5 = null;
        object4 = null;
        if (!this.readOutput) {
            object = this.streams;
            object5 = prepareProcess.5.INSTANCE;
            object4 = (Function1)new Function1<StringBuilder, Unit>((ProcessAttributes)((Object)map)){
                final /* synthetic */ ProcessAttributes $attributes;
                {
                    this.$attributes = processAttributes;
                    super(1);
                }

                public final void invoke(StringBuilder stringBuilder) {
                    Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
                    DeferredProcessResult.Companion.addExceptionMessageSuffix$Executor(this.$attributes, stringBuilder, "");
                }
            };
        } else {
            object = this.streams;
            if (bl) {
                object = ((IOStreamHandler)object).asyncMode();
            }
            object3 = new ByteArrayOutputStream();
            object = ((IOStreamHandler)object).teeOutputStream((OutputStream)object3);
            object5 = (Function2)new Function2<Long, Integer, SyncProcessResult>((ByteArrayOutputStream)object3){
                final /* synthetic */ ByteArrayOutputStream $out;
                {
                    this.$out = byteArrayOutputStream;
                    super(2);
                }

                public final SyncProcessResult invoke(long l, int n) {
                    byte[] byArray = this.$out.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
                    return new SyncProcessResult(l, n, byArray);
                }

                public /* synthetic */ Object invoke(Object object, Object object2) {
                    return this.invoke(((Number)object).longValue(), ((Number)object2).intValue());
                }
            };
            object4 = (Function1)new Function1<StringBuilder, Unit>((ByteArrayOutputStream)object3, (ProcessAttributes)((Object)map)){
                final /* synthetic */ ByteArrayOutputStream $out;
                final /* synthetic */ ProcessAttributes $attributes;
                {
                    this.$out = byteArrayOutputStream;
                    this.$attributes = processAttributes;
                    super(1);
                }

                public final void invoke(StringBuilder stringBuilder) {
                    Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"");
                    byte[] byArray = this.$out.toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"");
                    SyncProcessResult syncProcessResult = new SyncProcessResult(0L, 0, byArray);
                    DeferredProcessResult.Companion.addExceptionMessageSuffix$Executor(this.$attributes, stringBuilder, syncProcessResult.getOutput().string());
                }
            };
        }
        boolean bl13 = !this.builder.redirectErrorStream();
        Intrinsics.checkNotNull((Object)object12);
        ((IOStreamHandler)object).start((Process)object12, bl13, this.highPerformanceIO);
        compositeProcessListener.afterStart((Process)object12, this);
        Logger logger = this.logger;
        object2 = new Params((ProcessAttributes)((Object)map), this.stopper, compositeProcessListener, (IOStreamHandler)object, logger, (Function1<? super StringBuilder, Unit>)object4, this.closeTimeout, this.closeTimeoutUnit, bl);
        DeferredProcessResult deferredProcessResult = new DeferredProcessResult((Process)object12, (Params)object2, (Function2<? super Long, ? super Integer, ? extends SyncProcessResult>)object5);
        long l2 = deferredProcessResult.getPid();
        if (l2 == -1L) {
            LogHelper.INSTANCE.logAtLowestLevel(logger, "Started process", new Object[0]);
        } else {
            objectArray = new Object[]{l2};
            LogHelper.INSTANCE.logAtLowestLevel(logger, "Started process [pid={}]", objectArray);
        }
        deferredProcessResult.start();
        return deferredProcessResult;
    }

    public final Executor redirectOutput() {
        return Executor.redirectOutput$default(this, null, 1, null);
    }

    public final JvmExecOptions asJvmProcess() {
        return Executor.asJvmProcess$default(this, null, 1, null);
    }

    public final DeferredProcessResult startAsShellAsync(long l) {
        return Executor.startAsShellAsync$default(this, l, null, 2, null);
    }

    public final DeferredProcessResult startAsShellAsync() {
        return Executor.startAsShellAsync$default(this, 0L, null, 3, null);
    }

    public final DeferredProcessResult startAsync(long l) {
        return Executor.startAsync$default(this, l, null, 2, null);
    }

    public final DeferredProcessResult startAsync() {
        return Executor.startAsync$default(this, 0L, null, 3, null);
    }

    public final Object startAsShell(long l, Continuation<? super SyncProcessResult> continuation) {
        return Executor.startAsShell$default(this, l, null, continuation, 2, null);
    }

    public final Object startAsShell(Continuation<? super SyncProcessResult> continuation) {
        return Executor.startAsShell$default(this, 0L, null, continuation, 3, null);
    }

    public final SyncProcessResult startAsShellBlocking(long l) {
        return Executor.startAsShellBlocking$default(this, l, null, 2, null);
    }

    public final SyncProcessResult startAsShellBlocking() {
        return Executor.startAsShellBlocking$default(this, 0L, null, 3, null);
    }

    public final Object start(long l, Continuation<? super SyncProcessResult> continuation) {
        return Executor.start$default(this, l, null, continuation, 2, null);
    }

    public final Object start(Continuation<? super SyncProcessResult> continuation) {
        return Executor.start$default(this, 0L, null, continuation, 3, null);
    }

    public final SyncProcessResult startBlocking(long l) {
        return Executor.startBlocking$default(this, l, null, 2, null);
    }

    public final SyncProcessResult startBlocking() {
        return Executor.startBlocking$default(this, 0L, null, 3, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Executor.class);
        Intrinsics.checkNotNull((Object)logger);
        log = logger;
        IO_DISPATCH = J.a((CoroutineContext)((CoroutineContext)Z.d()));
        LINE_SEPARATOR = System.getProperty("line.separator");
        EXTRA_SPACE_REGEX = new Regex("\\s+");
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        String string4 = string3;
        IS_OS_WINDOWS = StringsKt.startsWith$default((String)string4, (String)"win", (boolean)false, (int)2, null);
        IS_OS_MAC = StringsKt.startsWith$default((String)string4, (String)"mac", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string4, (String)"darwin", (boolean)false, (int)2, null);
        Updates.INSTANCE.add(Executor.class, "03fcf3762a2b4f68b5e968aaf79f3a72", version);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ'\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\"\"\u00020\u0006\u00a2\u0006\u0002\u0010#J\u001c\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cJ\u001f\u0010\u001e\u001a\u00020\u00062\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\"\"\u00020\u0006\u00a2\u0006\u0002\u0010$J\u0014\u0010\u001e\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldorkbox/executor/Executor$Companion;", "", "()V", "DEFAULT_REDIRECT_ERROR_STREAM", "", "DEFAULT_SHELL", "", "EXTRA_SPACE_REGEX", "Lkotlin/text/Regex;", "IO_DISPATCH", "Lkotlinx/coroutines/CoroutineScope;", "getIO_DISPATCH$Executor", "()Lkotlinx/coroutines/CoroutineScope;", "IS_OS_MAC", "getIS_OS_MAC", "()Z", "IS_OS_WINDOWS", "getIS_OS_WINDOWS", "LINE_SEPARATOR", "kotlin.jvm.PlatformType", "NORMAL_EXIT_VALUE", "", "log", "Lorg/slf4j/Logger;", "version", "fixArguments", "", "command", "", "fixArguments$Executor", "run", "executable", "Ljava/io/File;", "args", "", "(Ljava/io/File;[Ljava/lang/String;)Ljava/lang/String;", "([Ljava/lang/String;)Ljava/lang/String;", "Executor"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getIS_OS_WINDOWS() {
            return IS_OS_WINDOWS;
        }

        public final boolean getIS_OS_MAC() {
            return IS_OS_MAC;
        }

        public final CoroutineScope getIO_DISPATCH$Executor() {
            return IO_DISPATCH;
        }

        public final List<String> fixArguments$Executor(Iterable<String> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"");
            if (!this.getIS_OS_WINDOWS()) {
                return CollectionsKt.toMutableList(iterable);
            }
            Object object = new ArrayList();
            List list = object;
            boolean bl = false;
            CollectionsKt.addAll((Collection)list, iterable);
            List list2 = object;
            object = list2.listIterator();
            while (object.hasNext()) {
                if (!Intrinsics.areEqual((Object)"", object.next())) continue;
                object.set("\"\"");
            }
            return list2;
        }

        public final String run(Iterable<String> iterable) {
            Intrinsics.checkNotNullParameter(iterable, (String)"");
            return Executor.startBlocking$default(new Executor().command(iterable).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public final String run(File file, Iterable<String> iterable) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"");
            Intrinsics.checkNotNullParameter(iterable, (String)"");
            return Executor.startBlocking$default(new Executor().executable(file).command(iterable).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public final String run(String ... stringArray) {
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
            return Executor.startBlocking$default(new Executor().command(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length))).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public final String run(File file, String ... stringArray) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"");
            Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
            return Executor.startBlocking$default(new Executor().executable(file).command(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length))).enableRead(), 0L, null, 3, null).getOutput().utf8();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

