/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.Interval;
import androidx.compose.ui.graphics.IntervalTreeKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\f\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001*B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011J6\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u0015J:\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u00152\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u0015J9\u0010\u0017\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0004\u0012\u00020\f0\u0019H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u001aJ=\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0004\u0012\u00020\f0\u0019H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u001aJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0086\u0002J\u0017\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0086\u0002J\u0015\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\u001fH\u0086\u0002J\u0017\u0010 \u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0086\u0002J%\u0010!\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010#J\u001a\u0010$\u001a\u00020\f2\u0010\u0010%\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u001a\u0010&\u001a\u00020\f2\u0010\u0010'\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u001a\u0010(\u001a\u00020\f2\u0010\u0010'\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002J\u001a\u0010)\u001a\u00020\f2\u0010\u0010'\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0002R\u001a\u0010\u0005\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u00008\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u00008\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\b\u001a&\u0012\u000e\u0012\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u00000\tj\u0012\u0012\u000e\u0012\f0\u0006R\b\u0012\u0004\u0012\u00028\u00000\u0000`\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"Landroidx/compose/ui/graphics/IntervalTree;", "T", "", "<init>", "()V", "terminator", "Landroidx/compose/ui/graphics/IntervalTree$Node;", "root", "stack", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "clear", "", "findFirstOverlap", "Landroidx/compose/ui/graphics/Interval;", "interval", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "start", "end", "findOverlaps", "", "results", "forEach", "block", "Lkotlin/Function1;", "forEach$ui_graphics", "contains", "", "value", "iterator", "", "plusAssign", "addInterval", "data", "(FFLjava/lang/Object;)V", "rebalance", "target", "rotateLeft", "node", "rotateRight", "updateNodeData", "Node", "ui-graphics"})
public final class IntervalTree<T> {
    public final Node terminator;
    public Node root;
    public final ArrayList<Node> stack;

    public IntervalTree() {
        this.root = this.terminator = new Node(Float.MAX_VALUE, Float.MIN_VALUE, null, 1);
        this.stack = new ArrayList();
    }

    public final void clear() {
        this.root = this.terminator;
    }

    public final Interval<T> findFirstOverlap(ClosedFloatingPointRange<Float> closedFloatingPointRange) {
        Intrinsics.checkNotNullParameter(closedFloatingPointRange, (String)"");
        return this.findFirstOverlap(((Number)((Object)closedFloatingPointRange.getStart())).floatValue(), ((Number)((Object)closedFloatingPointRange.getEndInclusive())).floatValue());
    }

    public final Interval<T> findFirstOverlap(float f, float f2) {
        if (this.root != this.terminator) {
            IntervalTree intervalTree = this;
            boolean bl = false;
            if (intervalTree.root != intervalTree.terminator) {
                ArrayList<Node> arrayList = intervalTree.stack;
                arrayList.add(intervalTree.root);
                while (arrayList.size() > 0) {
                    Node node;
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList.remove(arrayList.size() - 1), (String)"");
                    if (node.overlaps(f, f2)) {
                        Interval interval = node;
                        boolean bl2 = false;
                        return interval;
                    }
                    if (node.getLeft() != intervalTree.terminator && node.getLeft().getMax() >= f) {
                        arrayList.add(node.getLeft());
                    }
                    if (node.getRight() == intervalTree.terminator || !(node.getRight().getMin() <= f2)) continue;
                    arrayList.add(node.getRight());
                }
                arrayList.clear();
            }
        }
        Interval<Object> interval = IntervalTreeKt.getEmptyInterval();
        Intrinsics.checkNotNull(interval);
        return interval;
    }

    public static /* synthetic */ Interval findFirstOverlap$default(IntervalTree intervalTree, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        return intervalTree.findFirstOverlap(f, f2);
    }

    public final List<Interval<T>> findOverlaps(ClosedFloatingPointRange<Float> closedFloatingPointRange, List<Interval<T>> list) {
        Intrinsics.checkNotNullParameter(closedFloatingPointRange, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        return this.findOverlaps(((Number)((Object)closedFloatingPointRange.getStart())).floatValue(), ((Number)((Object)closedFloatingPointRange.getEndInclusive())).floatValue(), list);
    }

    public static /* synthetic */ List findOverlaps$default(IntervalTree intervalTree, ClosedFloatingPointRange closedFloatingPointRange, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        return intervalTree.findOverlaps((ClosedFloatingPointRange<Float>)closedFloatingPointRange, list);
    }

    public final List<Interval<T>> findOverlaps(float f, float f2, List<Interval<T>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        IntervalTree intervalTree = this;
        boolean bl = false;
        if (intervalTree.root != intervalTree.terminator) {
            ArrayList<Node> arrayList = intervalTree.stack;
            arrayList.add(intervalTree.root);
            while (arrayList.size() > 0) {
                Node node;
                Intrinsics.checkNotNullExpressionValue((Object)arrayList.remove(arrayList.size() - 1), (String)"");
                if (node.overlaps(f, f2)) {
                    Interval interval = node;
                    boolean bl2 = false;
                    list.add(interval);
                }
                if (node.getLeft() != intervalTree.terminator && node.getLeft().getMax() >= f) {
                    arrayList.add(node.getLeft());
                }
                if (node.getRight() == intervalTree.terminator || !(node.getRight().getMin() <= f2)) continue;
                arrayList.add(node.getRight());
            }
            arrayList.clear();
        }
        return list;
    }

    public static /* synthetic */ List findOverlaps$default(IntervalTree intervalTree, float f, float f2, List list, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        return intervalTree.findOverlaps(f, f2, list);
    }

    public final void forEach$ui_graphics(ClosedFloatingPointRange<Float> closedFloatingPointRange, Function1<? super Interval<T>, Unit> function1) {
        Intrinsics.checkNotNullParameter(closedFloatingPointRange, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        boolean bl = false;
        IntervalTree intervalTree = this;
        float f = ((Number)((Object)closedFloatingPointRange.getStart())).floatValue();
        float f2 = ((Number)((Object)closedFloatingPointRange.getEndInclusive())).floatValue();
        boolean bl2 = false;
        if (intervalTree.root != intervalTree.terminator) {
            ArrayList<Node> arrayList = intervalTree.stack;
            arrayList.add(intervalTree.root);
            while (arrayList.size() > 0) {
                Node node;
                Intrinsics.checkNotNullExpressionValue((Object)arrayList.remove(arrayList.size() - 1), (String)"");
                if (node.overlaps(f, f2)) {
                    function1.invoke((Object)node);
                }
                if (node.getLeft() != intervalTree.terminator && node.getLeft().getMax() >= f) {
                    arrayList.add(node.getLeft());
                }
                if (node.getRight() == intervalTree.terminator || !(node.getRight().getMin() <= f2)) continue;
                arrayList.add(node.getRight());
            }
            arrayList.clear();
        }
    }

    public final void forEach$ui_graphics(float f, float f2, Function1<? super Interval<T>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        boolean bl = false;
        if (this.root != this.terminator) {
            ArrayList<Node> arrayList = this.stack;
            arrayList.add(this.root);
            while (arrayList.size() > 0) {
                Node node;
                Intrinsics.checkNotNullExpressionValue((Object)arrayList.remove(arrayList.size() - 1), (String)"");
                if (node.overlaps(f, f2)) {
                    function1.invoke((Object)node);
                }
                if (node.getLeft() != this.terminator && node.getLeft().getMax() >= f) {
                    arrayList.add(node.getLeft());
                }
                if (node.getRight() == this.terminator || !(node.getRight().getMin() <= f2)) continue;
                arrayList.add(node.getRight());
            }
            arrayList.clear();
        }
    }

    public static /* synthetic */ void forEach$ui_graphics$default(IntervalTree intervalTree, float f, float f2, Function1 function1, int n, Object arrayList) {
        if ((n & 2) != 0) {
            f2 = f;
        }
        Intrinsics.checkNotNullParameter((Object)function1, (String)"");
        n = 0;
        if (intervalTree.root != intervalTree.terminator) {
            arrayList = intervalTree.stack;
            arrayList.add(intervalTree.root);
            while (arrayList.size() > 0) {
                Node node;
                Intrinsics.checkNotNullExpressionValue((Object)arrayList.remove(arrayList.size() - 1), (String)"");
                if (node.overlaps(f, f2)) {
                    function1.invoke((Object)node);
                }
                if (node.getLeft() != intervalTree.terminator && node.getLeft().getMax() >= f) {
                    arrayList.add(node.getLeft());
                }
                if (node.getRight() == intervalTree.terminator || !(node.getRight().getMin() <= f2)) continue;
                arrayList.add(node.getRight());
            }
            arrayList.clear();
        }
    }

    public final boolean contains(float f) {
        return this.findFirstOverlap(f, f) != IntervalTreeKt.getEmptyInterval();
    }

    public final boolean contains(ClosedFloatingPointRange<Float> closedFloatingPointRange) {
        Intrinsics.checkNotNullParameter(closedFloatingPointRange, (String)"");
        return this.findFirstOverlap(((Number)((Object)closedFloatingPointRange.getStart())).floatValue(), ((Number)((Object)closedFloatingPointRange.getEndInclusive())).floatValue()) != IntervalTreeKt.getEmptyInterval();
    }

    public final Iterator<Interval<T>> iterator() {
        return new Iterator<Interval<T>>(this){
            private Node _next;
            final /* synthetic */ IntervalTree<T> this$0;
            {
                this.this$0 = intervalTree;
                this._next = intervalTree.root.lowestNode();
            }

            public boolean hasNext() {
                return this._next != this.this$0.terminator;
            }

            public Interval<T> next() {
                Node node = this._next;
                this._next = this._next.next();
                return node;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public final void plusAssign(Interval<T> interval) {
        Intrinsics.checkNotNullParameter(interval, (String)"");
        this.addInterval(interval.getStart(), interval.getEnd(), interval.getData());
    }

    public final void addInterval(float f, float f2, T t) {
        Node node = new Node(f, f2, t, 0);
        Node node2 = this.root;
        Node node3 = this.terminator;
        while (node2 != this.terminator) {
            node3 = node2;
            node2 = node.getStart() <= node2.getStart() ? node2.getLeft() : node2.getRight();
        }
        node.setParent(node3);
        if (node3 == this.terminator) {
            this.root = node;
        } else if (node.getStart() <= node3.getStart()) {
            node3.setLeft(node);
        } else {
            node3.setRight(node);
        }
        this.updateNodeData(node);
        this.rebalance(node);
    }

    private final void rebalance(Node node) {
        Node node2 = node;
        while (node2 != this.root && node2.getParent().getColor() == 0) {
            Node node3;
            Node node4 = node2.getParent().getParent();
            if (node2.getParent() == node4.getLeft()) {
                node3 = node4.getRight();
                if (node3.getColor() == 0) {
                    node3.setColor(1);
                    node2.getParent().setColor(1);
                    node4.setColor(0);
                    node2 = node4;
                    continue;
                }
                if (node2 == node2.getParent().getRight()) {
                    node2 = node2.getParent();
                    this.rotateLeft(node2);
                }
                node2.getParent().setColor(1);
                node4.setColor(0);
                this.rotateRight(node4);
                continue;
            }
            node3 = node4.getLeft();
            if (node3.getColor() == 0) {
                node3.setColor(1);
                node2.getParent().setColor(1);
                node4.setColor(0);
                node2 = node4;
                continue;
            }
            if (node2 == node2.getParent().getLeft()) {
                node2 = node2.getParent();
                this.rotateRight(node2);
            }
            node2.getParent().setColor(1);
            node4.setColor(0);
            this.rotateLeft(node4);
        }
        this.root.setColor(1);
    }

    private final void rotateLeft(Node node) {
        Node node2 = node.getRight();
        node.setRight(node2.getLeft());
        if (node2.getLeft() != this.terminator) {
            node2.getLeft().setParent(node);
        }
        node2.setParent(node.getParent());
        if (node.getParent() == this.terminator) {
            this.root = node2;
        } else if (node.getParent().getLeft() == node) {
            node.getParent().setLeft(node2);
        } else {
            node.getParent().setRight(node2);
        }
        node2.setLeft(node);
        node.setParent(node2);
        this.updateNodeData(node);
    }

    private final void rotateRight(Node node) {
        Node node2 = node.getLeft();
        node.setLeft(node2.getRight());
        if (node2.getRight() != this.terminator) {
            node2.getRight().setParent(node);
        }
        node2.setParent(node.getParent());
        if (node.getParent() == this.terminator) {
            this.root = node2;
        } else if (node.getParent().getRight() == node) {
            node.getParent().setRight(node2);
        } else {
            node.getParent().setLeft(node2);
        }
        node2.setRight(node);
        node.setParent(node2);
        this.updateNodeData(node);
    }

    private final void updateNodeData(Node node) {
        for (Node node2 = node; node2 != this.terminator; node2 = node2.getParent()) {
            node2.setMin(Math.min(node2.getStart(), Math.min(node2.getLeft().getMin(), node2.getRight().getMin())));
            node2.setMax(Math.max(node2.getEnd(), Math.max(node2.getLeft().getMax(), node2.getRight().getMax())));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\r\b\u0080\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010#\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0010\u0010$\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018R\u001e\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR$\u0010 \u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001c\u00a8\u0006%"}, d2={"Landroidx/compose/ui/graphics/IntervalTree$Node;", "Landroidx/compose/ui/graphics/Interval;", "start", "", "end", "data", "color", "", "Landroidx/compose/ui/graphics/TreeColor;", "<init>", "(Landroidx/compose/ui/graphics/IntervalTree;FFLjava/lang/Object;I)V", "getColor", "()I", "setColor", "(I)V", "min", "getMin", "()F", "setMin", "(F)V", "max", "getMax", "setMax", "left", "Landroidx/compose/ui/graphics/IntervalTree;", "getLeft", "()Landroidx/compose/ui/graphics/IntervalTree$Node;", "setLeft", "(Landroidx/compose/ui/graphics/IntervalTree$Node;)V", "right", "getRight", "setRight", "parent", "getParent", "setParent", "lowestNode", "next", "ui-graphics"})
    public final class Node
    extends Interval<T> {
        private int color;
        private float min;
        private float max;
        private Node left;
        private Node right;
        private Node parent;

        public Node(float f, float f2, T t, int n) {
            super(f, f2, t);
            this.color = n;
            this.min = f;
            this.max = f2;
            this.left = IntervalTree.this.terminator;
            this.right = IntervalTree.this.terminator;
            this.parent = IntervalTree.this.terminator;
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final float getMin() {
            return this.min;
        }

        public final void setMin(float f) {
            this.min = f;
        }

        public final float getMax() {
            return this.max;
        }

        public final void setMax(float f) {
            this.max = f;
        }

        public final Node getLeft() {
            return this.left;
        }

        public final void setLeft(Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"");
            this.left = node;
        }

        public final Node getRight() {
            return this.right;
        }

        public final void setRight(Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"");
            this.right = node;
        }

        public final Node getParent() {
            return this.parent;
        }

        public final void setParent(Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"");
            this.parent = node;
        }

        public final Node lowestNode() {
            Node node = this;
            while (node.left != IntervalTree.this.terminator) {
                node = node.left;
            }
            return node;
        }

        public final Node next() {
            if (this.right != IntervalTree.this.terminator) {
                return this.right.lowestNode();
            }
            Node node = this;
            Node node2 = this.parent;
            while (node2 != IntervalTree.this.terminator && node == node2.right) {
                node = node2;
                node2 = node2.parent;
            }
            return node2;
        }
    }
}

