/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.vector.FastFloatParserKt;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathNodeKt;
import androidx.compose.ui.graphics.vector.PathParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ8\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007J\u0011\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0082\bJ\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/compose/ui/graphics/vector/PathParser;", "", "<init>", "()V", "nodes", "Ljava/util/ArrayList;", "Landroidx/compose/ui/graphics/vector/PathNode;", "Lkotlin/collections/ArrayList;", "nodeData", "", "clear", "", "parsePathString", "pathData", "", "pathStringToNodes", "resizeNodeData", "dataCount", "", "addPathNodes", "", "toNodes", "toPath", "Landroidx/compose/ui/graphics/Path;", "target", "ui-graphics"})
public final class PathParser {
    private ArrayList<PathNode> nodes;
    private float[] nodeData = new float[64];

    public final void clear() {
        block0: {
            ArrayList<PathNode> arrayList = this.nodes;
            if (arrayList == null) break block0;
            arrayList.clear();
        }
    }

    public final PathParser parsePathString(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        ArrayList<PathNode> arrayList = this.nodes;
        if (arrayList == null) {
            this.nodes = arrayList = new ArrayList();
        } else {
            arrayList.clear();
        }
        this.pathStringToNodes(string, arrayList);
        return this;
    }

    public final ArrayList<PathNode> pathStringToNodes(String string, ArrayList<PathNode> arrayList) {
        int n;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter(arrayList, (String)"");
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2 && Intrinsics.compare((int)string.charAt(n), (int)32) <= 0; ++n) {
        }
        while (n2 > n && Intrinsics.compare((int)string.charAt(n2 - 1), (int)32) <= 0) {
            --n2;
        }
        int n4 = n;
        while (n4 < n2) {
            char c = '\u0000';
            char c2 = '\u0000';
            do {
                int n5;
                if (((n5 = (c = string.charAt(n4++)) | 0x20) - 97) * (n5 - 122) > 0 || n5 == 101) continue;
                c2 = c;
                break;
            } while (n4 < n2);
            if (c2 == '\u0000') continue;
            if ((c2 | 0x20) != 122) {
                n3 = 0;
                while (true) {
                    long l;
                    if (n4 < n2 && Intrinsics.compare((int)string.charAt(n4), (int)32) <= 0) {
                        ++n4;
                        continue;
                    }
                    long l2 = l = FastFloatParserKt.nextFloat(string, n4, n2);
                    boolean bl = false;
                    n4 = (int)(l2 >>> 32);
                    long l3 = l;
                    boolean bl2 = false;
                    int n6 = (int)(l3 & 0xFFFFFFFFL);
                    boolean bl3 = false;
                    float f = Float.intBitsToFloat(n6);
                    if (!Float.isNaN(f)) {
                        this.nodeData[n3++] = f;
                        PathParser pathParser = this;
                        bl = false;
                        if (n3 >= pathParser.nodeData.length) {
                            float[] fArray = pathParser.nodeData;
                            pathParser.nodeData = new float[n3 * 2];
                            ArraysKt.copyInto((float[])fArray, (float[])pathParser.nodeData, (int)0, (int)0, (int)fArray.length);
                        }
                    }
                    while (n4 < n2 && string.charAt(n4) == ',') {
                        ++n4;
                    }
                    if (n4 >= n2 || Float.isNaN(f)) break;
                }
            }
            PathNodeKt.addPathNodes(c2, arrayList, this.nodeData, n3);
        }
        return arrayList;
    }

    public static /* synthetic */ ArrayList pathStringToNodes$default(PathParser pathParser, String string, ArrayList arrayList, int n, Object object) {
        if ((n & 2) != 0) {
            arrayList = new ArrayList<PathNode>();
        }
        return pathParser.pathStringToNodes(string, arrayList);
    }

    private final void resizeNodeData(int n) {
        boolean bl = false;
        if (n >= this.nodeData.length) {
            float[] fArray = this.nodeData;
            this.nodeData = new float[n * 2];
            ArraysKt.copyInto((float[])fArray, (float[])this.nodeData, (int)0, (int)0, (int)fArray.length);
        }
    }

    public final PathParser addPathNodes(List<? extends PathNode> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        ArrayList<PathNode> arrayList = this.nodes;
        if (arrayList == null) {
            this.nodes = arrayList = new ArrayList();
        }
        arrayList.addAll((Collection<PathNode>)list);
        return this;
    }

    public final List<PathNode> toNodes() {
        ArrayList<PathNode> arrayList = this.nodes;
        return arrayList != null ? (List)arrayList : CollectionsKt.emptyList();
    }

    public final Path toPath(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        ArrayList<PathNode> arrayList = this.nodes;
        if (arrayList == null || (arrayList = PathParserKt.toPath((List<? extends PathNode>)arrayList, path)) == null) {
            arrayList = SkiaBackedPath_skikoKt.Path();
        }
        return arrayList;
    }

    public static /* synthetic */ Path toPath$default(PathParser pathParser, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = SkiaBackedPath_skikoKt.Path();
        }
        return pathParser.toPath(path);
    }
}

