/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKindExtractor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class FunctionTypesKt {
    public static final FunctionTypeKind getFunctionTypeKind(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? FunctionTypesKt.getFunctionTypeKind(classifierDescriptor) : null;
    }

    public static final boolean isFunctionType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return Intrinsics.areEqual((Object)FunctionTypesKt.getFunctionTypeKind(kotlinType), (Object)FunctionTypeKind.Function.INSTANCE);
    }

    public static final boolean isSuspendFunctionType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return Intrinsics.areEqual((Object)FunctionTypesKt.getFunctionTypeKind(kotlinType), (Object)FunctionTypeKind.SuspendFunction.INSTANCE);
    }

    public static final boolean isBuiltinFunctionalType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? FunctionTypesKt.isBuiltinFunctionalClassDescriptor(classifierDescriptor) : false;
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        FunctionTypeKind functionTypeKind = FunctionTypesKt.getFunctionTypeKind(declarationDescriptor);
        return Intrinsics.areEqual((Object)functionTypeKind, (Object)FunctionTypeKind.Function.INSTANCE) || Intrinsics.areEqual((Object)functionTypeKind, (Object)FunctionTypeKind.SuspendFunction.INSTANCE);
    }

    public static final boolean isBuiltinExtensionFunctionalType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return FunctionTypesKt.isBuiltinFunctionalType(kotlinType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType(kotlinType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType kotlinType) {
        return kotlinType.getAnnotations().findAnnotation(StandardNames.FqNames.extensionFunctionType) != null;
    }

    public static final FunctionTypeKind getFunctionTypeKind(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage(declarationDescriptor)) {
            return null;
        }
        return FunctionTypesKt.getFunctionTypeKind(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor));
    }

    private static final FunctionTypeKind getFunctionTypeKind(FqNameUnsafe fqNameUnsafe) {
        if (!fqNameUnsafe.isSafe() || fqNameUnsafe.isRoot()) {
            return null;
        }
        FunctionTypeKindExtractor functionTypeKindExtractor = FunctionTypeKindExtractor.Companion.getDefault();
        FqName fqName = fqNameUnsafe.toSafe().parent();
        String string = fqNameUnsafe.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return functionTypeKindExtractor.getFunctionalClassKind(fqName, string);
    }

    public static final int contextFunctionTypeParamsCount(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        AnnotationDescriptor annotationDescriptor = kotlinType.getAnnotations().findAnnotation(StandardNames.FqNames.contextFunctionTypeParams);
        if (annotationDescriptor == null) {
            return 0;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        ConstantValue constantValue = (ConstantValue)MapsKt.getValue(annotationDescriptor2.getAllValueArguments(), (Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        Intrinsics.checkNotNull((Object)constantValue);
        return ((Number)((IntValue)constantValue).getValue()).intValue();
    }

    public static final KotlinType getReceiverTypeFromFunctionType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        int n = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        if (_Assertions.ENABLED && n == 0) {
            boolean bl = false;
            String string = "Not a function type: " + kotlinType;
            throw new AssertionError((Object)string);
        }
        if (!FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType(kotlinType)) {
            return null;
        }
        n = FunctionTypesKt.contextFunctionTypeParamsCount(kotlinType);
        return kotlinType.getArguments().get(n).getType();
    }

    public static final List<KotlinType> getContextReceiverTypesFromFunctionType(KotlinType kotlinType) {
        List list;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        int n = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        if (_Assertions.ENABLED && n == 0) {
            boolean bl = false;
            String string = "Not a function type: " + kotlinType;
            throw new AssertionError((Object)string);
        }
        n = FunctionTypesKt.contextFunctionTypeParamsCount(kotlinType);
        if (n == 0) {
            list = CollectionsKt.emptyList();
        } else {
            Iterable iterable = kotlinType.getArguments().subList(0, n);
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                TypeProjection typeProjection = (TypeProjection)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(typeProjection.getType());
            }
            list = (List)collection;
        }
        return list;
    }

    public static final KotlinType getReturnTypeFromFunctionType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Not a function type: " + kotlinType;
            throw new AssertionError((Object)string);
        }
        KotlinType kotlinType2 = ((TypeProjection)CollectionsKt.last(kotlinType.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
        return kotlinType2;
    }

    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(KotlinType kotlinType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        boolean bl2 = FunctionTypesKt.isBuiltinFunctionalType(kotlinType);
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string = "Not a function type: " + kotlinType;
            throw new AssertionError((Object)string);
        }
        List<TypeProjection> list = kotlinType.getArguments();
        int n = FunctionTypesKt.contextFunctionTypeParamsCount(kotlinType) + (FunctionTypesKt.isBuiltinExtensionFunctionalType(kotlinType) ? 1 : 0);
        int n2 = list.size() - 1;
        boolean bl4 = bl = n <= n2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Not an exact function type: " + kotlinType;
            throw new AssertionError((Object)string);
        }
        return list.subList(n, n2);
    }

    public static final Name extractParameterNameFromFunctionTypeArgument(KotlinType kotlinType) {
        Object object;
        block5: {
            block4: {
                Object object2;
                StringValue stringValue;
                Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
                AnnotationDescriptor annotationDescriptor = kotlinType.getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
                if (annotationDescriptor == null) {
                    return null;
                }
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                Object object3 = CollectionsKt.singleOrNull((Iterable)annotationDescriptor2.getAllValueArguments().values());
                StringValue stringValue2 = stringValue = object3 instanceof StringValue ? (StringValue)object3 : null;
                if (stringValue == null || (object3 = (String)stringValue.getValue()) == null) break block4;
                Object object4 = object2 = object3;
                boolean bl = false;
                Object object5 = object = Name.isValidIdentifier((String)object4) ? object2 : null;
                if (object != null) break block5;
            }
            return null;
        }
        Object object6 = object;
        return Name.identifier((String)object6);
    }

    public static final List<TypeProjection> getFunctionTypeArgumentProjections(KotlinType kotlinType, List<? extends KotlinType> list, List<? extends KotlinType> list2, List<Name> list3, KotlinType kotlinType2, KotlinBuiltIns kotlinBuiltIns) {
        boolean bl;
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        ArrayList<TypeProjection> arrayList = new ArrayList<TypeProjection>(list2.size() + list.size() + (kotlinType != null ? 1 : 0) + 1);
        Iterable iterable = list;
        Collection<TypeProjection> collection = arrayList;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl3 = false;
        for (Object object2 : iterable2) {
            KotlinType kotlinType3 = (KotlinType)object2;
            Collection collection3 = collection2;
            bl = false;
            collection3.add(TypeUtilsKt.asTypeProjection(kotlinType3));
        }
        ((ArrayList)collection).addAll((List)collection2);
        KotlinType kotlinType4 = kotlinType;
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull((Collection)arrayList, kotlinType4 != null ? TypeUtilsKt.asTypeProjection(kotlinType4) : null);
        iterable = list2;
        bl2 = false;
        int n = 0;
        for (Object e : iterable) {
            Object object;
            List<Name> list4;
            List<Name> list5;
            List<Name> list6;
            int n2;
            Object object2;
            Collection collection4 = arrayList;
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object2 = (KotlinType)e;
            int n3 = n2;
            collection = collection4;
            bl = false;
            List<Name> list7 = list3;
            if (list7 != null && (list7 = list7.get(n3)) != null) {
                List<Name> list8 = list6 = list7;
                boolean bl4 = false;
                list5 = !((Name)((Object)list8)).isSpecial() ? list6 : null;
            } else {
                list5 = list4 = null;
            }
            if (list4 != null) {
                String string = ((Name)((Object)list4)).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                list6 = new BuiltInAnnotationDescriptor(kotlinBuiltIns, StandardNames.FqNames.parameterName, MapsKt.mapOf((Pair)TuplesKt.to((Object)StandardNames.NAME, (Object)new StringValue(string))), false, 8, null);
                object = TypeUtilsKt.replaceAnnotations((KotlinType)object2, Annotations.Companion.create(CollectionsKt.plus((Iterable)((KotlinType)object2).getAnnotations(), (Object)list6)));
            } else {
                object = object2;
            }
            Object object3 = object;
            collection.add(TypeUtilsKt.asTypeProjection(object3));
        }
        arrayList.add(TypeUtilsKt.asTypeProjection(kotlinType2));
        return arrayList;
    }

    public static final SimpleType createFunctionType(KotlinBuiltIns kotlinBuiltIns, Annotations annotations, KotlinType kotlinType, List<? extends KotlinType> list, List<? extends KotlinType> list2, List<Name> list3, KotlinType kotlinType2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(list2, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType2, (String)"");
        List<TypeProjection> list4 = FunctionTypesKt.getFunctionTypeArgumentProjections(kotlinType, list, list2, list3, kotlinType2, kotlinBuiltIns);
        int n = list2.size() + list.size() + (kotlinType == null ? 0 : 1);
        ClassDescriptor classDescriptor = FunctionTypesKt.getFunctionDescriptor(kotlinBuiltIns, n, bl);
        Annotations annotations2 = annotations;
        if (kotlinType != null) {
            annotations2 = FunctionTypesKt.withExtensionFunctionAnnotation(annotations2, kotlinBuiltIns);
        }
        if (!((Collection)list).isEmpty()) {
            annotations2 = FunctionTypesKt.withContextReceiversFunctionAnnotation(annotations2, kotlinBuiltIns, list.size());
        }
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes(annotations2), classDescriptor, list4);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations, KotlinType kotlinType, List list, List list2, List list3, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations, kotlinType, list, list2, list3, kotlinType2, bl);
    }

    public static final Annotations withExtensionFunctionAnnotation(Annotations annotations, KotlinBuiltIns kotlinBuiltIns) {
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        return annotations.hasAnnotation(StandardNames.FqNames.extensionFunctionType) ? annotations : Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations, (Object)new BuiltInAnnotationDescriptor(kotlinBuiltIns, StandardNames.FqNames.extensionFunctionType, MapsKt.emptyMap(), false, 8, null)));
    }

    public static final Annotations withContextReceiversFunctionAnnotation(Annotations annotations, KotlinBuiltIns kotlinBuiltIns, int n) {
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        return annotations.hasAnnotation(StandardNames.FqNames.contextFunctionTypeParams) ? annotations : Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations, (Object)new BuiltInAnnotationDescriptor(kotlinBuiltIns, StandardNames.FqNames.contextFunctionTypeParams, MapsKt.mapOf((Pair)TuplesKt.to((Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME, (Object)new IntValue(n))), false, 8, null)));
    }

    public static final ClassDescriptor getFunctionDescriptor(KotlinBuiltIns kotlinBuiltIns, int n, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        ClassDescriptor classDescriptor = bl ? kotlinBuiltIns.getSuspendFunction(n) : kotlinBuiltIns.getFunction(n);
        Intrinsics.checkNotNull((Object)classDescriptor);
        return classDescriptor;
    }
}

