/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassScope;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.SupertypeLoopChecker;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.AbstractClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.AbstractClassTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.utils.addToStdlib.AddToStdlibKt;

public final class FunctionClassDescriptor
extends AbstractClassDescriptor {
    public static final Companion Companion = new Companion(null);
    private final StorageManager storageManager;
    private final PackageFragmentDescriptor containingDeclaration;
    private final FunctionTypeKind functionTypeKind;
    private final int arity;
    private final FunctionTypeConstructor typeConstructor;
    private final FunctionClassScope memberScope;
    private final List<TypeParameterDescriptor> parameters;
    private final FunctionClassKind functionKind;
    private static final ClassId functionClassId;
    private static final ClassId kFunctionClassId;

    public FunctionClassDescriptor(StorageManager storageManager, PackageFragmentDescriptor packageFragmentDescriptor, FunctionTypeKind functionTypeKind, int n) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)packageFragmentDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)functionTypeKind, (String)"");
        super(storageManager, functionTypeKind.numberedClassName(n));
        this.storageManager = storageManager;
        this.containingDeclaration = packageFragmentDescriptor;
        this.functionTypeKind = functionTypeKind;
        this.arity = n;
        this.typeConstructor = new FunctionTypeConstructor();
        this.memberScope = new FunctionClassScope(this.storageManager, this);
        ArrayList<TypeParameterDescriptor> arrayList = new ArrayList<TypeParameterDescriptor>();
        Iterable iterable = (Iterable)new IntRange(1, this.arity);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            int n2;
            int n3 = n2 = ((IntIterator)iterator2).nextInt();
            Collection collection2 = collection;
            boolean bl3 = false;
            FunctionClassDescriptor._init_$typeParameter(arrayList, this, Variance.IN_VARIANCE, "" + 'P' + n3);
            collection2.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)collection;
        FunctionClassDescriptor._init_$typeParameter(arrayList, this, Variance.OUT_VARIANCE, "R");
        this.parameters = CollectionsKt.toList((Iterable)arrayList);
        this.functionKind = FunctionClassKind.Companion.getFunctionClassKind(this.functionTypeKind);
    }

    public final FunctionTypeKind getFunctionTypeKind() {
        return this.functionTypeKind;
    }

    public final int getArity() {
        return this.arity;
    }

    @Override
    public PackageFragmentDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    public MemberScope.Empty getStaticScope() {
        return MemberScope.Empty.INSTANCE;
    }

    @Override
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    protected FunctionClassScope getUnsubstitutedMemberScope(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        return this.memberScope;
    }

    public Void getCompanionObjectDescriptor() {
        return null;
    }

    public List<ClassConstructorDescriptor> getConstructors() {
        return CollectionsKt.emptyList();
    }

    @Override
    public ClassKind getKind() {
        return ClassKind.INTERFACE;
    }

    @Override
    public Modality getModality() {
        return Modality.ABSTRACT;
    }

    public Void getUnsubstitutedPrimaryConstructor() {
        return null;
    }

    @Override
    public DescriptorVisibility getVisibility() {
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
        return descriptorVisibility;
    }

    @Override
    public boolean isCompanionObject() {
        return false;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public boolean isFun() {
        return false;
    }

    @Override
    public boolean isValue() {
        return false;
    }

    @Override
    public boolean isExpect() {
        return false;
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public Annotations getAnnotations() {
        return Annotations.Companion.getEMPTY();
    }

    @Override
    public SourceElement getSource() {
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"");
        return sourceElement;
    }

    public List<ClassDescriptor> getSealedSubclasses() {
        return CollectionsKt.emptyList();
    }

    @Override
    public ValueClassRepresentation<SimpleType> getValueClassRepresentation() {
        return null;
    }

    @Override
    public List<TypeParameterDescriptor> getDeclaredTypeParameters() {
        return this.parameters;
    }

    public String toString() {
        String string = this.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final void _init_$typeParameter(ArrayList<TypeParameterDescriptor> arrayList, FunctionClassDescriptor functionClassDescriptor, Variance variance, String string) {
        arrayList.add(TypeParameterDescriptorImpl.createWithDefaultBound(functionClassDescriptor, Annotations.Companion.getEMPTY(), false, variance, Name.identifier(string), arrayList.size(), functionClassDescriptor.storageManager));
    }

    static {
        Name name = Name.identifier("Function");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        functionClassId = new ClassId(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, name);
        Name name2 = Name.identifier("KFunction");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
        kFunctionClassId = new ClassId(StandardNames.KOTLIN_REFLECT_FQ_NAME, name2);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    private final class FunctionTypeConstructor
    extends AbstractClassTypeConstructor {
        public FunctionTypeConstructor() {
            super(FunctionClassDescriptor.this.storageManager);
        }

        @Override
        protected Collection<KotlinType> computeSupertypes() {
            Object[] objectArray;
            List list;
            Object object = FunctionClassDescriptor.this.getFunctionTypeKind();
            if (Intrinsics.areEqual((Object)object, (Object)FunctionTypeKind.Function.INSTANCE)) {
                list = CollectionsKt.listOf((Object)functionClassId);
            } else if (Intrinsics.areEqual((Object)object, (Object)FunctionTypeKind.KFunction.INSTANCE)) {
                objectArray = new ClassId[]{kFunctionClassId, new ClassId(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, FunctionTypeKind.Function.INSTANCE.numberedClassName(FunctionClassDescriptor.this.getArity()))};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else if (Intrinsics.areEqual((Object)object, (Object)FunctionTypeKind.SuspendFunction.INSTANCE)) {
                list = CollectionsKt.listOf((Object)functionClassId);
            } else if (Intrinsics.areEqual((Object)object, (Object)FunctionTypeKind.KSuspendFunction.INSTANCE)) {
                objectArray = new ClassId[]{kFunctionClassId, new ClassId(StandardNames.COROUTINES_PACKAGE_FQ_NAME, FunctionTypeKind.SuspendFunction.INSTANCE.numberedClassName(FunctionClassDescriptor.this.getArity()))};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw new KotlinNothingValueException();
            }
            List list2 = list;
            object = FunctionClassDescriptor.this.containingDeclaration.getContainingDeclaration();
            objectArray = list2;
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)objectArray, (int)10));
            boolean bl2 = false;
            for (Object t : objectArray2) {
                ClassDescriptor classDescriptor;
                ClassId classId = (ClassId)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                if (FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)object, classId) == null) {
                    throw new IllegalStateException(("Built-in class " + classId + " not found").toString());
                }
                Iterable iterable = CollectionsKt.takeLast(this.getParameters(), (int)classDescriptor.getTypeConstructor().getParameters().size());
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl5 = false;
                for (Object t2 : iterable2) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)t2;
                    Collection collection4 = collection3;
                    boolean bl6 = false;
                    collection4.add(new TypeProjectionImpl(typeParameterDescriptor.getDefaultType()));
                }
                List list3 = (List)collection3;
                collection2.add(KotlinTypeFactory.simpleNotNullType(TypeAttributes.Companion.getEmpty(), classDescriptor, list3));
            }
            return CollectionsKt.toList((Iterable)((List)collection));
        }

        @Override
        public List<TypeParameterDescriptor> getParameters() {
            return FunctionClassDescriptor.this.parameters;
        }

        @Override
        public FunctionClassDescriptor getDeclarationDescriptor() {
            return FunctionClassDescriptor.this;
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        public String toString() {
            return this.getDeclarationDescriptor().toString();
        }

        @Override
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            return SupertypeLoopChecker.EMPTY.INSTANCE;
        }
    }
}

