/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;

public final class Visibilities {
    public static final Visibilities INSTANCE;
    private static final Map<Visibility, Integer> ORDERED_VISIBILITIES;
    private static final Public DEFAULT_VISIBILITY;

    private Visibilities() {
    }

    public final Integer compareLocal$compiler_common(Visibility visibility, Visibility visibility2) {
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"");
        Intrinsics.checkNotNullParameter((Object)visibility2, (String)"");
        if (visibility == visibility2) {
            return 0;
        }
        Integer n = ORDERED_VISIBILITIES.get(visibility);
        Integer n2 = ORDERED_VISIBILITIES.get(visibility2);
        return n == null || n2 == null || Intrinsics.areEqual((Object)n, (Object)n2) ? null : Integer.valueOf(n - n2);
    }

    public final boolean isPrivate(Visibility visibility) {
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"");
        return visibility == Private.INSTANCE || visibility == PrivateToThis.INSTANCE;
    }

    static {
        Map map;
        INSTANCE = new Visibilities();
        Map map2 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        map2.put(PrivateToThis.INSTANCE, 0);
        map2.put(Private.INSTANCE, 0);
        map2.put(Internal.INSTANCE, 1);
        map2.put(Protected.INSTANCE, 1);
        map2.put(Public.INSTANCE, 2);
        ORDERED_VISIBILITIES = MapsKt.build((Map)map);
        DEFAULT_VISIBILITY = Public.INSTANCE;
    }

    public static final class Inherited
    extends Visibility {
        public static final Inherited INSTANCE = new Inherited();

        private Inherited() {
            super("inherited", false);
        }
    }

    public static final class Internal
    extends Visibility {
        public static final Internal INSTANCE = new Internal();

        private Internal() {
            super("internal", false);
        }
    }

    public static final class InvisibleFake
    extends Visibility {
        public static final InvisibleFake INSTANCE = new InvisibleFake();

        private InvisibleFake() {
            super("invisible_fake", false);
        }
    }

    public static final class Local
    extends Visibility {
        public static final Local INSTANCE = new Local();

        private Local() {
            super("local", false);
        }
    }

    public static final class Private
    extends Visibility {
        public static final Private INSTANCE = new Private();

        private Private() {
            super("private", false);
        }
    }

    public static final class PrivateToThis
    extends Visibility {
        public static final PrivateToThis INSTANCE = new PrivateToThis();

        private PrivateToThis() {
            super("private_to_this", false);
        }

        @Override
        public String getInternalDisplayName() {
            return "private/*private to this*/";
        }
    }

    public static final class Protected
    extends Visibility {
        public static final Protected INSTANCE = new Protected();

        private Protected() {
            super("protected", true);
        }
    }

    public static final class Public
    extends Visibility {
        public static final Public INSTANCE = new Public();

        private Public() {
            super("public", true);
        }
    }

    public static final class Unknown
    extends Visibility {
        public static final Unknown INSTANCE = new Unknown();

        private Unknown() {
            super("unknown", false);
        }
    }
}

