/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.io.InputStream;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.builtins.BuiltInsResourceLoader;

public final class ReflectKotlinClassFinder
implements KotlinClassFinder {
    private final ClassLoader classLoader;
    private final BuiltInsResourceLoader builtInsResourceLoader;

    public ReflectKotlinClassFinder(ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"");
        this.classLoader = classLoader;
        this.builtInsResourceLoader = new BuiltInsResourceLoader();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KotlinClassFinder.Result findKotlinClass(String string) {
        KotlinClassFinder.Result.KotlinClass kotlinClass;
        Class<?> clazz = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, string);
        if (clazz != null) {
            Object object = clazz;
            boolean bl = false;
            ReflectKotlinClass reflectKotlinClass = ReflectKotlinClass.Factory.create((Class<?>)object);
            clazz = reflectKotlinClass;
            if (reflectKotlinClass != null) {
                object = (KotlinJvmBinaryClass)((Object)clazz);
                bl = false;
                kotlinClass = new KotlinClassFinder.Result.KotlinClass((KotlinJvmBinaryClass)object, null, 2, null);
                return kotlinClass;
            }
        }
        kotlinClass = null;
        return kotlinClass;
    }

    @Override
    public KotlinClassFinder.Result findKotlinClassOrContent(ClassId classId, JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        return this.findKotlinClass(ReflectKotlinClassFinderKt.access$toRuntimeFqName(classId));
    }

    @Override
    public KotlinClassFinder.Result findKotlinClassOrContent(JavaClass javaClass, JvmMetadataVersion jvmMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"");
        Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
        Object object = javaClass.getFqName();
        if (object == null || (object = ((FqName)object).asString()) == null) {
            return null;
        }
        return this.findKotlinClass((String)object);
    }

    @Override
    public InputStream findBuiltInsData(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        if (!fqName.startsWith(StandardNames.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        return this.builtInsResourceLoader.loadResource(BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(fqName));
    }
}

