/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;

final class SignatureSerializer {
    public static final SignatureSerializer INSTANCE = new SignatureSerializer();

    private SignatureSerializer() {
    }

    public final String methodDesc(Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])method.getParameterTypes());
        while (iterator2.hasNext()) {
            Class clazz = (Class)iterator2.next();
            Intrinsics.checkNotNull((Object)clazz);
            stringBuilder.append(ReflectClassUtilKt.getDesc(clazz));
        }
        stringBuilder.append(")");
        Class<?> clazz = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        stringBuilder.append(ReflectClassUtilKt.getDesc(clazz));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String constructorDesc(Constructor<?> constructor) {
        Intrinsics.checkNotNullParameter(constructor, (String)"");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])constructor.getParameterTypes());
        while (iterator2.hasNext()) {
            Class clazz = (Class)iterator2.next();
            Intrinsics.checkNotNull((Object)clazz);
            stringBuilder.append(ReflectClassUtilKt.getDesc(clazz));
        }
        stringBuilder.append(")V");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final String fieldDesc(Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"");
        Class<?> clazz = field.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"");
        return ReflectClassUtilKt.getDesc(clazz);
    }
}

