/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java16SealedRecordLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    private final Class<?> klass;

    public ReflectJavaClass(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        this.klass = clazz;
    }

    @Override
    public Class<?> getElement() {
        return this.klass;
    }

    @Override
    public int getModifiers() {
        return this.klass.getModifiers();
    }

    public List<Name> getInnerClassNames() {
        Class<?>[] classArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])classArray), (Function1)ReflectJavaClass$$Lambda$0.INSTANCE), (Function1)ReflectJavaClass$$Lambda$1.INSTANCE));
    }

    @Override
    public FqName getFqName() {
        return ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
    }

    @Override
    public ReflectJavaClass getOuterClass() {
        ReflectJavaClass reflectJavaClass;
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz != null) {
            Class<?> clazz2 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(clazz2);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    @Override
    public Collection<JavaClassifierType> getSupertypes() {
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        Object object = new SpreadBuilder(2);
        Type type = this.klass.getGenericSuperclass();
        if (type == null) {
            type = (Type)((Object)Object.class);
        }
        object.add((Object)type);
        object.addSpread((Object)this.klass.getGenericInterfaces());
        object = CollectionsKt.listOf((Object[])object.toArray((Object[])new Type[object.size()]));
        boolean bl = false;
        Object object2 = object;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        boolean bl2 = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            Type type2 = (Type)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new ReflectJavaClassifierType(type2));
        }
        return (List)collection;
    }

    public List<ReflectJavaMethod> getMethods() {
        Method[] methodArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"");
        ReflectJavaClass reflectJavaClass = this;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)new ReflectJavaClass$$Lambda$2(reflectJavaClass)), (Function1)methods.2.INSTANCE));
    }

    private final boolean isEnumValuesOrValueOf(Method method) {
        boolean bl;
        String string = method.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"values")) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
            bl = ((Object[])classArray).length == 0;
        } else if (Intrinsics.areEqual((Object)string, (Object)"valueOf")) {
            Object[] objectArray = new Class[]{String.class};
            bl = Arrays.equals(method.getParameterTypes(), objectArray);
        } else {
            bl = false;
        }
        return bl;
    }

    public List<ReflectJavaField> getFields() {
        Field[] fieldArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)fields.1.INSTANCE), (Function1)fields.2.INSTANCE));
    }

    public List<ReflectJavaConstructor> getConstructors() {
        Constructor<?>[] constructorArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])constructorArray), (Function1)constructors.1.INSTANCE), (Function1)constructors.2.INSTANCE));
    }

    @Override
    public boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    public LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    public Name getName() {
        Name name;
        if (this.klass.isAnonymousClass()) {
            String string = this.klass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            Name name2 = Name.identifier(StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null));
            Intrinsics.checkNotNull((Object)name2);
            name = name2;
        } else {
            Name name3 = Name.identifier(this.klass.getSimpleName());
            Intrinsics.checkNotNull((Object)name3);
            name = name3;
        }
        return name;
    }

    public List<ReflectJavaTypeParameter> getTypeParameters() {
        TypeVariable<Class<?>>[] typeVariableArray = this.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"");
        Object[] objectArray = typeVariableArray;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        Collection collection = new ArrayList(objectArray.length);
        boolean bl2 = false;
        for (Object object : objectArray2) {
            TypeVariable typeVariable = (TypeVariable)object;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new ReflectJavaTypeParameter(typeVariable));
        }
        return (List)collection;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(this.klass);
        return bl != null ? bl : false;
    }

    @Override
    public Collection<JavaRecordComponent> getRecordComponents() {
        Object[] objectArray = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(this.klass);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        Object[] objectArray3 = objectArray2;
        Collection collection = new ArrayList(objectArray2.length);
        boolean bl2 = false;
        int n = objectArray3.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2 = object = objectArray3[i];
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new ReflectJavaRecordComponent(object2));
        }
        return (List)collection;
    }

    @Override
    public boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(this.klass);
        return bl != null ? bl : false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Sequence<JavaClassifierType> getPermittedTypes() {
        Sequence sequence;
        Sequence sequence2 = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(this.klass);
        if (sequence2 != null) {
            Sequence sequence3 = sequence2;
            boolean bl = false;
            Sequence sequence4 = sequence3;
            Collection collection = new ArrayList(((Class<?>[])sequence3).length);
            boolean bl2 = false;
            for (Class<?> clazz : sequence4) {
                Type type = clazz;
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new ReflectJavaClassifierType(type));
            }
            sequence3 = CollectionsKt.asSequence((Iterable)((List)collection));
            if (sequence3 != null) {
                sequence = sequence3;
                return sequence;
            }
        }
        sequence = SequencesKt.emptySequence();
        return sequence;
    }

    public boolean equals(Object object) {
        return object instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)object).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    private static final boolean _get_innerClassNames_$lambda$0(Class clazz) {
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return ((CharSequence)string).length() == 0;
    }

    private static final Name _get_innerClassNames_$lambda$2(Class clazz) {
        Name name;
        String string;
        String string2 = string = clazz.getSimpleName();
        boolean bl = false;
        String string3 = Name.isValidIdentifier(string2) ? string : null;
        if (string3 != null) {
            string2 = string3;
            bl = false;
            name = Name.identifier(string2);
        } else {
            name = null;
        }
        return name;
    }

    private static final boolean _get_methods_$lambda$7(ReflectJavaClass reflectJavaClass, Method method) {
        boolean bl;
        if (method.isSynthetic()) {
            bl = false;
        } else if (reflectJavaClass.isEnum()) {
            Intrinsics.checkNotNull((Object)method);
            bl = !reflectJavaClass.isEnumValuesOrValueOf(method);
        } else {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ boolean accessor$ReflectJavaClass$lambda0(Class clazz) {
        return ReflectJavaClass._get_innerClassNames_$lambda$0(clazz);
    }

    static /* synthetic */ Name accessor$ReflectJavaClass$lambda1(Class clazz) {
        return ReflectJavaClass._get_innerClassNames_$lambda$2(clazz);
    }

    static /* synthetic */ boolean accessor$ReflectJavaClass$lambda2(ReflectJavaClass reflectJavaClass, Method method) {
        return ReflectJavaClass._get_methods_$lambda$7(reflectJavaClass, method);
    }

    @Override
    public List<ReflectJavaAnnotation> getAnnotations() {
        Object object = this.getElement();
        if (object == null || (object = object.getDeclaredAnnotations()) == null || (object = ReflectJavaAnnotationOwnerKt.getAnnotations(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    public ReflectJavaAnnotation findAnnotation(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Annotation[] annotationArray = this.getElement();
        return annotationArray != null && (annotationArray = annotationArray.getDeclaredAnnotations()) != null ? ReflectJavaAnnotationOwnerKt.findAnnotation(annotationArray, fqName) : null;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public Visibility getVisibility() {
        int n = this.getModifiers();
        boolean bl = false;
        return Modifier.isPublic(n) ? (Visibility)Visibilities.Public.INSTANCE : (Modifier.isPrivate(n) ? (Visibility)Visibilities.Private.INSTANCE : (Modifier.isProtected(n) ? (Modifier.isStatic(n) ? (Visibility)JavaVisibilities.ProtectedStaticVisibility.INSTANCE : (Visibility)JavaVisibilities.ProtectedAndPackage.INSTANCE) : (Visibility)JavaVisibilities.PackageVisibility.INSTANCE));
    }
}

