/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class ReflectJavaValueParameter
extends ReflectJavaElement
implements JavaValueParameter {
    private final ReflectJavaType type;
    private final Annotation[] reflectAnnotations;
    private final String reflectName;
    private final boolean isVararg;

    public ReflectJavaValueParameter(ReflectJavaType reflectJavaType, Annotation[] annotationArray, String string, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)reflectJavaType, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotationArray, (String)"");
        this.type = reflectJavaType;
        this.reflectAnnotations = annotationArray;
        this.reflectName = string;
        this.isVararg = bl;
    }

    @Override
    public ReflectJavaType getType() {
        return this.type;
    }

    @Override
    public boolean isVararg() {
        return this.isVararg;
    }

    public List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwnerKt.getAnnotations(this.reflectAnnotations);
    }

    @Override
    public ReflectJavaAnnotation findAnnotation(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return ReflectJavaAnnotationOwnerKt.findAnnotation(this.reflectAnnotations, fqName);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public Name getName() {
        Name name;
        String string = this.reflectName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            name = Name.guessByFirstCharacter(string2);
        } else {
            name = null;
        }
        return name;
    }

    public String toString() {
        return this.getClass().getName() + ": " + (this.isVararg() ? "vararg " : "") + this.getName() + ": " + this.getType();
    }
}

