/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaAnnotation;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;

public final class ReflectJavaWildcardType
extends ReflectJavaType
implements JavaWildcardType {
    private final WildcardType reflectType;
    private final Collection<JavaAnnotation> annotations;
    private final boolean isDeprecatedInJavaDoc;

    public ReflectJavaWildcardType(WildcardType wildcardType) {
        Intrinsics.checkNotNullParameter((Object)wildcardType, (String)"");
        this.reflectType = wildcardType;
        this.annotations = CollectionsKt.emptyList();
    }

    @Override
    protected WildcardType getReflectType() {
        return this.reflectType;
    }

    @Override
    public ReflectJavaType getBound() {
        ReflectJavaType reflectJavaType;
        Object[] objectArray = this.getReflectType().getUpperBounds();
        Object[] objectArray2 = this.getReflectType().getLowerBounds();
        if (objectArray.length > 1 || objectArray2.length > 1) {
            throw new UnsupportedOperationException("Wildcard types with many bounds are not yet supported: " + this.getReflectType());
        }
        if (objectArray2.length == 1) {
            Intrinsics.checkNotNull((Object)objectArray2);
            Object object = ArraysKt.single((Object[])objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
            reflectJavaType = ReflectJavaType.Factory.create((Type)object);
        } else if (objectArray.length == 1) {
            Intrinsics.checkNotNull((Object)objectArray);
            Type type = (Type)ArraysKt.single((Object[])objectArray);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)type, Object.class)) {
                Intrinsics.checkNotNull((Object)type);
                reflectJavaType = ReflectJavaType.Factory.create(type);
            } else {
                reflectJavaType = null;
            }
        } else {
            reflectJavaType = null;
        }
        return reflectJavaType;
    }

    @Override
    public boolean isExtends() {
        Type[] typeArray = this.getReflectType().getUpperBounds();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
        return !Intrinsics.areEqual((Object)ArraysKt.firstOrNull((Object[])typeArray), Object.class);
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return this.isDeprecatedInJavaDoc;
    }
}

