/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.ClassDeclaredMemberIndex$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.DeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaField;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaLoadingKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public class ClassDeclaredMemberIndex
implements DeclaredMemberIndex {
    private final JavaClass jClass;
    private final Function1<JavaMember, Boolean> memberFilter;
    private final Function1<JavaMethod, Boolean> methodFilter;
    private final Map<Name, List<JavaMethod>> methods;
    private final Map<Name, JavaField> fields;
    private final Map<Name, JavaRecordComponent> components;

    public ClassDeclaredMemberIndex(JavaClass javaClass, Function1<? super JavaMember, Boolean> function1) {
        Object object;
        boolean bl;
        Object object2;
        Object object32;
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.jClass = javaClass;
        this.memberFilter = function1;
        ClassDeclaredMemberIndex classDeclaredMemberIndex = this;
        this.methodFilter = new ClassDeclaredMemberIndex$$Lambda$0(classDeclaredMemberIndex);
        Object object4 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getMethods()), this.methodFilter);
        ClassDeclaredMemberIndex classDeclaredMemberIndex2 = this;
        boolean bl2 = false;
        Sequence sequence = object4;
        Map map = new LinkedHashMap();
        boolean bl3 = false;
        for (Object object32 : sequence) {
            Object object5;
            object2 = (JavaMethod)object32;
            bl = false;
            Name name = object2.getName();
            Map map2 = map;
            boolean bl4 = false;
            Object v = map2.get(name);
            if (v == null) {
                boolean bl5 = false;
                List list = new ArrayList();
                map2.put(name, list);
                object5 = list;
            } else {
                object5 = v;
            }
            object2 = (List)object5;
            object2.add(object32);
        }
        classDeclaredMemberIndex2.methods = map;
        object4 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getFields()), this.memberFilter);
        classDeclaredMemberIndex2 = this;
        bl2 = false;
        sequence = object4;
        map = new LinkedHashMap();
        bl3 = false;
        for (Object object32 : sequence) {
            object2 = (JavaField)object32;
            object = map;
            bl = false;
            object.put(object2.getName(), object32);
        }
        classDeclaredMemberIndex2.fields = map;
        object4 = this.jClass.getRecordComponents();
        Function1<JavaMember, Boolean> function12 = this.memberFilter;
        classDeclaredMemberIndex2 = this;
        int n = 0;
        map = object4;
        Object object6 = new ArrayList();
        boolean bl6 = false;
        object32 = map.iterator();
        while (object32.hasNext()) {
            object2 = object32.next();
            if (!((Boolean)function12.invoke(object2)).booleanValue()) continue;
            object6.add(object2);
        }
        object4 = (List)object6;
        boolean bl7 = false;
        n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10)), (int)16);
        map = object4;
        object6 = new LinkedHashMap(n);
        bl6 = false;
        object32 = map.iterator();
        while (object32.hasNext()) {
            object2 = object32.next();
            JavaRecordComponent javaRecordComponent = (JavaRecordComponent)object2;
            object = object6;
            boolean bl8 = false;
            object.put(javaRecordComponent.getName(), object2);
        }
        classDeclaredMemberIndex2.components = object6;
    }

    @Override
    public Collection<JavaMethod> findMethodsByName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        List<JavaMethod> list = this.methods.get(name);
        return list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
    }

    @Override
    public Set<Name> getMethodNames() {
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getMethods()), this.methodFilter);
        Collection collection = new LinkedHashSet();
        boolean bl = false;
        for (Object e : sequence) {
            JavaMethod javaMethod = (JavaMethod)e;
            Collection collection2 = collection;
            boolean bl2 = false;
            collection2.add(javaMethod.getName());
        }
        return (Set)collection;
    }

    @Override
    public JavaField findFieldByName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return this.fields.get(name);
    }

    @Override
    public Set<Name> getFieldNames() {
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.jClass.getFields()), this.memberFilter);
        Collection collection = new LinkedHashSet();
        boolean bl = false;
        for (Object e : sequence) {
            JavaField javaField = (JavaField)e;
            Collection collection2 = collection;
            boolean bl2 = false;
            collection2.add(javaField.getName());
        }
        return (Set)collection;
    }

    @Override
    public Set<Name> getRecordComponentNames() {
        return this.components.keySet();
    }

    @Override
    public JavaRecordComponent findRecordComponentByName(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return this.components.get(name);
    }

    private static final boolean methodFilter$lambda$0(ClassDeclaredMemberIndex classDeclaredMemberIndex, JavaMethod javaMethod) {
        Intrinsics.checkNotNullParameter((Object)javaMethod, (String)"");
        return (Boolean)classDeclaredMemberIndex.memberFilter.invoke((Object)javaMethod) != false && !JavaLoadingKt.isObjectMethodInInterface(javaMethod);
    }

    static /* synthetic */ boolean accessor$ClassDeclaredMemberIndex$lambda0(ClassDeclaredMemberIndex classDeclaredMemberIndex, JavaMethod javaMethod) {
        return ClassDeclaredMemberIndex.methodFilter$lambda$0(classDeclaredMemberIndex, javaMethod);
    }
}

