/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributes;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeFlexibility;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ErasureProjectionComputer;
import kotlin.reflect.jvm.internal.impl.types.ErasureTypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;

public final class RawProjectionComputer
extends ErasureProjectionComputer {
    @Override
    public TypeProjection computeProjection(TypeParameterDescriptor typeParameterDescriptor, ErasureTypeAttributes erasureTypeAttributes, TypeParameterUpperBoundEraser typeParameterUpperBoundEraser, KotlinType kotlinType) {
        TypeProjection typeProjection;
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)erasureTypeAttributes, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeParameterUpperBoundEraser, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        if (!(erasureTypeAttributes instanceof JavaTypeAttributes)) {
            return super.computeProjection(typeParameterDescriptor, erasureTypeAttributes, typeParameterUpperBoundEraser, kotlinType);
        }
        JavaTypeAttributes javaTypeAttributes = ((JavaTypeAttributes)erasureTypeAttributes).isRaw() ? (JavaTypeAttributes)erasureTypeAttributes : ((JavaTypeAttributes)erasureTypeAttributes).withFlexibility(JavaTypeFlexibility.INFLEXIBLE);
        switch (WhenMappings.$EnumSwitchMapping$0[javaTypeAttributes.getFlexibility().ordinal()]) {
            case 1: {
                typeProjection = new TypeProjectionImpl(Variance.INVARIANT, kotlinType);
                break;
            }
            case 2: 
            case 3: {
                if (!typeParameterDescriptor.getVariance().getAllowsOutPosition()) {
                    typeProjection = new TypeProjectionImpl(Variance.INVARIANT, DescriptorUtilsKt.getBuiltIns(typeParameterDescriptor).getNothingType());
                    break;
                }
                List<TypeParameterDescriptor> list = kotlinType.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                if (!((Collection)list).isEmpty()) {
                    typeProjection = new TypeProjectionImpl(Variance.OUT_VARIANCE, kotlinType);
                    break;
                }
                TypeProjection typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor, javaTypeAttributes);
                Intrinsics.checkNotNull((Object)typeProjection2);
                typeProjection = typeProjection2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeProjection;
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JavaTypeFlexibility.values().length];
            try {
                nArray[JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaTypeFlexibility.INFLEXIBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

