/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMapper;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAnnotationNames;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.EnhancedTypeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.JavaTypeQualifiers;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.MutabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.NullabilityQualifier;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPosition;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeComponentPositionKt;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementUtilsKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;

public final class TypeEnhancementKt {
    private static final Annotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    public static final boolean hasEnhancedNullability(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return TypeEnhancementUtilsKt.hasEnhancedNullability(SimpleClassicTypeSystemContext.INSTANCE, kotlinType);
    }

    private static final Annotations compositeAnnotationsOrSingle(List<? extends Annotations> list) {
        Annotations annotations;
        switch (list.size()) {
            case 0: {
                throw new IllegalStateException("At least one Annotations object expected".toString());
            }
            case 1: {
                annotations = (Annotations)CollectionsKt.single(list);
                break;
            }
            default: {
                annotations = new CompositeAnnotations(CollectionsKt.toList((Iterable)list));
            }
        }
        return annotations;
    }

    private static final ClassifierDescriptor enhanceMutability(ClassifierDescriptor classifierDescriptor, JavaTypeQualifiers javaTypeQualifiers, TypeComponentPosition typeComponentPosition) {
        JavaToKotlinClassMapper javaToKotlinClassMapper = JavaToKotlinClassMapper.INSTANCE;
        return !TypeComponentPositionKt.shouldEnhance(typeComponentPosition) ? null : (!(classifierDescriptor instanceof ClassDescriptor) ? null : (javaTypeQualifiers.getMutability() == MutabilityQualifier.READ_ONLY && typeComponentPosition == TypeComponentPosition.FLEXIBLE_LOWER && javaToKotlinClassMapper.isMutable((ClassDescriptor)classifierDescriptor) ? (ClassifierDescriptor)javaToKotlinClassMapper.convertMutableToReadOnly((ClassDescriptor)classifierDescriptor) : (javaTypeQualifiers.getMutability() == MutabilityQualifier.MUTABLE && typeComponentPosition == TypeComponentPosition.FLEXIBLE_UPPER && javaToKotlinClassMapper.isReadOnly((ClassDescriptor)classifierDescriptor) ? (ClassifierDescriptor)javaToKotlinClassMapper.convertReadOnlyToMutable((ClassDescriptor)classifierDescriptor) : null)));
    }

    private static final Boolean getEnhancedNullability(JavaTypeQualifiers javaTypeQualifiers, TypeComponentPosition typeComponentPosition) {
        Boolean bl;
        if (!TypeComponentPositionKt.shouldEnhance(typeComponentPosition)) {
            return null;
        }
        NullabilityQualifier nullabilityQualifier = javaTypeQualifiers.getNullability();
        switch (nullabilityQualifier == null ? -1 : WhenMappings.$EnumSwitchMapping$0[nullabilityQualifier.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    public static final Annotations getENHANCED_NULLABILITY_ANNOTATIONS() {
        return ENHANCED_NULLABILITY_ANNOTATIONS;
    }

    public static final /* synthetic */ ClassifierDescriptor access$enhanceMutability(ClassifierDescriptor classifierDescriptor, JavaTypeQualifiers javaTypeQualifiers, TypeComponentPosition typeComponentPosition) {
        return TypeEnhancementKt.enhanceMutability(classifierDescriptor, javaTypeQualifiers, typeComponentPosition);
    }

    public static final /* synthetic */ Boolean access$getEnhancedNullability(JavaTypeQualifiers javaTypeQualifiers, TypeComponentPosition typeComponentPosition) {
        return TypeEnhancementKt.getEnhancedNullability(javaTypeQualifiers, typeComponentPosition);
    }

    public static final /* synthetic */ Annotations access$compositeAnnotationsOrSingle(List list) {
        return TypeEnhancementKt.compositeAnnotationsOrSingle(list);
    }

    public static final /* synthetic */ EnhancedTypeAnnotations access$getENHANCED_MUTABILITY_ANNOTATIONS$p() {
        return ENHANCED_MUTABILITY_ANNOTATIONS;
    }

    static {
        FqName fqName = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName);
        FqName fqName2 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NullabilityQualifier.values().length];
            try {
                nArray[NullabilityQualifier.NULLABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NullabilityQualifier.NOT_NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

