/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.SpecialJvmAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoaderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.text.StringsKt;

public abstract class AbstractBinaryClassAnnotationLoader<A, S extends AnnotationsContainer<? extends A>>
implements AnnotationLoader<A> {
    public static final Companion Companion = new Companion(null);
    private final KotlinClassFinder kotlinClassFinder;

    public AbstractBinaryClassAnnotationLoader(KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
        this.kotlinClassFinder = kotlinClassFinder;
    }

    protected final KotlinClassFinder getKotlinClassFinder() {
        return this.kotlinClassFinder;
    }

    public abstract JvmMetadataVersion getJvmMetadataVersion();

    protected abstract S getAnnotationsContainer(KotlinJvmBinaryClass var1);

    protected abstract KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(ClassId var1, SourceElement var2, List<A> var3);

    @Override
    public abstract A loadAnnotation(ProtoBuf.Annotation var1, NameResolver var2);

    protected final KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotationIfNotSpecial(ClassId classId, SourceElement sourceElement, List<A> list) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (SpecialJvmAnnotations.INSTANCE.getSPECIAL_ANNOTATIONS().contains(classId)) {
            return null;
        }
        return this.loadAnnotation(classId, sourceElement, list);
    }

    private final KotlinJvmBinaryClass toBinaryClass(ProtoContainer.Class clazz) {
        SourceElement sourceElement = clazz.getSource();
        KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
        return kotlinJvmBinarySourceElement != null ? kotlinJvmBinarySourceElement.getBinaryClass() : null;
    }

    protected byte[] getCachedFileContent(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        return null;
    }

    @Override
    public List<A> loadClassAnnotations(ProtoContainer.Class clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.toBinaryClass(clazz);
        if (kotlinJvmBinaryClass == null) {
            throw new IllegalStateException(("Class for loading annotations is not found: " + clazz.debugFqName()).toString());
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        ArrayList arrayList = new ArrayList(1);
        kotlinJvmBinaryClass2.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(this, arrayList){
            final /* synthetic */ AbstractBinaryClassAnnotationLoader<A, S> this$0;
            final /* synthetic */ ArrayList<A> $result;
            {
                this.this$0 = abstractBinaryClassAnnotationLoader;
                this.$result = arrayList;
            }

            public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(ClassId classId, SourceElement sourceElement) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
                return this.this$0.loadAnnotationIfNotSpecial(classId, sourceElement, (List)this.$result);
            }

            public void visitEnd() {
            }
        }, this.getCachedFileContent(kotlinJvmBinaryClass2));
        return arrayList;
    }

    @Override
    public List<A> loadCallableAnnotations(ProtoContainer protoContainer, MessageLite messageLite, AnnotatedCallableKind annotatedCallableKind) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        if (annotatedCallableKind == AnnotatedCallableKind.PROPERTY) {
            return this.loadPropertyAnnotations(protoContainer, (ProtoBuf.Property)messageLite, PropertyRelatedElement.PROPERTY);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, messageLite, protoContainer.getNameResolver(), protoContainer.getTypeTable(), annotatedCallableKind, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature memberSignature2 = memberSignature;
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, memberSignature2, false, false, null, false, 60, null);
    }

    @Override
    public List<A> loadPropertyBackingFieldAnnotations(ProtoContainer protoContainer, ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        return this.loadPropertyAnnotations(protoContainer, property, PropertyRelatedElement.BACKING_FIELD);
    }

    @Override
    public List<A> loadPropertyDelegateFieldAnnotations(ProtoContainer protoContainer, ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        return this.loadPropertyAnnotations(protoContainer, property, PropertyRelatedElement.DELEGATE_FIELD);
    }

    private final List<A> loadPropertyAnnotations(ProtoContainer protoContainer, ProtoBuf.Property property, PropertyRelatedElement propertyRelatedElement) {
        Boolean bl = Flags.IS_CONST.get(property.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        boolean bl2 = bl;
        boolean bl3 = JvmProtoBufUtil.isMovedFromInterfaceCompanion(property);
        if (propertyRelatedElement == PropertyRelatedElement.PROPERTY) {
            MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default(property, protoContainer.getNameResolver(), protoContainer.getTypeTable(), false, true, false, 40, null);
            if (memberSignature == null) {
                return CollectionsKt.emptyList();
            }
            MemberSignature memberSignature2 = memberSignature;
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, memberSignature2, true, false, bl2, bl3, 8, null);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default(property, protoContainer.getNameResolver(), protoContainer.getTypeTable(), true, false, false, 48, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        MemberSignature memberSignature3 = memberSignature;
        boolean bl4 = StringsKt.contains$default((CharSequence)memberSignature3.getSignature(), (CharSequence)"$delegate", (boolean)false, (int)2, null);
        if (bl4 != (propertyRelatedElement == PropertyRelatedElement.DELEGATE_FIELD)) {
            return CollectionsKt.emptyList();
        }
        return this.findClassAndLoadMemberAnnotations(protoContainer, memberSignature3, true, true, bl2, bl3);
    }

    @Override
    public List<A> loadEnumEntryAnnotations(ProtoContainer protoContainer, ProtoBuf.EnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"");
        MemberSignature memberSignature = MemberSignature.Companion.fromFieldNameAndDesc(protoContainer.getNameResolver().getString(enumEntry.getName()), ClassMapperLite.mapClass(((ProtoContainer.Class)protoContainer).getClassId().asString()));
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, memberSignature, false, false, null, false, 60, null);
    }

    private final List<A> findClassAndLoadMemberAnnotations(ProtoContainer protoContainer, MemberSignature memberSignature, boolean bl, boolean bl2, Boolean bl3, boolean bl4) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.findClassWithAnnotationsAndInitializers(protoContainer, Companion.getSpecialCaseContainerClass(protoContainer, bl, bl2, bl3, bl4, this.kotlinClassFinder, this.getJvmMetadataVersion()));
        if (kotlinJvmBinaryClass == null) {
            return CollectionsKt.emptyList();
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        List list = ((AnnotationsContainer)this.getAnnotationsContainer(kotlinJvmBinaryClass2)).getMemberAnnotations().get(memberSignature);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List findClassAndLoadMemberAnnotations$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, ProtoContainer protoContainer, MemberSignature memberSignature, boolean bl, boolean bl2, Boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findClassAndLoadMemberAnnotations");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = null;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        return abstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations(protoContainer, memberSignature, bl, bl2, bl3, bl4);
    }

    @Override
    public List<A> loadValueParameterAnnotations(ProtoContainer protoContainer, MessageLite messageLite, AnnotatedCallableKind annotatedCallableKind, int n, ProtoBuf.ValueParameter valueParameter) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        Intrinsics.checkNotNullParameter((Object)valueParameter, (String)"");
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, messageLite, protoContainer.getNameResolver(), protoContainer.getTypeTable(), annotatedCallableKind, false, 16, null);
        if (memberSignature != null) {
            int n2 = n + this.computeJvmParameterIndexShift(protoContainer, messageLite);
            MemberSignature memberSignature2 = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(memberSignature, n2);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, memberSignature2, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    private final int computeJvmParameterIndexShift(ProtoContainer protoContainer, MessageLite messageLite) {
        int n;
        MessageLite messageLite2 = messageLite;
        if (messageLite2 instanceof ProtoBuf.Function) {
            n = ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Function)messageLite) ? 1 : 0;
        } else if (messageLite2 instanceof ProtoBuf.Property) {
            n = ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Property)messageLite) ? 1 : 0;
        } else if (messageLite2 instanceof ProtoBuf.Constructor) {
            Intrinsics.checkNotNull((Object)protoContainer);
            n = ((ProtoContainer.Class)protoContainer).getKind() == ProtoBuf.Class.Kind.ENUM_CLASS ? 2 : (((ProtoContainer.Class)protoContainer).isInner() ? 1 : 0);
        } else {
            throw new UnsupportedOperationException("Unsupported message: " + messageLite.getClass());
        }
        return n;
    }

    @Override
    public List<A> loadExtensionReceiverParameterAnnotations(ProtoContainer protoContainer, MessageLite messageLite, AnnotatedCallableKind annotatedCallableKind) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, messageLite, protoContainer.getNameResolver(), protoContainer.getTypeTable(), annotatedCallableKind, false, 16, null);
        if (memberSignature != null) {
            MemberSignature memberSignature2 = MemberSignature.Companion.fromMethodSignatureAndParameterIndex(memberSignature, 0);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, memberSignature2, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public List<A> loadTypeAnnotations(ProtoBuf.Type type, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        List<ProtoBuf.Annotation> list = type.getExtension(JvmProtoBuf.typeAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)annotation);
            collection2.add(this.loadAnnotation(annotation, nameResolver));
        }
        return (List)collection;
    }

    @Override
    public List<A> loadTypeParameterAnnotations(ProtoBuf.TypeParameter typeParameter, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        List<ProtoBuf.Annotation> list = typeParameter.getExtension(JvmProtoBuf.typeParameterAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            ProtoBuf.Annotation annotation = (ProtoBuf.Annotation)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)annotation);
            collection2.add(this.loadAnnotation(annotation, nameResolver));
        }
        return (List)collection;
    }

    protected final KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(ProtoContainer protoContainer, KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        if (kotlinJvmBinaryClass2 == null) {
            kotlinJvmBinaryClass2 = protoContainer instanceof ProtoContainer.Class ? this.toBinaryClass((ProtoContainer.Class)protoContainer) : null;
        }
        return kotlinJvmBinaryClass2;
    }

    protected final MemberSignature getCallableSignature(MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind annotatedCallableKind, boolean bl) {
        MemberSignature memberSignature;
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        MessageLite messageLite2 = messageLite;
        if (messageLite2 instanceof ProtoBuf.Constructor) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)messageLite, nameResolver, typeTable);
            if (method == null) {
                return null;
            }
            memberSignature = MemberSignature.Companion.fromJvmMemberSignature(method);
        } else if (messageLite2 instanceof ProtoBuf.Function) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)messageLite, nameResolver, typeTable);
            if (method == null) {
                return null;
            }
            memberSignature = MemberSignature.Companion.fromJvmMemberSignature(method);
        } else if (messageLite2 instanceof ProtoBuf.Property) {
            GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)messageLite;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
            Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
            if (jvmPropertySignature == null) {
                return null;
            }
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature2 = jvmPropertySignature;
            switch (WhenMappings.$EnumSwitchMapping$0[annotatedCallableKind.ordinal()]) {
                case 1: {
                    if (jvmPropertySignature2.hasGetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = jvmPropertySignature2.getGetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"");
                        memberSignature = MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                        break;
                    }
                    memberSignature = null;
                    break;
                }
                case 2: {
                    if (jvmPropertySignature2.hasSetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = jvmPropertySignature2.getSetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"");
                        memberSignature = MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                        break;
                    }
                    memberSignature = null;
                    break;
                }
                case 3: {
                    memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature((ProtoBuf.Property)messageLite, nameResolver, typeTable, true, true, bl);
                    break;
                }
                default: {
                    memberSignature = null;
                    break;
                }
            }
        } else {
            memberSignature = null;
        }
        return memberSignature;
    }

    public static /* synthetic */ MemberSignature getCallableSignature$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind annotatedCallableKind, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCallableSignature");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return abstractBinaryClassAnnotationLoader.getCallableSignature(messageLite, nameResolver, typeTable, annotatedCallableKind, bl);
    }

    protected final boolean isImplicitRepeatableContainer(ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        if (classId.getOuterClassId() == null || !Intrinsics.areEqual((Object)classId.getShortClassName().asString(), (Object)"Container")) {
            return false;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId, this.getJvmMetadataVersion());
        return kotlinJvmBinaryClass != null && SpecialJvmAnnotations.INSTANCE.isAnnotatedWithContainerMetaAnnotation(kotlinJvmBinaryClass);
    }

    public static abstract class AnnotationsContainer<A> {
        public abstract Map<MemberSignature, List<A>> getMemberAnnotations();
    }

    public static final class Companion {
        private Companion() {
        }

        public final KotlinJvmBinaryClass getSpecialCaseContainerClass(ProtoContainer protoContainer, boolean bl, boolean bl2, Boolean bl3, boolean bl4, KotlinClassFinder kotlinClassFinder, JvmMetadataVersion jvmMetadataVersion) {
            Object object;
            SourceElement sourceElement;
            Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
            Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
            if (bl) {
                if (bl3 == null) {
                    boolean bl5 = false;
                    String string = "isConst should not be null for property (container=" + protoContainer + ')';
                    throw new IllegalStateException(string.toString());
                }
                if (protoContainer instanceof ProtoContainer.Class && ((ProtoContainer.Class)protoContainer).getKind() == ProtoBuf.Class.Kind.INTERFACE) {
                    ClassId classId = ((ProtoContainer.Class)protoContainer).getClassId();
                    Name name = Name.identifier("DefaultImpls");
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                    return KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, classId.createNestedClassId(name), jvmMetadataVersion);
                }
                if (bl3.booleanValue() && protoContainer instanceof ProtoContainer.Package) {
                    sourceElement = protoContainer.getSource();
                    JvmPackagePartSource jvmPackagePartSource = sourceElement instanceof JvmPackagePartSource ? (JvmPackagePartSource)sourceElement : null;
                    Object object2 = object = jvmPackagePartSource != null ? jvmPackagePartSource.getFacadeClassName() : null;
                    if (object != null) {
                        String string = ((JvmClassName)object).getInternalName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                        return KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, ClassId.Companion.topLevel(new FqName(StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null))), jvmMetadataVersion);
                    }
                }
            }
            if (bl2 && protoContainer instanceof ProtoContainer.Class && ((ProtoContainer.Class)protoContainer).getKind() == ProtoBuf.Class.Kind.COMPANION_OBJECT && (object = ((ProtoContainer.Class)protoContainer).getOuterClass()) != null && (((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.CLASS || ((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.ENUM_CLASS || bl4 && (((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.INTERFACE || ((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.ANNOTATION_CLASS))) {
                sourceElement = ((ProtoContainer)object).getSource();
                KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = sourceElement instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)sourceElement : null;
                return kotlinJvmBinarySourceElement != null ? kotlinJvmBinarySourceElement.getBinaryClass() : null;
            }
            if (protoContainer instanceof ProtoContainer.Package && protoContainer.getSource() instanceof JvmPackagePartSource) {
                SourceElement sourceElement2 = protoContainer.getSource();
                Intrinsics.checkNotNull((Object)sourceElement2);
                object = (JvmPackagePartSource)sourceElement2;
                KotlinJvmBinaryClass kotlinJvmBinaryClass = ((JvmPackagePartSource)object).getKnownJvmBinaryClass();
                if (kotlinJvmBinaryClass == null) {
                    kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, ((JvmPackagePartSource)object).getClassId(), jvmMetadataVersion);
                }
                return kotlinJvmBinaryClass;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    private static final class PropertyRelatedElement
    extends Enum<PropertyRelatedElement> {
        public static final /* enum */ PropertyRelatedElement PROPERTY = new PropertyRelatedElement();
        public static final /* enum */ PropertyRelatedElement BACKING_FIELD = new PropertyRelatedElement();
        public static final /* enum */ PropertyRelatedElement DELEGATE_FIELD = new PropertyRelatedElement();
        private static final /* synthetic */ PropertyRelatedElement[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PropertyRelatedElement[] values() {
            return (PropertyRelatedElement[])$VALUES.clone();
        }

        public static PropertyRelatedElement valueOf(String string) {
            return Enum.valueOf(PropertyRelatedElement.class, string);
        }

        static {
            $VALUES = propertyRelatedElementArray = new PropertyRelatedElement[]{PropertyRelatedElement.PROPERTY, PropertyRelatedElement.BACKING_FIELD, PropertyRelatedElement.DELEGATE_FIELD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotatedCallableKind.values().length];
            try {
                nArray[AnnotatedCallableKind.PROPERTY_GETTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotatedCallableKind.PROPERTY_SETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotatedCallableKind.PROPERTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

