/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;

public final class FqNameUnsafe {
    public static final Companion Companion = new Companion(null);
    private final String fqName;
    private transient FqName safe;
    private transient FqNameUnsafe parent;
    private transient Name shortName;
    private static final Name ROOT_NAME;
    private static final Pattern SPLIT_BY_DOTS;

    public FqNameUnsafe(String string, FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        this.fqName = string;
        this.safe = fqName;
    }

    public FqNameUnsafe(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        this.fqName = string;
    }

    private FqNameUnsafe(String string, FqNameUnsafe fqNameUnsafe, Name name) {
        this.fqName = string;
        this.parent = fqNameUnsafe;
        this.shortName = name;
    }

    private final void compute() {
        int n = this.indexOfLastDotWithBackticksSupport(this.fqName);
        if (n >= 0) {
            String string = this.fqName.substring(n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            this.shortName = Name.guessByFirstCharacter(string);
            String string2 = this.fqName.substring(0, n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
            this.parent = new FqNameUnsafe(string2);
        } else {
            this.shortName = Name.guessByFirstCharacter(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    private final int indexOfLastDotWithBackticksSupport(String string) {
        boolean bl = false;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '.' && !bl) {
                return i;
            }
            if (c == '`') {
                bl = !bl;
                continue;
            }
            if (c != '\\') continue;
            --i;
        }
        return -1;
    }

    public final String asString() {
        return this.fqName;
    }

    public final boolean isSafe() {
        return this.safe != null || StringsKt.indexOf$default((CharSequence)this.asString(), (char)'<', (int)0, (boolean)false, (int)6, null) < 0;
    }

    public final FqName toSafe() {
        FqName fqName = this.safe;
        if (fqName == null) {
            FqName fqName2;
            FqName fqName3 = fqName2 = new FqName(this);
            boolean bl = false;
            this.safe = fqName3;
            fqName = fqName2;
        }
        return fqName;
    }

    public final boolean isRoot() {
        return ((CharSequence)this.fqName).length() == 0;
    }

    public final FqNameUnsafe parent() {
        FqNameUnsafe fqNameUnsafe = this.parent;
        if (fqNameUnsafe != null) {
            FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
            boolean bl = false;
            return fqNameUnsafe2;
        }
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "root";
            throw new IllegalStateException(string.toString());
        }
        this.compute();
        FqNameUnsafe fqNameUnsafe3 = this.parent;
        Intrinsics.checkNotNull((Object)fqNameUnsafe3);
        return fqNameUnsafe3;
    }

    public final FqNameUnsafe child(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        String string = this.isRoot() ? name.asString() : this.fqName + '.' + name.asString();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        return new FqNameUnsafe(string2, this, name);
    }

    public final Name shortName() {
        Name name = this.shortName;
        if (name != null) {
            Name name2 = name;
            boolean bl = false;
            return name2;
        }
        if (!(!this.isRoot())) {
            boolean bl = false;
            String string = "root";
            throw new IllegalStateException(string.toString());
        }
        this.compute();
        Name name3 = this.shortName;
        Intrinsics.checkNotNull((Object)name3);
        return name3;
    }

    public final Name shortNameOrSpecial() {
        return this.isRoot() ? ROOT_NAME : this.shortName();
    }

    public final List<Name> pathSegments() {
        return FqNameUnsafe.pathSegments$collectSegmentsOf(this);
    }

    public final boolean startsWith(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        if (this.isRoot()) {
            return false;
        }
        int n = StringsKt.indexOf$default((CharSequence)this.fqName, (char)'.', (int)0, (boolean)false, (int)6, null);
        int n2 = n == -1 ? this.fqName.length() : n;
        String string = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = string;
        return n2 == string2.length() && StringsKt.regionMatches$default((String)this.fqName, (int)0, (String)string2, (int)0, (int)n2, (boolean)false, (int)16, null);
    }

    public String toString() {
        String string;
        if (this.isRoot()) {
            String string2 = ROOT_NAME.asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        } else {
            string = this.fqName;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FqNameUnsafe)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fqName, (Object)((FqNameUnsafe)object).fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }

    private static final List<Name> pathSegments$collectSegmentsOf(FqNameUnsafe fqNameUnsafe) {
        if (fqNameUnsafe.isRoot()) {
            return new ArrayList();
        }
        List<Name> list = FqNameUnsafe.pathSegments$collectSegmentsOf(fqNameUnsafe.parent());
        list.add(fqNameUnsafe.shortName());
        return list;
    }

    public /* synthetic */ FqNameUnsafe(String string, FqNameUnsafe fqNameUnsafe, Name name, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, fqNameUnsafe, name);
    }

    static {
        Name name = Name.special("<root>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        ROOT_NAME = name;
        Pattern pattern = Pattern.compile("\\.");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"");
        SPLIT_BY_DOTS = pattern;
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final FqNameUnsafe topLevel(Name name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"");
            String string = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            return new FqNameUnsafe(string, FqName.ROOT.toUnsafe(), name, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

