/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.InputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.AbstractMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Parser;
import kotlin.reflect.jvm.internal.impl.protobuf.UninitializedMessageException;

public abstract class AbstractParser<MessageType extends MessageLite>
implements Parser<MessageType> {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();

    private UninitializedMessageException newUninitializedMessageException(MessageType MessageType) {
        if (MessageType instanceof AbstractMessageLite) {
            return ((AbstractMessageLite)MessageType).newUninitializedMessageException();
        }
        return new UninitializedMessageException((MessageLite)MessageType);
    }

    private MessageType checkMessageInitialized(MessageType MessageType) {
        if (MessageType != null && !MessageType.isInitialized()) {
            throw this.newUninitializedMessageException(MessageType).asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)MessageType);
        }
        return MessageType;
    }

    public MessageType parsePartialFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) {
        CodedInputStream codedInputStream = byteString.newCodedInput();
        MessageLite messageLite = (MessageLite)this.parsePartialFrom(codedInputStream, extensionRegistryLite);
        try {
            codedInputStream.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException.setUnfinishedMessage(messageLite);
        }
        return (MessageType)messageLite;
    }

    @Override
    public MessageType parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) {
        return this.checkMessageInitialized(this.parsePartialFrom(byteString, extensionRegistryLite));
    }

    public MessageType parsePartialFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
        MessageLite messageLite = (MessageLite)this.parsePartialFrom(codedInputStream, extensionRegistryLite);
        try {
            codedInputStream.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            throw invalidProtocolBufferException.setUnfinishedMessage(messageLite);
        }
        return (MessageType)messageLite;
    }

    @Override
    public MessageType parseFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        return this.checkMessageInitialized(this.parsePartialFrom(inputStream, extensionRegistryLite));
    }

    public MessageType parsePartialDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        int n;
        try {
            int n2 = inputStream.read();
            if (n2 == -1) {
                return null;
            }
            n = CodedInputStream.readRawVarint32(n2, inputStream);
        }
        catch (IOException iOException) {
            throw new InvalidProtocolBufferException(iOException.getMessage());
        }
        AbstractMessageLite.Builder.LimitedInputStream limitedInputStream = new AbstractMessageLite.Builder.LimitedInputStream(inputStream, n);
        return this.parsePartialFrom(limitedInputStream, extensionRegistryLite);
    }

    @Override
    public MessageType parseDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) {
        return this.checkMessageInitialized(this.parsePartialDelimitedFrom(inputStream, extensionRegistryLite));
    }
}

