/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.reflect.jvm.internal.impl.protobuf.AbstractMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.FieldSet;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLiteOrBuilder;
import kotlin.reflect.jvm.internal.impl.protobuf.Parser;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

public abstract class GeneratedMessageLite
extends AbstractMessageLite
implements Serializable {
    protected GeneratedMessageLite() {
    }

    protected GeneratedMessageLite(Builder builder) {
    }

    @Override
    public Parser<? extends MessageLite> getParserForType() {
        throw new UnsupportedOperationException("This is supposed to be overridden by subclasses.");
    }

    protected boolean parseUnknownField(CodedInputStream codedInputStream, CodedOutputStream codedOutputStream, ExtensionRegistryLite extensionRegistryLite, int n) {
        return codedInputStream.skipField(n, codedOutputStream);
    }

    protected void makeExtensionsImmutable() {
    }

    private static <MessageType extends MessageLite> boolean parseUnknownField(FieldSet<ExtensionDescriptor> fieldSet, MessageType MessageType, CodedInputStream codedInputStream, CodedOutputStream codedOutputStream, ExtensionRegistryLite extensionRegistryLite, int n) {
        int n2 = WireFormat.getTagWireType(n);
        int n3 = WireFormat.getTagFieldNumber(n);
        GeneratedExtension<MessageType, ?> generatedExtension = extensionRegistryLite.findLiteExtensionByNumber(MessageType, n3);
        boolean bl = false;
        boolean bl2 = false;
        if (generatedExtension == null) {
            bl = true;
        } else if (n2 == FieldSet.getWireFormatForFieldType(generatedExtension.descriptor.getLiteType(), false)) {
            bl2 = false;
        } else if (generatedExtension.descriptor.isRepeated && generatedExtension.descriptor.type.isPackable() && n2 == FieldSet.getWireFormatForFieldType(generatedExtension.descriptor.getLiteType(), true)) {
            bl2 = true;
        } else {
            bl = true;
        }
        if (bl) {
            return codedInputStream.skipField(n, codedOutputStream);
        }
        if (bl2) {
            int n4 = codedInputStream.readRawVarint32();
            int n5 = codedInputStream.pushLimit(n4);
            if (generatedExtension.descriptor.getLiteType() == WireFormat.FieldType.ENUM) {
                while (codedInputStream.getBytesUntilLimit() > 0) {
                    int n6 = codedInputStream.readEnum();
                    Object obj = generatedExtension.descriptor.getEnumType().findValueByNumber(n6);
                    if (obj == null) {
                        return true;
                    }
                    fieldSet.addRepeatedField(generatedExtension.descriptor, generatedExtension.singularToFieldSetType(obj));
                }
            } else {
                while (codedInputStream.getBytesUntilLimit() > 0) {
                    Object object = FieldSet.readPrimitiveField(codedInputStream, generatedExtension.descriptor.getLiteType(), false);
                    fieldSet.addRepeatedField(generatedExtension.descriptor, object);
                }
            }
            codedInputStream.popLimit(n5);
        } else {
            Object object;
            switch (generatedExtension.descriptor.getLiteJavaType()) {
                case MESSAGE: {
                    MessageLite messageLite;
                    MessageLite.Builder builder = null;
                    if (!generatedExtension.descriptor.isRepeated() && (messageLite = (MessageLite)fieldSet.getField(generatedExtension.descriptor)) != null) {
                        builder = messageLite.toBuilder();
                    }
                    if (builder == null) {
                        builder = generatedExtension.getMessageDefaultInstance().newBuilderForType();
                    }
                    if (generatedExtension.descriptor.getLiteType() == WireFormat.FieldType.GROUP) {
                        codedInputStream.readGroup(generatedExtension.getNumber(), builder, extensionRegistryLite);
                    } else {
                        codedInputStream.readMessage(builder, extensionRegistryLite);
                    }
                    object = builder.build();
                    break;
                }
                case ENUM: {
                    int n7 = codedInputStream.readEnum();
                    object = generatedExtension.descriptor.getEnumType().findValueByNumber(n7);
                    if (object != null) break;
                    codedOutputStream.writeRawVarint32(n);
                    codedOutputStream.writeUInt32NoTag(n7);
                    return true;
                }
                default: {
                    object = FieldSet.readPrimitiveField(codedInputStream, generatedExtension.descriptor.getLiteType(), false);
                }
            }
            if (generatedExtension.descriptor.isRepeated()) {
                fieldSet.addRepeatedField(generatedExtension.descriptor, generatedExtension.singularToFieldSetType(object));
            } else {
                fieldSet.setField(generatedExtension.descriptor, generatedExtension.singularToFieldSetType(object));
            }
        }
        return true;
    }

    public static <ContainingType extends MessageLite, Type> GeneratedExtension<ContainingType, Type> newSingularGeneratedExtension(ContainingType ContainingType, Type Type2, MessageLite messageLite, Internal.EnumLiteMap<?> enumLiteMap, int n, WireFormat.FieldType fieldType, Class clazz) {
        return new GeneratedExtension<ContainingType, Type>(ContainingType, Type2, messageLite, new ExtensionDescriptor(enumLiteMap, n, fieldType, false, false), clazz);
    }

    public static <ContainingType extends MessageLite, Type> GeneratedExtension<ContainingType, Type> newRepeatedGeneratedExtension(ContainingType ContainingType, MessageLite messageLite, Internal.EnumLiteMap<?> enumLiteMap, int n, WireFormat.FieldType fieldType, boolean bl, Class clazz) {
        List list = Collections.emptyList();
        return new GeneratedExtension(ContainingType, list, messageLite, new ExtensionDescriptor(enumLiteMap, n, fieldType, true, bl), clazz);
    }

    static Method getMethodOrDie(Class clazz, String string, Class ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string2 = String.valueOf(String.valueOf(clazz.getName()));
            String string3 = String.valueOf(String.valueOf(string));
            throw new RuntimeException(new StringBuilder(45 + string2.length() + string3.length()).append("Generated message class \"").append(string2).append("\" missing method \"").append(string3).append("\".").toString(), noSuchMethodException);
        }
    }

    static Object invokeOrDie(Method method, Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Couldn't use Java reflection to implement protocol message reflection.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException("Unexpected exception thrown by generated accessor method.", throwable);
        }
    }

    public static class GeneratedExtension<ContainingType extends MessageLite, Type> {
        final ContainingType containingTypeDefaultInstance;
        final Type defaultValue;
        final MessageLite messageDefaultInstance;
        final ExtensionDescriptor descriptor;
        final Class singularType;
        final Method enumValueOf;

        GeneratedExtension(ContainingType ContainingType, Type Type2, MessageLite messageLite, ExtensionDescriptor extensionDescriptor, Class clazz) {
            if (ContainingType == null) {
                throw new IllegalArgumentException("Null containingTypeDefaultInstance");
            }
            if (extensionDescriptor.getLiteType() == WireFormat.FieldType.MESSAGE && messageLite == null) {
                throw new IllegalArgumentException("Null messageDefaultInstance");
            }
            this.containingTypeDefaultInstance = ContainingType;
            this.defaultValue = Type2;
            this.messageDefaultInstance = messageLite;
            this.descriptor = extensionDescriptor;
            this.singularType = clazz;
            this.enumValueOf = Internal.EnumLite.class.isAssignableFrom(clazz) ? GeneratedMessageLite.getMethodOrDie(clazz, "valueOf", Integer.TYPE) : null;
        }

        public ContainingType getContainingTypeDefaultInstance() {
            return this.containingTypeDefaultInstance;
        }

        public int getNumber() {
            return this.descriptor.getNumber();
        }

        public MessageLite getMessageDefaultInstance() {
            return this.messageDefaultInstance;
        }

        Object fromFieldSetType(Object object) {
            if (this.descriptor.isRepeated()) {
                if (this.descriptor.getLiteJavaType() == WireFormat.JavaType.ENUM) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (Object e : (List)object) {
                        arrayList.add(this.singularFromFieldSetType(e));
                    }
                    return arrayList;
                }
                return object;
            }
            return this.singularFromFieldSetType(object);
        }

        Object singularFromFieldSetType(Object object) {
            if (this.descriptor.getLiteJavaType() == WireFormat.JavaType.ENUM) {
                return GeneratedMessageLite.invokeOrDie(this.enumValueOf, null, (Integer)object);
            }
            return object;
        }

        Object singularToFieldSetType(Object object) {
            if (this.descriptor.getLiteJavaType() == WireFormat.JavaType.ENUM) {
                return ((Internal.EnumLite)object).getNumber();
            }
            return object;
        }
    }

    static final class ExtensionDescriptor
    implements FieldSet.FieldDescriptorLite<ExtensionDescriptor> {
        final Internal.EnumLiteMap<?> enumTypeMap;
        final int number;
        final WireFormat.FieldType type;
        final boolean isRepeated;
        final boolean isPacked;

        ExtensionDescriptor(Internal.EnumLiteMap<?> enumLiteMap, int n, WireFormat.FieldType fieldType, boolean bl, boolean bl2) {
            this.enumTypeMap = enumLiteMap;
            this.number = n;
            this.type = fieldType;
            this.isRepeated = bl;
            this.isPacked = bl2;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public WireFormat.FieldType getLiteType() {
            return this.type;
        }

        @Override
        public WireFormat.JavaType getLiteJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public boolean isRepeated() {
            return this.isRepeated;
        }

        @Override
        public boolean isPacked() {
            return this.isPacked;
        }

        public Internal.EnumLiteMap<?> getEnumType() {
            return this.enumTypeMap;
        }

        @Override
        public MessageLite.Builder internalMergeFrom(MessageLite.Builder builder, MessageLite messageLite) {
            return ((Builder)builder).mergeFrom((GeneratedMessageLite)messageLite);
        }

        @Override
        public int compareTo(ExtensionDescriptor extensionDescriptor) {
            return this.number - extensionDescriptor.number;
        }
    }

    public static abstract class ExtendableBuilder<MessageType extends ExtendableMessage<MessageType>, BuilderType extends ExtendableBuilder<MessageType, BuilderType>>
    extends Builder<MessageType, BuilderType>
    implements ExtendableMessageOrBuilder<MessageType> {
        private FieldSet<ExtensionDescriptor> extensions = FieldSet.emptySet();
        private boolean extensionsIsMutable;

        protected ExtendableBuilder() {
        }

        private void ensureExtensionsIsMutable() {
            if (!this.extensionsIsMutable) {
                this.extensions = this.extensions.clone();
                this.extensionsIsMutable = true;
            }
        }

        private FieldSet<ExtensionDescriptor> buildExtensions() {
            this.extensions.makeImmutable();
            this.extensionsIsMutable = false;
            return this.extensions;
        }

        @Override
        public BuilderType clone() {
            throw new UnsupportedOperationException("This is supposed to be overridden by subclasses.");
        }

        protected boolean extensionsAreInitialized() {
            return this.extensions.isInitialized();
        }

        protected final void mergeExtensionFields(MessageType MessageType) {
            this.ensureExtensionsIsMutable();
            this.extensions.mergeFrom(((ExtendableMessage)MessageType).extensions);
        }
    }

    public static abstract class ExtendableMessage<MessageType extends ExtendableMessage<MessageType>>
    extends GeneratedMessageLite
    implements ExtendableMessageOrBuilder<MessageType> {
        private final FieldSet<ExtensionDescriptor> extensions;

        protected ExtendableMessage() {
            this.extensions = FieldSet.newFieldSet();
        }

        protected ExtendableMessage(ExtendableBuilder<MessageType, ?> extendableBuilder) {
            this.extensions = ((ExtendableBuilder)extendableBuilder).buildExtensions();
        }

        private void verifyExtensionContainingType(GeneratedExtension<MessageType, ?> generatedExtension) {
            if (generatedExtension.getContainingTypeDefaultInstance() != this.getDefaultInstanceForType()) {
                throw new IllegalArgumentException("This extension is for a different message type.  Please make sure that you are not suppressing any generics type warnings.");
            }
        }

        public final <Type> boolean hasExtension(GeneratedExtension<MessageType, Type> generatedExtension) {
            this.verifyExtensionContainingType(generatedExtension);
            return this.extensions.hasField(generatedExtension.descriptor);
        }

        public final <Type> int getExtensionCount(GeneratedExtension<MessageType, List<Type>> generatedExtension) {
            this.verifyExtensionContainingType(generatedExtension);
            return this.extensions.getRepeatedFieldCount(generatedExtension.descriptor);
        }

        public final <Type> Type getExtension(GeneratedExtension<MessageType, Type> generatedExtension) {
            this.verifyExtensionContainingType(generatedExtension);
            Object object = this.extensions.getField(generatedExtension.descriptor);
            if (object == null) {
                return generatedExtension.defaultValue;
            }
            return (Type)generatedExtension.fromFieldSetType(object);
        }

        public final <Type> Type getExtension(GeneratedExtension<MessageType, List<Type>> generatedExtension, int n) {
            this.verifyExtensionContainingType(generatedExtension);
            return (Type)generatedExtension.singularFromFieldSetType(this.extensions.getRepeatedField(generatedExtension.descriptor, n));
        }

        protected boolean extensionsAreInitialized() {
            return this.extensions.isInitialized();
        }

        @Override
        protected boolean parseUnknownField(CodedInputStream codedInputStream, CodedOutputStream codedOutputStream, ExtensionRegistryLite extensionRegistryLite, int n) {
            return GeneratedMessageLite.parseUnknownField(this.extensions, this.getDefaultInstanceForType(), codedInputStream, codedOutputStream, extensionRegistryLite, n);
        }

        @Override
        protected void makeExtensionsImmutable() {
            this.extensions.makeImmutable();
        }

        protected ExtensionWriter newExtensionWriter() {
            return new ExtensionWriter(false);
        }

        protected int extensionsSerializedSize() {
            return this.extensions.getSerializedSize();
        }

        protected class ExtensionWriter {
            private final Iterator<Map.Entry<ExtensionDescriptor, Object>> iter;
            private Map.Entry<ExtensionDescriptor, Object> next;
            private final boolean messageSetWireFormat;

            private ExtensionWriter(boolean bl) {
                this.iter = ExtendableMessage.this.extensions.iterator();
                if (this.iter.hasNext()) {
                    this.next = this.iter.next();
                }
                this.messageSetWireFormat = bl;
            }

            public void writeUntil(int n, CodedOutputStream codedOutputStream) {
                while (this.next != null && this.next.getKey().getNumber() < n) {
                    ExtensionDescriptor extensionDescriptor = this.next.getKey();
                    if (this.messageSetWireFormat && extensionDescriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !extensionDescriptor.isRepeated()) {
                        codedOutputStream.writeMessageSetExtension(extensionDescriptor.getNumber(), (MessageLite)this.next.getValue());
                    } else {
                        FieldSet.writeField(extensionDescriptor, this.next.getValue(), codedOutputStream);
                    }
                    if (this.iter.hasNext()) {
                        this.next = this.iter.next();
                        continue;
                    }
                    this.next = null;
                }
            }
        }
    }

    public static interface ExtendableMessageOrBuilder<MessageType extends ExtendableMessage>
    extends MessageLiteOrBuilder {
    }

    public static abstract class Builder<MessageType extends GeneratedMessageLite, BuilderType extends Builder>
    extends AbstractMessageLite.Builder<BuilderType> {
        private ByteString unknownFields = ByteString.EMPTY;

        protected Builder() {
        }

        @Override
        public BuilderType clone() {
            throw new UnsupportedOperationException("This is supposed to be overridden by subclasses.");
        }

        public abstract BuilderType mergeFrom(MessageType var1);

        public abstract MessageType getDefaultInstanceForType();

        public final ByteString getUnknownFields() {
            return this.unknownFields;
        }

        public final BuilderType setUnknownFields(ByteString byteString) {
            this.unknownFields = byteString;
            return (BuilderType)this;
        }
    }
}

