/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.List;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    private final Function1<ModuleDescriptor, KotlinType> computeType;

    public ArrayValue(List<? extends ConstantValue<?>> list, Function1<? super ModuleDescriptor, ? extends KotlinType> function1) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        super(list);
        this.computeType = function1;
    }

    @Override
    public KotlinType getType(ModuleDescriptor moduleDescriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Object object = this.computeType.invoke((Object)moduleDescriptor);
        KotlinType kotlinType = (KotlinType)object;
        boolean bl2 = false;
        boolean bl3 = bl = KotlinBuiltIns.isArray(kotlinType) || KotlinBuiltIns.isPrimitiveArray(kotlinType) || KotlinBuiltIns.isUnsignedArrayType(kotlinType);
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Type should be an array, but was " + kotlinType + ": " + this.getValue();
            throw new AssertionError((Object)string);
        }
        return (KotlinType)object;
    }
}

