/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.reflect.jvm.internal.impl.util.collectionUtils.ScopeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.SmartList;

public final class ChainedMemberScope
implements MemberScope {
    public static final Companion Companion = new Companion(null);
    private final String debugName;
    private final MemberScope[] scopes;

    private ChainedMemberScope(String string, MemberScope[] memberScopeArray) {
        this.debugName = string;
        this.scopes = memberScopeArray;
    }

    @Override
    public ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"");
            Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
            MemberScope[] memberScopeArray = this.scopes;
            boolean bl = false;
            Object object2 = null;
            for (MemberScope memberScope : memberScopeArray) {
                Object object3 = memberScope;
                boolean bl2 = false;
                if ((object3 = ((ResolutionScope)object3).getContributedClassifier(name, lookupLocation)) == null) continue;
                if (object3 instanceof ClassifierDescriptorWithTypeParameters && ((MemberDescriptor)object3).isExpect()) {
                    if (object2 != null) continue;
                    object2 = object3;
                    continue;
                }
                object = object3;
                break block2;
            }
            object = object2;
        }
        return object;
    }

    public Collection<PropertyDescriptor> getContributedVariables(Name name, LookupLocation lookupLocation) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        boolean bl = false;
        switch (memberScopeArray.length) {
            case 0: {
                collection = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                MemberScope memberScope = memberScopeArray[0];
                boolean bl2 = false;
                collection = memberScope.getContributedVariables(name, lookupLocation);
                break;
            }
            default: {
                Collection collection2 = null;
                int n = memberScopeArray.length;
                for (int i = 0; i < n; ++i) {
                    MemberScope memberScope;
                    MemberScope memberScope2 = memberScope = memberScopeArray[i];
                    Collection collection3 = collection2;
                    boolean bl3 = false;
                    collection2 = ScopeUtilsKt.concat(collection3, memberScope2.getContributedVariables(name, lookupLocation));
                }
                collection = collection2;
                if (collection != null) break;
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    public Collection<SimpleFunctionDescriptor> getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        boolean bl = false;
        switch (memberScopeArray.length) {
            case 0: {
                collection = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                MemberScope memberScope = memberScopeArray[0];
                boolean bl2 = false;
                collection = memberScope.getContributedFunctions(name, lookupLocation);
                break;
            }
            default: {
                Collection collection2 = null;
                int n = memberScopeArray.length;
                for (int i = 0; i < n; ++i) {
                    MemberScope memberScope;
                    MemberScope memberScope2 = memberScope = memberScopeArray[i];
                    Collection collection3 = collection2;
                    boolean bl3 = false;
                    collection2 = ScopeUtilsKt.concat(collection3, memberScope2.getContributedFunctions(name, lookupLocation));
                }
                collection = collection2;
                if (collection != null) break;
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    @Override
    public Collection<DeclarationDescriptor> getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        boolean bl = false;
        switch (memberScopeArray.length) {
            case 0: {
                collection = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                MemberScope memberScope = memberScopeArray[0];
                boolean bl2 = false;
                collection = ((ResolutionScope)memberScope).getContributedDescriptors(descriptorKindFilter, function1);
                break;
            }
            default: {
                Collection collection2 = null;
                int n = memberScopeArray.length;
                for (int i = 0; i < n; ++i) {
                    MemberScope memberScope;
                    MemberScope memberScope2 = memberScope = memberScopeArray[i];
                    Collection collection3 = collection2;
                    boolean bl3 = false;
                    collection2 = ScopeUtilsKt.concat(collection3, ((ResolutionScope)memberScope2).getContributedDescriptors(descriptorKindFilter, function1));
                }
                collection = collection2;
                if (collection != null) break;
                collection = SetsKt.emptySet();
            }
        }
        return collection;
    }

    @Override
    public Set<Name> getFunctionNames() {
        MemberScope[] memberScopeArray = this.scopes;
        Collection collection = new LinkedHashSet();
        boolean bl = false;
        for (MemberScope memberScope : memberScopeArray) {
            Object object = memberScope;
            boolean bl2 = false;
            object = object.getFunctionNames();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return (Set)collection;
    }

    @Override
    public Set<Name> getVariableNames() {
        MemberScope[] memberScopeArray = this.scopes;
        Collection collection = new LinkedHashSet();
        boolean bl = false;
        for (MemberScope memberScope : memberScopeArray) {
            Object object = memberScope;
            boolean bl2 = false;
            object = object.getVariableNames();
            CollectionsKt.addAll((Collection)collection, (Iterable)object);
        }
        return (Set)collection;
    }

    @Override
    public Set<Name> getClassifierNames() {
        return MemberScopeKt.flatMapClassifierNamesOrNull(ArraysKt.asIterable((Object[])this.scopes));
    }

    @Override
    public void recordLookup(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        MemberScope[] memberScopeArray = this.scopes;
        boolean bl = false;
        int n = memberScopeArray.length;
        for (int i = 0; i < n; ++i) {
            MemberScope memberScope;
            MemberScope memberScope2 = memberScope = memberScopeArray[i];
            boolean bl2 = false;
            memberScope2.recordLookup(name, lookupLocation);
        }
    }

    public String toString() {
        return this.debugName;
    }

    public /* synthetic */ ChainedMemberScope(String string, MemberScope[] memberScopeArray, DefaultConstructorMarker defaultConstructorMarker) {
        this(string, memberScopeArray);
    }

    public static final class Companion {
        private Companion() {
        }

        public final MemberScope create(String string, Iterable<? extends MemberScope> iterable) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter(iterable, (String)"");
            SmartList<MemberScope> smartList = new SmartList<MemberScope>();
            for (MemberScope memberScope : iterable) {
                if (memberScope == MemberScope.Empty.INSTANCE) continue;
                if (memberScope instanceof ChainedMemberScope) {
                    CollectionsKt.addAll((Collection)smartList, (Object[])((ChainedMemberScope)memberScope).scopes);
                    continue;
                }
                smartList.add(memberScope);
            }
            return this.createOrSingle$descriptors(string, (List<? extends MemberScope>)smartList);
        }

        public final MemberScope createOrSingle$descriptors(String string, List<? extends MemberScope> list) {
            MemberScope memberScope;
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Intrinsics.checkNotNullParameter(list, (String)"");
            switch (list.size()) {
                case 0: {
                    memberScope = MemberScope.Empty.INSTANCE;
                    break;
                }
                case 1: {
                    memberScope = list.get(0);
                    break;
                }
                default: {
                    Collection collection = list;
                    boolean bl = false;
                    Collection collection2 = collection;
                    memberScope = new ChainedMemberScope(string, collection2.toArray(new MemberScope[0]), null);
                }
            }
            return memberScope;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

