/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Substitutable;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.SubstitutingScope$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.SubstitutingScope$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public final class SubstitutingScope
implements MemberScope {
    private final MemberScope workerScope;
    private final Lazy substitutor$delegate;
    private final TypeSubstitutor capturingSubstitutor;
    private Map<DeclarationDescriptor, DeclarationDescriptor> substitutedDescriptors;
    private final Lazy _allDescriptors$delegate;

    public SubstitutingScope(MemberScope memberScope, TypeSubstitutor typeSubstitutor2) {
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeSubstitutor2, (String)"");
        this.workerScope = memberScope;
        Object object = typeSubstitutor2;
        this.substitutor$delegate = LazyKt.lazy((Function0)new SubstitutingScope$$Lambda$0((TypeSubstitutor)object));
        TypeSubstitution typeSubstitution = typeSubstitutor2.getSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitution, (String)"");
        this.capturingSubstitutor = CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(typeSubstitution, false, 1, null).buildSubstitutor();
        object = this;
        this._allDescriptors$delegate = LazyKt.lazy((Function0)new SubstitutingScope$$Lambda$1((SubstitutingScope)object));
    }

    private final Collection<DeclarationDescriptor> get_allDescriptors() {
        Lazy lazy = this._allDescriptors$delegate;
        return (Collection)lazy.getValue();
    }

    private final <D extends DeclarationDescriptor> D substitute(D d) {
        DeclarationDescriptor declarationDescriptor;
        if (this.capturingSubstitutor.isEmpty()) {
            return d;
        }
        if (this.substitutedDescriptors == null) {
            this.substitutedDescriptors = new HashMap();
        }
        Map<DeclarationDescriptor, DeclarationDescriptor> map = this.substitutedDescriptors;
        Intrinsics.checkNotNull(map);
        Map<DeclarationDescriptor, DeclarationDescriptor> map2 = map;
        boolean bl = false;
        DeclarationDescriptor declarationDescriptor2 = map2.get(d);
        if (declarationDescriptor2 == null) {
            Object t;
            boolean bl2 = false;
            if (d instanceof Substitutable) {
                Object t2 = ((Substitutable)((Object)d)).substitute(this.capturingSubstitutor);
                boolean bl3 = false;
                t = t2;
                if (t == null) {
                    boolean bl4 = false;
                    String string = "We expect that no conflict should happen while substitution is guaranteed to generate invariant projection, but " + d + " substitution fails";
                    throw new AssertionError((Object)string);
                }
            } else {
                throw new IllegalStateException(("Unknown descriptor in scope: " + d).toString());
            }
            DeclarationDescriptor declarationDescriptor3 = (DeclarationDescriptor)t;
            map2.put(d, declarationDescriptor3);
            declarationDescriptor = declarationDescriptor3;
        } else {
            declarationDescriptor = declarationDescriptor2;
        }
        DeclarationDescriptor declarationDescriptor4 = declarationDescriptor;
        Intrinsics.checkNotNull((Object)declarationDescriptor4);
        return (D)declarationDescriptor4;
    }

    private final <D extends DeclarationDescriptor> Collection<D> substitute(Collection<? extends D> collection) {
        if (this.capturingSubstitutor.isEmpty()) {
            return collection;
        }
        if (collection.isEmpty()) {
            return collection;
        }
        LinkedHashSet<DeclarationDescriptor> linkedHashSet = CollectionsKt.newLinkedHashSetWithExpectedSize(collection.size());
        for (DeclarationDescriptor declarationDescriptor : collection) {
            DeclarationDescriptor declarationDescriptor2 = this.substitute(declarationDescriptor);
            linkedHashSet.add(declarationDescriptor2);
        }
        return linkedHashSet;
    }

    @Override
    public Collection<? extends PropertyDescriptor> getContributedVariables(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        return this.substitute(this.workerScope.getContributedVariables(name, lookupLocation));
    }

    @Override
    public ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        ClassifierDescriptor classifierDescriptor2 = this.workerScope.getContributedClassifier(name, lookupLocation);
        if (classifierDescriptor2 != null) {
            ClassifierDescriptor classifierDescriptor3 = classifierDescriptor2;
            boolean bl = false;
            classifierDescriptor = (ClassifierDescriptor)this.substitute((DeclarationDescriptor)classifierDescriptor3);
        } else {
            classifierDescriptor = null;
        }
        return classifierDescriptor;
    }

    @Override
    public Collection<? extends SimpleFunctionDescriptor> getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        return this.substitute(this.workerScope.getContributedFunctions(name, lookupLocation));
    }

    @Override
    public Collection<DeclarationDescriptor> getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return this.get_allDescriptors();
    }

    @Override
    public Set<Name> getFunctionNames() {
        return this.workerScope.getFunctionNames();
    }

    @Override
    public Set<Name> getVariableNames() {
        return this.workerScope.getVariableNames();
    }

    @Override
    public Set<Name> getClassifierNames() {
        return this.workerScope.getClassifierNames();
    }

    @Override
    public void recordLookup(Name name, LookupLocation lookupLocation) {
        MemberScope.DefaultImpls.recordLookup(this, name, lookupLocation);
    }

    private static final TypeSubstitutor substitutor_delegate$lambda$0(TypeSubstitutor typeSubstitutor2) {
        return typeSubstitutor2.getSubstitution().buildSubstitutor();
    }

    private static final Collection _allDescriptors_delegate$lambda$1(SubstitutingScope substitutingScope) {
        return substitutingScope.substitute(ResolutionScope.DefaultImpls.getContributedDescriptors$default(substitutingScope.workerScope, null, null, 3, null));
    }

    static /* synthetic */ TypeSubstitutor accessor$SubstitutingScope$lambda0(TypeSubstitutor typeSubstitutor2) {
        return SubstitutingScope.substitutor_delegate$lambda$0(typeSubstitutor2);
    }

    static /* synthetic */ Collection accessor$SubstitutingScope$lambda1(SubstitutingScope substitutingScope) {
        return SubstitutingScope._allDescriptors_delegate$lambda$1(substitutingScope);
    }
}

