/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;

public final class ProtoBasedClassDataFinder
implements ClassDataFinder {
    private final NameResolver nameResolver;
    private final BinaryVersion metadataVersion;
    private final Function1<ClassId, SourceElement> classSource;
    private final Map<ClassId, ProtoBuf.Class> classIdToProto;

    public ProtoBasedClassDataFinder(ProtoBuf.PackageFragment packageFragment, NameResolver nameResolver, BinaryVersion binaryVersion, Function1<? super ClassId, ? extends SourceElement> function1) {
        Intrinsics.checkNotNullParameter((Object)packageFragment, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)binaryVersion, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.nameResolver = nameResolver;
        this.metadataVersion = binaryVersion;
        this.classSource = function1;
        List<ProtoBuf.Class> list = packageFragment.getClass_List();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Iterable iterable = list;
        ProtoBasedClassDataFinder protoBasedClassDataFinder = this;
        boolean bl = false;
        int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map map = new LinkedHashMap(n);
        boolean bl2 = false;
        for (Object t : iterable2) {
            ProtoBuf.Class clazz = (ProtoBuf.Class)t;
            Map map2 = map;
            boolean bl3 = false;
            map2.put(NameResolverUtilKt.getClassId(this.nameResolver, clazz.getFqName()), t);
        }
        protoBasedClassDataFinder.classIdToProto = map;
    }

    public final Collection<ClassId> getAllClassIds() {
        return this.classIdToProto.keySet();
    }

    @Override
    public ClassData findClassData(ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        ProtoBuf.Class clazz = this.classIdToProto.get(classId);
        if (clazz == null) {
            return null;
        }
        ProtoBuf.Class clazz2 = clazz;
        return new ClassData(this.nameResolver, clazz2, this.metadataVersion, (SourceElement)this.classSource.invoke((Object)classId));
    }
}

