/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;

public final class ErrorType
extends SimpleType {
    private final TypeConstructor constructor;
    private final MemberScope memberScope;
    private final ErrorTypeKind kind;
    private final List<TypeProjection> arguments;
    private final boolean isMarkedNullable;
    private final String[] formatParams;
    private final String debugMessage;

    public ErrorType(TypeConstructor typeConstructor2, MemberScope memberScope, ErrorTypeKind errorTypeKind, List<? extends TypeProjection> list, boolean bl, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)errorTypeKind), (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"");
        this.constructor = typeConstructor2;
        this.memberScope = memberScope;
        this.kind = errorTypeKind;
        this.arguments = list;
        this.isMarkedNullable = bl;
        this.formatParams = stringArray;
        String string = this.kind.getDebugMessage();
        String[] stringArray2 = this.formatParams;
        stringArray2 = Arrays.copyOf(stringArray2, stringArray2.length);
        String string2 = String.format(string, Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        this.debugMessage = string2;
    }

    public /* synthetic */ ErrorType(TypeConstructor typeConstructor2, MemberScope memberScope, ErrorTypeKind errorTypeKind, List list, boolean bl, String[] stringArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(typeConstructor2, memberScope, errorTypeKind, (List<? extends TypeProjection>)list, bl, stringArray);
    }

    @Override
    public TypeConstructor getConstructor() {
        return this.constructor;
    }

    @Override
    public MemberScope getMemberScope() {
        return this.memberScope;
    }

    public final ErrorTypeKind getKind() {
        return this.kind;
    }

    @Override
    public List<TypeProjection> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isMarkedNullable() {
        return this.isMarkedNullable;
    }

    public final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    public TypeAttributes getAttributes() {
        return TypeAttributes.Companion.getEmpty();
    }

    @Override
    public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return this;
    }

    public final ErrorType replaceArguments(List<? extends TypeProjection> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        String[] stringArray = this.formatParams;
        return new ErrorType(this.getConstructor(), this.getMemberScope(), this.kind, list, this.isMarkedNullable(), Arrays.copyOf(stringArray, stringArray.length));
    }

    @Override
    public SimpleType makeNullableAsSpecified(boolean bl) {
        String[] stringArray = this.formatParams;
        return new ErrorType(this.getConstructor(), this.getMemberScope(), this.kind, this.getArguments(), bl, Arrays.copyOf(stringArray, stringArray.length));
    }

    @Override
    public ErrorType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        return this;
    }
}

