/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typeUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.types.AbstractStubType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.StubTypeForBuilderInference;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.model.TypeVariableTypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt$$Lambda$4;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt$$Lambda$5;

public final class TypeUtilsKt {
    public static final KotlinBuiltIns getBuiltIns(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        KotlinBuiltIns kotlinBuiltIns = kotlinType.getConstructor().getBuiltIns();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinBuiltIns, (String)"");
        return kotlinBuiltIns;
    }

    public static final KotlinType makeNullable(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = TypeUtils.makeNullable(kotlinType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
        return kotlinType2;
    }

    public static final KotlinType makeNotNullable(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = TypeUtils.makeNotNullable(kotlinType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
        return kotlinType2;
    }

    public static final boolean isNothing(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return KotlinBuiltIns.isNothing(kotlinType);
    }

    public static final boolean isBoolean(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return KotlinBuiltIns.isBoolean(kotlinType);
    }

    public static final boolean isTypeParameter(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return TypeUtils.isTypeParameter(kotlinType);
    }

    public static final boolean containsTypeParameter(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return TypeUtils.contains(kotlinType, TypeUtilsKt$$Lambda$0.INSTANCE);
    }

    public static final boolean isSubtypeOf(KotlinType kotlinType, KotlinType kotlinType2) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinType2, (String)"");
        return KotlinTypeChecker.DEFAULT.isSubtypeOf(kotlinType, kotlinType2);
    }

    public static final KotlinType replaceAnnotations(KotlinType kotlinType, Annotations annotations) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotations, (String)"");
        if (kotlinType.getAnnotations().isEmpty() && annotations.isEmpty()) {
            return kotlinType;
        }
        return kotlinType.unwrap().replaceAttributes(TypeAttributesKt.replaceAnnotations(kotlinType.getAttributes(), annotations));
    }

    public static final TypeProjection createProjection(KotlinType kotlinType, Variance variance, TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)variance), (String)"");
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return new TypeProjectionImpl((typeParameterDescriptor2 != null ? typeParameterDescriptor2.getVariance() : null) == variance ? Variance.INVARIANT : variance, kotlinType);
    }

    public static final TypeProjection asTypeProjection(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return new TypeProjectionImpl(kotlinType);
    }

    public static final boolean contains(KotlinType kotlinType, Function1<? super UnwrappedType, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return TypeUtils.contains(kotlinType, function1);
    }

    public static final KotlinType replaceArgumentsWithStarProjections(KotlinType kotlinType) {
        UnwrappedType unwrappedType;
        UnwrappedType unwrappedType2;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = kotlinType;
        boolean bl = false;
        UnwrappedType unwrappedType3 = unwrappedType2 = kotlinType2.unwrap();
        if (unwrappedType3 instanceof FlexibleType) {
            SimpleType simpleType;
            Collection collection;
            Object object;
            boolean bl2;
            Collection collection2;
            Iterable iterable;
            boolean bl3;
            Iterable iterable2;
            SimpleType simpleType2;
            SimpleType simpleType3 = ((FlexibleType)unwrappedType2).getLowerBound();
            boolean bl4 = false;
            if (simpleType3.getConstructor().getParameters().isEmpty() || simpleType3.getConstructor().getDeclarationDescriptor() == null) {
                simpleType2 = simpleType3;
            } else {
                List<TypeParameterDescriptor> list = simpleType3.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                iterable2 = list;
                bl3 = false;
                iterable = iterable2;
                collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                bl2 = false;
                for (Object t : iterable) {
                    object = (TypeParameterDescriptor)t;
                    collection = collection2;
                    boolean bl5 = false;
                    collection.add(new StarProjectionImpl((TypeParameterDescriptor)object));
                }
                object = (List)collection2;
                simpleType2 = TypeSubstitutionKt.replace$default(simpleType3, (List)object, null, 2, null);
            }
            simpleType3 = ((FlexibleType)unwrappedType2).getUpperBound();
            SimpleType simpleType4 = simpleType2;
            bl4 = false;
            if (simpleType3.getConstructor().getParameters().isEmpty() || simpleType3.getConstructor().getDeclarationDescriptor() == null) {
                simpleType = simpleType3;
            } else {
                List<TypeParameterDescriptor> list = simpleType3.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                iterable2 = list;
                bl3 = false;
                iterable = iterable2;
                collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                bl2 = false;
                for (Object t : iterable) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)t;
                    collection = collection2;
                    boolean bl6 = false;
                    collection.add(new StarProjectionImpl(typeParameterDescriptor));
                }
                object = (List)collection2;
                simpleType = TypeSubstitutionKt.replace$default(simpleType3, (List)object, null, 2, null);
            }
            unwrappedType = KotlinTypeFactory.flexibleType(simpleType4, simpleType);
        } else if (unwrappedType3 instanceof SimpleType) {
            SimpleType simpleType;
            SimpleType simpleType5 = (SimpleType)unwrappedType2;
            boolean bl7 = false;
            if (simpleType5.getConstructor().getParameters().isEmpty() || simpleType5.getConstructor().getDeclarationDescriptor() == null) {
                simpleType = simpleType5;
            } else {
                List<TypeParameterDescriptor> list = simpleType5.getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                Iterable iterable = list;
                boolean bl8 = false;
                Iterable iterable3 = iterable;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl9 = false;
                for (Object t : iterable3) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)t;
                    Collection collection3 = collection;
                    boolean bl10 = false;
                    collection3.add(new StarProjectionImpl(typeParameterDescriptor));
                }
                List list2 = (List)collection;
                simpleType = TypeSubstitutionKt.replace$default(simpleType5, list2, null, 2, null);
            }
            unwrappedType = simpleType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, unwrappedType2);
    }

    public static final Set<TypeParameterDescriptor> extractTypeParametersFromUpperBounds(KotlinType kotlinType, Set<? extends TypeParameterDescriptor> set) {
        Set set2;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Set set3 = set2 = (Set)new LinkedHashSet();
        boolean bl = false;
        TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType, kotlinType, set3, set);
        return set2;
    }

    private static final void extractTypeParametersFromUpperBounds(KotlinType kotlinType, KotlinType kotlinType2, Set<TypeParameterDescriptor> set, Set<? extends TypeParameterDescriptor> set2) {
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            if (!Intrinsics.areEqual((Object)kotlinType.getConstructor(), (Object)kotlinType2.getConstructor())) {
                ((Collection)set).add(classifierDescriptor);
            } else {
                for (KotlinType kotlinType3 : ((TypeParameterDescriptor)classifierDescriptor).getUpperBounds()) {
                    Intrinsics.checkNotNull((Object)kotlinType3);
                    TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType3, kotlinType2, set, set2);
                }
            }
        } else {
            ClassifierDescriptor classifierDescriptor2 = kotlinType.getConstructor().getDeclarationDescriptor();
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifierDescriptor2 instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor2 : null;
            List<TypeParameterDescriptor> list = classifierDescriptorWithTypeParameters != null ? classifierDescriptorWithTypeParameters.getDeclaredTypeParameters() : null;
            Iterator iterator2 = ((Iterable)kotlinType.getArguments()).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int n2 = n++;
                TypeProjection typeProjection = (TypeProjection)iterator2.next();
                List<TypeParameterDescriptor> list2 = list;
                TypeParameterDescriptor typeParameterDescriptor = list2 != null ? (TypeParameterDescriptor)CollectionsKt.getOrNull(list2, (int)n2) : null;
                boolean bl = typeParameterDescriptor != null && set2 != null && set2.contains(typeParameterDescriptor);
                if (bl || typeProjection.isStarProjection() || CollectionsKt.contains((Iterable)set, (Object)typeProjection.getType().getConstructor().getDeclarationDescriptor()) || Intrinsics.areEqual((Object)typeProjection.getType().getConstructor(), (Object)kotlinType2.getConstructor())) continue;
                KotlinType kotlinType4 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"");
                TypeUtilsKt.extractTypeParametersFromUpperBounds(kotlinType4, kotlinType2, set, set2);
            }
        }
    }

    public static final boolean hasTypeParameterRecursiveBounds(TypeParameterDescriptor typeParameterDescriptor, TypeConstructor typeConstructor2, Set<? extends TypeParameterDescriptor> set) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            Iterable iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    KotlinType kotlinType = (KotlinType)t;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)kotlinType);
                    if (!(TypeUtilsKt.containsSelfTypeParameter(kotlinType, typeParameterDescriptor.getDefaultType().getConstructor(), set) && (typeConstructor2 == null || Intrinsics.areEqual((Object)kotlinType.getConstructor(), (Object)typeConstructor2)))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean hasTypeParameterRecursiveBounds$default(TypeParameterDescriptor typeParameterDescriptor, TypeConstructor typeConstructor2, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            typeConstructor2 = null;
        }
        if ((n & 4) != 0) {
            set = null;
        }
        return TypeUtilsKt.hasTypeParameterRecursiveBounds(typeParameterDescriptor, typeConstructor2, set);
    }

    private static final boolean containsSelfTypeParameter(KotlinType kotlinType, TypeConstructor typeConstructor2, Set<? extends TypeParameterDescriptor> set) {
        boolean bl;
        block6: {
            if (Intrinsics.areEqual((Object)kotlinType.getConstructor(), (Object)typeConstructor2)) {
                return true;
            }
            ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifierDescriptor instanceof ClassifierDescriptorWithTypeParameters ? (ClassifierDescriptorWithTypeParameters)classifierDescriptor : null;
            List<TypeParameterDescriptor> list = classifierDescriptorWithTypeParameters != null ? classifierDescriptorWithTypeParameters.getDeclaredTypeParameters() : null;
            Iterable iterable = CollectionsKt.withIndex((Iterable)kotlinType.getArguments());
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    boolean bl3;
                    boolean bl4;
                    IndexedValue indexedValue = (IndexedValue)t;
                    boolean bl5 = false;
                    int n = indexedValue.component1();
                    TypeProjection typeProjection = (TypeProjection)indexedValue.component2();
                    List<TypeParameterDescriptor> list2 = list;
                    TypeParameterDescriptor typeParameterDescriptor = list2 != null ? (TypeParameterDescriptor)CollectionsKt.getOrNull(list2, (int)n) : null;
                    boolean bl6 = bl4 = typeParameterDescriptor != null && set != null && set.contains(typeParameterDescriptor);
                    if (bl4 || typeProjection.isStarProjection()) {
                        bl3 = false;
                    } else {
                        KotlinType kotlinType2 = typeProjection.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
                        bl3 = TypeUtilsKt.containsSelfTypeParameter(kotlinType2, typeConstructor2, set);
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean containsTypeAliasParameters(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return TypeUtilsKt.contains(kotlinType, TypeUtilsKt$$Lambda$2.INSTANCE);
    }

    public static final boolean isTypeAliasParameter(ClassifierDescriptor classifierDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
        return classifierDescriptor instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)classifierDescriptor).getContainingDeclaration() instanceof TypeAliasDescriptor;
    }

    public static final boolean requiresTypeAliasExpansion(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return TypeUtilsKt.contains(kotlinType, TypeUtilsKt$$Lambda$4.INSTANCE);
    }

    public static final KotlinType getRepresentativeUpperBound(TypeParameterDescriptor typeParameterDescriptor) {
        KotlinType kotlinType;
        Object v4;
        block3: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            boolean bl2 = bl = !((Collection)list).isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Upper bounds should not be empty: " + typeParameterDescriptor;
                throw new AssertionError((Object)string);
            }
            List<KotlinType> list2 = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"");
            Iterable iterable = list2;
            boolean bl4 = false;
            for (Object t : iterable) {
                ClassDescriptor classDescriptor;
                KotlinType kotlinType2 = (KotlinType)t;
                boolean bl5 = false;
                ClassifierDescriptor classifierDescriptor = kotlinType2.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor2 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (!(classDescriptor2 == null ? false : (classDescriptor = classDescriptor2).getKind() != ClassKind.INTERFACE && classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS)) continue;
                v4 = t;
                break block3;
            }
            v4 = null;
        }
        if ((kotlinType = (KotlinType)v4) == null) {
            List<KotlinType> list = typeParameterDescriptor.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            Object object = CollectionsKt.first(list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"");
            kotlinType = (KotlinType)object;
        }
        return kotlinType;
    }

    public static final boolean shouldBeUpdated(KotlinType kotlinType) {
        return kotlinType == null || TypeUtilsKt.contains(kotlinType, TypeUtilsKt$$Lambda$5.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStubType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        if (kotlinType instanceof AbstractStubType) return true;
        KotlinType kotlinType2 = kotlinType;
        boolean bl = false;
        if (!(kotlinType2 instanceof DefinitelyNotNullType)) return false;
        if (!(((DefinitelyNotNullType)kotlinType2).getOriginal() instanceof AbstractStubType)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStubTypeForBuilderInference(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        if (kotlinType instanceof StubTypeForBuilderInference) return true;
        KotlinType kotlinType2 = kotlinType;
        boolean bl = false;
        if (!(kotlinType2 instanceof DefinitelyNotNullType)) return false;
        if (!(((DefinitelyNotNullType)kotlinType2).getOriginal() instanceof StubTypeForBuilderInference)) return false;
        return true;
    }

    public static final boolean isUnresolvedType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        return kotlinType instanceof ErrorType && ((ErrorType)kotlinType).getKind().isUnresolved();
    }

    public static final boolean hasTypeParameterRecursiveBounds(TypeParameterDescriptor typeParameterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"");
        return TypeUtilsKt.hasTypeParameterRecursiveBounds$default(typeParameterDescriptor, null, null, 6, null);
    }

    private static final Boolean containsTypeParameter$lambda$0(UnwrappedType unwrappedType) {
        return TypeUtils.isTypeParameter(unwrappedType);
    }

    private static final boolean containsTypeAliasParameters$lambda$13(UnwrappedType unwrappedType) {
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        ClassifierDescriptor classifierDescriptor = unwrappedType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor != null ? TypeUtilsKt.isTypeAliasParameter(classifierDescriptor) : false;
    }

    private static final boolean requiresTypeAliasExpansion$lambda$16(UnwrappedType unwrappedType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        ClassifierDescriptor classifierDescriptor = unwrappedType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            boolean bl2 = false;
            bl = classifierDescriptor2 instanceof TypeAliasDescriptor || classifierDescriptor2 instanceof TypeParameterDescriptor;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean shouldBeUpdated$lambda$23(UnwrappedType unwrappedType) {
        Intrinsics.checkNotNullParameter((Object)unwrappedType, (String)"");
        return unwrappedType instanceof StubTypeForBuilderInference || unwrappedType.getConstructor() instanceof TypeVariableTypeConstructorMarker || KotlinTypeKt.isError(unwrappedType);
    }

    static /* synthetic */ Boolean accessor$TypeUtilsKt$lambda0(UnwrappedType unwrappedType) {
        return TypeUtilsKt.containsTypeParameter$lambda$0(unwrappedType);
    }

    static /* synthetic */ boolean accessor$TypeUtilsKt$lambda2(UnwrappedType unwrappedType) {
        return TypeUtilsKt.containsTypeAliasParameters$lambda$13(unwrappedType);
    }

    static /* synthetic */ boolean accessor$TypeUtilsKt$lambda4(UnwrappedType unwrappedType) {
        return TypeUtilsKt.requiresTypeAliasExpansion$lambda$16(unwrappedType);
    }

    static /* synthetic */ boolean accessor$TypeUtilsKt$lambda5(UnwrappedType unwrappedType) {
        return TypeUtilsKt.shouldBeUpdated$lambda$23(unwrappedType);
    }
}

