/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.typesApproximation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.ClassifierNamePolicy;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.CapturedTypeConstructorKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructorSubstitution;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.ApproximationBounds;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.CapturedTypeApproximationKt$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.types.typesApproximation.TypeArgument;

public final class CapturedTypeApproximationKt {
    private static final TypeProjection toTypeProjection(TypeArgument typeArgument) {
        boolean bl = typeArgument.isConsistent();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            DescriptorRenderer descriptorRenderer = DescriptorRenderer.Companion.withOptions(CapturedTypeApproximationKt$$Lambda$0.INSTANCE);
            String string = "Only consistent enhanced type projection can be converted to type projection, but [" + descriptorRenderer.render(typeArgument.getTypeParameter()) + ": <" + descriptorRenderer.renderType(typeArgument.getInProjection()) + ", " + descriptorRenderer.renderType(typeArgument.getOutProjection()) + ">] was found";
            throw new AssertionError((Object)string);
        }
        return Intrinsics.areEqual((Object)typeArgument.getInProjection(), (Object)typeArgument.getOutProjection()) || typeArgument.getTypeParameter().getVariance() == Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl(typeArgument.getInProjection()) : (KotlinBuiltIns.isNothing(typeArgument.getInProjection()) && typeArgument.getTypeParameter().getVariance() != Variance.IN_VARIANCE ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant(typeArgument, Variance.OUT_VARIANCE), typeArgument.getOutProjection()) : (KotlinBuiltIns.isNullableAny(typeArgument.getOutProjection()) ? (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant(typeArgument, Variance.IN_VARIANCE), typeArgument.getInProjection()) : (TypeProjection)new TypeProjectionImpl(CapturedTypeApproximationKt.toTypeProjection$removeProjectionIfRedundant(typeArgument, Variance.OUT_VARIANCE), typeArgument.getOutProjection())));
    }

    private static final TypeArgument toTypeArgument(TypeProjection typeProjection, TypeParameterDescriptor typeParameterDescriptor) {
        TypeArgument typeArgument;
        switch (WhenMappings.$EnumSwitchMapping$0[TypeSubstitutor.combine(typeParameterDescriptor.getVariance(), typeProjection).ordinal()]) {
            case 1: {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                KotlinType kotlinType2 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
                typeArgument = new TypeArgument(typeParameterDescriptor, kotlinType, kotlinType2);
                break;
            }
            case 2: {
                KotlinType kotlinType = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                SimpleType simpleType = DescriptorUtilsKt.getBuiltIns(typeParameterDescriptor).getNullableAnyType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                typeArgument = new TypeArgument(typeParameterDescriptor, kotlinType, simpleType);
                break;
            }
            case 3: {
                SimpleType simpleType = DescriptorUtilsKt.getBuiltIns(typeParameterDescriptor).getNothingType();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                KotlinType kotlinType = simpleType;
                KotlinType kotlinType3 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
                typeArgument = new TypeArgument(typeParameterDescriptor, kotlinType, kotlinType3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeArgument;
    }

    public static final TypeProjection approximateCapturedTypesIfNecessary(TypeProjection typeProjection, boolean bl) {
        if (typeProjection == null) {
            return null;
        }
        if (typeProjection.isStarProjection()) {
            return typeProjection;
        }
        KotlinType kotlinType = typeProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        KotlinType kotlinType2 = kotlinType;
        if (!TypeUtils.contains(kotlinType2, CapturedTypeApproximationKt$$Lambda$1.INSTANCE)) {
            return typeProjection;
        }
        Variance variance = typeProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
        Variance variance2 = variance;
        if (variance2 == Variance.OUT_VARIANCE) {
            ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType2);
            return new TypeProjectionImpl(variance2, approximationBounds.getUpper());
        }
        if (bl) {
            KotlinType kotlinType3 = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType2).getLower();
            return new TypeProjectionImpl(variance2, kotlinType3);
        }
        return CapturedTypeApproximationKt.substituteCapturedTypesWithProjections(typeProjection);
    }

    private static final TypeProjection substituteCapturedTypesWithProjections(TypeProjection typeProjection) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(){

            public TypeProjection get(TypeConstructor typeConstructor2) {
                Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"");
                CapturedTypeConstructor capturedTypeConstructor = typeConstructor2 instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)typeConstructor2 : null;
                if (capturedTypeConstructor == null) {
                    return null;
                }
                CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor;
                if (capturedTypeConstructor2.getProjection().isStarProjection()) {
                    return new TypeProjectionImpl(Variance.OUT_VARIANCE, capturedTypeConstructor2.getProjection().getType());
                }
                return capturedTypeConstructor2.getProjection();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        return typeSubstitutor3.substituteWithoutApproximation(typeProjection);
    }

    public static final ApproximationBounds<KotlinType> approximateCapturedTypes(KotlinType kotlinType) {
        KotlinType kotlinType2;
        boolean bl;
        ArrayList arrayList;
        ArrayList arrayList2;
        block14: {
            boolean bl2;
            Object object;
            Iterable iterable3;
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.lowerIfFlexible(kotlinType));
                ApproximationBounds<KotlinType> approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(FlexibleTypesKt.upperIfFlexible(kotlinType));
                return new ApproximationBounds<KotlinType>(TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(approximationBounds.getLower()), FlexibleTypesKt.upperIfFlexible(approximationBounds2.getLower())), kotlinType), TypeWithEnhancementKt.inheritEnhancement(KotlinTypeFactory.flexibleType(FlexibleTypesKt.lowerIfFlexible(approximationBounds.getUpper()), FlexibleTypesKt.upperIfFlexible(approximationBounds2.getUpper())), kotlinType));
            }
            TypeConstructor typeConstructor2 = kotlinType.getConstructor();
            if (CapturedTypeConstructorKt.isCaptured(kotlinType)) {
                ApproximationBounds<KotlinType> approximationBounds;
                Intrinsics.checkNotNull((Object)typeConstructor2);
                TypeProjection typeProjection = ((CapturedTypeConstructor)typeConstructor2).getProjection();
                KotlinType kotlinType3 = typeProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
                KotlinType kotlinType4 = CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(kotlinType3, kotlinType);
                switch (WhenMappings.$EnumSwitchMapping$0[typeProjection.getProjectionKind().ordinal()]) {
                    case 2: {
                        approximationBounds = new ApproximationBounds<KotlinType>(kotlinType4, TypeUtilsKt.getBuiltIns(kotlinType).getNullableAnyType());
                        break;
                    }
                    case 3: {
                        SimpleType simpleType = TypeUtilsKt.getBuiltIns(kotlinType).getNothingType();
                        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                        approximationBounds = new ApproximationBounds<KotlinType>(CapturedTypeApproximationKt.approximateCapturedTypes$makeNullableIfNeeded(simpleType, kotlinType), kotlinType4);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Only nontrivial projections should have been captured, not: " + typeProjection));
                    }
                }
                return approximationBounds;
            }
            if (kotlinType.getArguments().isEmpty() || kotlinType.getArguments().size() != typeConstructor2.getParameters().size()) {
                return new ApproximationBounds<KotlinType>(kotlinType, kotlinType);
            }
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            Iterable iterable2 = kotlinType.getArguments();
            List<TypeParameterDescriptor> list = typeConstructor2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            for (Iterable iterable3 : CollectionsKt.zip((Iterable)iterable2, (Iterable)list)) {
                boolean bl3;
                TypeProjection typeProjection = (TypeProjection)iterable3.component1();
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)iterable3.component2();
                Intrinsics.checkNotNull((Object)typeParameterDescriptor);
                Object object2 = CapturedTypeApproximationKt.toTypeArgument(typeProjection, typeParameterDescriptor);
                if (typeProjection.isStarProjection()) {
                    arrayList2.add(object2);
                    bl3 = arrayList.add(object2);
                    continue;
                }
                object = CapturedTypeApproximationKt.approximateProjection(object2);
                TypeArgument typeArgument = (TypeArgument)((ApproximationBounds)object).component1();
                TypeArgument typeArgument2 = (TypeArgument)((ApproximationBounds)object).component2();
                arrayList2.add(typeArgument);
                bl3 = arrayList.add(typeArgument2);
            }
            iterable3 = arrayList2;
            boolean bl4 = false;
            if (iterable3 instanceof Collection && ((Collection)iterable3).isEmpty()) {
                bl2 = false;
            } else {
                for (Object object2 : iterable3) {
                    object = (TypeArgument)object2;
                    boolean bl5 = false;
                    if (!(!((TypeArgument)object).isConsistent())) continue;
                    bl2 = true;
                    break block14;
                }
                bl2 = bl = false;
            }
        }
        if (bl) {
            SimpleType simpleType = TypeUtilsKt.getBuiltIns(kotlinType).getNothingType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            kotlinType2 = simpleType;
        } else {
            kotlinType2 = CapturedTypeApproximationKt.replaceTypeArguments(kotlinType, arrayList2);
        }
        return new ApproximationBounds<KotlinType>(kotlinType2, CapturedTypeApproximationKt.replaceTypeArguments(kotlinType, arrayList));
    }

    private static final KotlinType replaceTypeArguments(KotlinType kotlinType, List<TypeArgument> list) {
        boolean bl;
        boolean bl2 = bl = kotlinType.getArguments().size() == list.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Incorrect type arguments " + list;
            throw new AssertionError((Object)string);
        }
        Iterable iterable = list;
        KotlinType kotlinType2 = kotlinType;
        boolean bl4 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl5 = false;
        for (Object t : iterable2) {
            TypeArgument typeArgument = (TypeArgument)t;
            Collection collection2 = collection;
            boolean bl6 = false;
            collection2.add(CapturedTypeApproximationKt.toTypeProjection(typeArgument));
        }
        return TypeSubstitutionKt.replace$default(kotlinType2, (List)collection, null, null, 6, null);
    }

    private static final ApproximationBounds<TypeArgument> approximateProjection(TypeArgument typeArgument) {
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getInProjection());
        KotlinType kotlinType = approximationBounds.component1();
        KotlinType kotlinType2 = approximationBounds.component2();
        ApproximationBounds<KotlinType> approximationBounds2 = CapturedTypeApproximationKt.approximateCapturedTypes(typeArgument.getOutProjection());
        KotlinType kotlinType3 = approximationBounds2.component1();
        KotlinType kotlinType4 = approximationBounds2.component2();
        return new ApproximationBounds<TypeArgument>(new TypeArgument(typeArgument.getTypeParameter(), kotlinType2, kotlinType3), new TypeArgument(typeArgument.getTypeParameter(), kotlinType, kotlinType4));
    }

    private static final Unit toTypeProjection$lambda$1$lambda$0(DescriptorRendererOptions descriptorRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptions, (String)"");
        descriptorRendererOptions.setClassifierNamePolicy(ClassifierNamePolicy.FULLY_QUALIFIED.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Variance toTypeProjection$removeProjectionIfRedundant(TypeArgument typeArgument, Variance variance) {
        return variance == typeArgument.getTypeParameter().getVariance() ? Variance.INVARIANT : variance;
    }

    private static final Boolean approximateCapturedTypesIfNecessary$lambda$2(UnwrappedType unwrappedType) {
        Intrinsics.checkNotNull((Object)unwrappedType);
        return CapturedTypeConstructorKt.isCaptured(unwrappedType);
    }

    private static final KotlinType approximateCapturedTypes$makeNullableIfNeeded(KotlinType kotlinType, KotlinType kotlinType2) {
        KotlinType kotlinType3 = TypeUtils.makeNullableIfNeeded(kotlinType, kotlinType2.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"");
        return kotlinType3;
    }

    static /* synthetic */ Unit accessor$CapturedTypeApproximationKt$lambda0(DescriptorRendererOptions descriptorRendererOptions) {
        return CapturedTypeApproximationKt.toTypeProjection$lambda$1$lambda$0(descriptorRendererOptions);
    }

    static /* synthetic */ Boolean accessor$CapturedTypeApproximationKt$lambda1(UnwrappedType unwrappedType) {
        return CapturedTypeApproximationKt.approximateCapturedTypesIfNecessary$lambda$2(unwrappedType);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

