/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.util.Check;

public abstract class ValueParameterCountCheck
implements Check {
    private final String description;

    private ValueParameterCountCheck(String string) {
        this.description = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String invoke(FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ ValueParameterCountCheck(String string, DefaultConstructorMarker defaultConstructorMarker) {
        this(string);
    }

    public static final class AtLeast
    extends ValueParameterCountCheck {
        private final int n;

        public AtLeast(int n) {
            super("must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), null);
            this.n = n;
        }

        @Override
        public boolean check(FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
            return functionDescriptor.getValueParameters().size() >= this.n;
        }
    }

    public static final class Equals
    extends ValueParameterCountCheck {
        private final int n;

        public Equals(int n) {
            super("must have exactly " + n + " value parameters", null);
            this.n = n;
        }

        @Override
        public boolean check(FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
            return functionDescriptor.getValueParameters().size() == this.n;
        }
    }

    public static final class NoValueParameters
    extends ValueParameterCountCheck {
        public static final NoValueParameters INSTANCE = new NoValueParameters();

        private NoValueParameters() {
            super("must have no value parameters", null);
        }

        @Override
        public boolean check(FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
            return functionDescriptor.getValueParameters().isEmpty();
        }
    }

    public static final class SingleValueParameter
    extends ValueParameterCountCheck {
        public static final SingleValueParameter INSTANCE = new SingleValueParameter();

        private SingleValueParameter() {
            super("must have a single value parameter", null);
        }

        @Override
        public boolean check(FunctionDescriptor functionDescriptor) {
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"");
            return functionDescriptor.getValueParameters().size() == 1;
        }
    }
}

